<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionDGRV1 StructType
 * @subpackage Structs
 */
class SessionDGRV1 extends AbstractStructBase
{
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\PackageDGRV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\StatusInfoDGRV1
     */
    public $statusInfo;
    /**
     * Constructor method for sessionDGRV1
     * @uses SessionDGRV1::setPackages()
     * @uses SessionDGRV1::setSessionId()
     * @uses SessionDGRV1::setStatusInfo()
     * @param \Dpd\Services\StructType\PackageDGRV1[] $packages
     * @param int $sessionId
     * @param \Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo
     */
    public function __construct(array $packages = array(), $sessionId = null, \Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo = null)
    {
        $this
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\PackageDGRV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\PackageDGRV1[] $packages
     * @return \Dpd\Services\StructType\SessionDGRV1
     */
    public function setPackages(array $packages = array())
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\PackageDGRV1 $item
     * @return \Dpd\Services\StructType\SessionDGRV1
     */
    public function addToPackages(\Dpd\Services\StructType\PackageDGRV1 $item)
    {
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \Dpd\Services\StructType\SessionDGRV1
     */
    public function setSessionId($sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \Dpd\Services\StructType\StatusInfoDGRV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo
     * @return \Dpd\Services\StructType\SessionDGRV1
     */
    public function setStatusInfo(\Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
