<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdParcelBusinessEventV1 StructType
 * @subpackage Structs
 */
class DpdParcelBusinessEventV1 extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The eventCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventCode;
    /**
     * The eventDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\DpdParcelBusinessEventDataV1[]
     */
    public $eventDataList;
    /**
     * The eventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventTime;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for dpdParcelBusinessEventV1
     * @uses DpdParcelBusinessEventV1::setCountryCode()
     * @uses DpdParcelBusinessEventV1::setEventCode()
     * @uses DpdParcelBusinessEventV1::setEventDataList()
     * @uses DpdParcelBusinessEventV1::setEventTime()
     * @uses DpdParcelBusinessEventV1::setPostalCode()
     * @uses DpdParcelBusinessEventV1::setWaybill()
     * @param string $countryCode
     * @param string $eventCode
     * @param \Dpd\Services\StructType\DpdParcelBusinessEventDataV1[] $eventDataList
     * @param string $eventTime
     * @param string $postalCode
     * @param string $waybill
     */
    public function __construct($countryCode = null, $eventCode = null, array $eventDataList = array(), $eventTime = null, $postalCode = null, $waybill = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setEventCode($eventCode)
            ->setEventDataList($eventDataList)
            ->setEventTime($eventTime)
            ->setPostalCode($postalCode)
            ->setWaybill($waybill);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get eventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->eventCode;
    }
    /**
     * Set eventCode value
     * @param string $eventCode
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setEventCode($eventCode = null)
    {
        $this->eventCode = $eventCode;
        return $this;
    }
    /**
     * Get eventDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventDataV1[]|null
     */
    public function getEventDataList()
    {
        return isset($this->eventDataList) ? $this->eventDataList : null;
    }
    /**
     * Set eventDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\DpdParcelBusinessEventDataV1[] $eventDataList
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setEventDataList(array $eventDataList = array())
    {
        if (is_null($eventDataList) || (is_array($eventDataList) && empty($eventDataList))) {
            unset($this->eventDataList);
        } else {
            $this->eventDataList = $eventDataList;
        }
        return $this;
    }
    /**
     * Add item to eventDataList value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\DpdParcelBusinessEventDataV1 $item
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function addToEventDataList(\Dpd\Services\StructType\DpdParcelBusinessEventDataV1 $item)
    {
        $this->eventDataList[] = $item;
        return $this;
    }
    /**
     * Get eventTime value
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param string $eventTime
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setEventTime($eventTime = null)
    {
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setPostalCode($postalCode = null)
    {
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \Dpd\Services\StructType\DpdParcelBusinessEventV1
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
