<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelDSPV2 StructType
 * @subpackage Structs
 */
class ParcelDSPV2 extends AbstractStructBase
{
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Waybill;
    /**
     * Constructor method for parcelDSPV2
     * @uses ParcelDSPV2::setParcelId()
     * @uses ParcelDSPV2::setReference()
     * @uses ParcelDSPV2::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setWaybill($waybill);
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \\Dpd\Services\StructType\ParcelDSPV2
     */
    public function setParcelId($parcelId = null)
    {
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \\Dpd\Services\StructType\ParcelDSPV2
     */
    public function setReference($reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->Waybill;
    }
    /**
     * Set Waybill value
     * @param string $waybill
     * @return \\Dpd\Services\StructType\ParcelDSPV2
     */
    public function setWaybill($waybill = null)
    {
        $this->Waybill = $waybill;
        return $this;
    }
}
