<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelDGRV1 StructType
 * @subpackage Structs
 */
class ParcelDGRV1 extends AbstractStructBase
{
    /**
     * The parcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcelId;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Dpd\Services\StructType\StatusInfoDGRV1
     */
    public $statusInfo;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for parcelDGRV1
     * @uses ParcelDGRV1::setParcelId()
     * @uses ParcelDGRV1::setReference()
     * @uses ParcelDGRV1::setStatusInfo()
     * @uses ParcelDGRV1::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param \\Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, \\Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setStatusInfo($statusInfo)
            ->setWaybill($waybill);
    }
    /**
     * Get parcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->parcelId;
    }
    /**
     * Set parcelId value
     * @param int $parcelId
     * @return \\Dpd\Services\StructType\ParcelDGRV1
     */
    public function setParcelId($parcelId = null)
    {
        $this->parcelId = $parcelId;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \\Dpd\Services\StructType\ParcelDGRV1
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \\Dpd\Services\StructType\StatusInfoDGRV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \\Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo
     * @return \\Dpd\Services\StructType\ParcelDGRV1
     */
    public function setStatusInfo(\\Dpd\Services\StructType\StatusInfoDGRV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \\Dpd\Services\StructType\ParcelDGRV1
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
