<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentGenerationResponseV2 StructType
 * @subpackage Structs
 */
class DocumentGenerationResponseV2 extends AbstractStructBase
{
    /**
     * The DestinationDataList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Dpd\Services\StructType\DestinationDataList
     */
    public $DestinationDataList;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentData;
    /**
     * The nonMatchingDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \\Dpd\Services\StructType\NonMatchingData[]
     */
    public $nonMatchingDataList;
    /**
     * The Session
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Dpd\Services\StructType\SessionDGRV2
     */
    public $Session;
    /**
     * Constructor method for documentGenerationResponseV2
     * @uses DocumentGenerationResponseV2::setDestinationDataList()
     * @uses DocumentGenerationResponseV2::setDocumentData()
     * @uses DocumentGenerationResponseV2::setNonMatchingDataList()
     * @uses DocumentGenerationResponseV2::setSession()
     * @param \\Dpd\Services\StructType\DestinationDataList $destinationDataList
     * @param string $documentData
     * @param \\Dpd\Services\StructType\NonMatchingData[] $nonMatchingDataList
     * @param \\Dpd\Services\StructType\SessionDGRV2 $session
     */
    public function __construct(\\Dpd\Services\StructType\DestinationDataList $destinationDataList = null, $documentData = null, array $nonMatchingDataList = array(), \\Dpd\Services\StructType\SessionDGRV2 $session = null)
    {
        $this
            ->setDestinationDataList($destinationDataList)
            ->setDocumentData($documentData)
            ->setNonMatchingDataList($nonMatchingDataList)
            ->setSession($session);
    }
    /**
     * Get DestinationDataList value
     * @return \\Dpd\Services\StructType\DestinationDataList|null
     */
    public function getDestinationDataList()
    {
        return $this->DestinationDataList;
    }
    /**
     * Set DestinationDataList value
     * @param \\Dpd\Services\StructType\DestinationDataList $destinationDataList
     * @return \\Dpd\Services\StructType\DocumentGenerationResponseV2
     */
    public function setDestinationDataList(\\Dpd\Services\StructType\DestinationDataList $destinationDataList = null)
    {
        $this->DestinationDataList = $destinationDataList;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param string $documentData
     * @return \\Dpd\Services\StructType\DocumentGenerationResponseV2
     */
    public function setDocumentData($documentData = null)
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Get nonMatchingDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Dpd\Services\StructType\NonMatchingData[]|null
     */
    public function getNonMatchingDataList()
    {
        return isset($this->nonMatchingDataList) ? $this->nonMatchingDataList : null;
    }
    /**
     * Set nonMatchingDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Dpd\Services\StructType\NonMatchingData[] $nonMatchingDataList
     * @return \\Dpd\Services\StructType\DocumentGenerationResponseV2
     */
    public function setNonMatchingDataList(array $nonMatchingDataList = array())
    {
        if (is_null($nonMatchingDataList) || (is_array($nonMatchingDataList) && empty($nonMatchingDataList))) {
            unset($this->nonMatchingDataList);
        } else {
            $this->nonMatchingDataList = $nonMatchingDataList;
        }
        return $this;
    }
    /**
     * Add item to nonMatchingDataList value
     * @throws \InvalidArgumentException
     * @param \\Dpd\Services\StructType\NonMatchingData $item
     * @return \\Dpd\Services\StructType\DocumentGenerationResponseV2
     */
    public function addToNonMatchingDataList(\\Dpd\Services\StructType\NonMatchingData $item)
    {
        $this->nonMatchingDataList[] = $item;
        return $this;
    }
    /**
     * Get Session value
     * @return \\Dpd\Services\StructType\SessionDGRV2|null
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param \\Dpd\Services\StructType\SessionDGRV2 $session
     * @return \\Dpd\Services\StructType\DocumentGenerationResponseV2
     */
    public function setSession(\\Dpd\Services\StructType\SessionDGRV2 $session = null)
    {
        $this->Session = $session;
        return $this;
    }
}
