<?php

namespace \Dpd\Services\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named generateProtocolV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateProtocolV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateProtocolV1Response|bool
     */
    public function generateProtocolV1(\\Dpd\Services\StructType\GenerateProtocolV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateProtocolV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateProtocolV2 $parameters
     * @return \\Dpd\Services\StructType\GenerateProtocolV2Response|bool
     */
    public function generateProtocolV2(\\Dpd\Services\StructType\GenerateProtocolV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateShipmentV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateShipmentV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateShipmentV1Response|bool
     */
    public function generateShipmentV1(\\Dpd\Services\StructType\GenerateShipmentV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateShipmentV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateShipmentV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateShipmentV2 $parameters
     * @return \\Dpd\Services\StructType\GenerateShipmentV2Response|bool
     */
    public function generateShipmentV2(\\Dpd\Services\StructType\GenerateShipmentV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateShipmentV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateDomesticReturnLabelV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateDomesticReturnLabelV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateDomesticReturnLabelV1Response|bool
     */
    public function generateDomesticReturnLabelV1(\\Dpd\Services\StructType\GenerateDomesticReturnLabelV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateDomesticReturnLabelV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateSpedLabelsV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateSpedLabelsV1Response|bool
     */
    public function generateSpedLabelsV1(\\Dpd\Services\StructType\GenerateSpedLabelsV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateSpedLabelsV4 $parameters
     * @return \\Dpd\Services\StructType\GenerateSpedLabelsV4Response|bool
     */
    public function generateSpedLabelsV4(\\Dpd\Services\StructType\GenerateSpedLabelsV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateSpedLabelsV3 $parameters
     * @return \\Dpd\Services\StructType\GenerateSpedLabelsV3Response|bool
     */
    public function generateSpedLabelsV3(\\Dpd\Services\StructType\GenerateSpedLabelsV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateReturnPackages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateReturnPackages $parameters
     * @return \\Dpd\Services\StructType\GenerateReturnPackagesResponse|bool
     */
    public function generateReturnPackages(\\Dpd\Services\StructType\GenerateReturnPackages $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateReturnPackages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateSpedLabelsV2 $parameters
     * @return \\Dpd\Services\StructType\GenerateSpedLabelsV2Response|bool
     */
    public function generateSpedLabelsV2(\\Dpd\Services\StructType\GenerateSpedLabelsV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV6 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV6Response|bool
     */
    public function generatePackagesNumbersV6(\\Dpd\Services\StructType\GeneratePackagesNumbersV6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV7
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV7 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV7Response|bool
     */
    public function generatePackagesNumbersV7(\\Dpd\Services\StructType\GeneratePackagesNumbersV7 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV7($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV8
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV8 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV8Response|bool
     */
    public function generatePackagesNumbersV8(\\Dpd\Services\StructType\GeneratePackagesNumbersV8 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV8($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV9
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV9 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV9Response|bool
     */
    public function generatePackagesNumbersV9(\\Dpd\Services\StructType\GeneratePackagesNumbersV9 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV9($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateInternationalPackageNumbersV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateInternationalPackageNumbersV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateInternationalPackageNumbersV1Response|bool
     */
    public function generateInternationalPackageNumbersV1(\\Dpd\Services\StructType\GenerateInternationalPackageNumbersV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateInternationalPackageNumbersV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV1 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV1Response|bool
     */
    public function generatePackagesNumbersV1(\\Dpd\Services\StructType\GeneratePackagesNumbersV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV2 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV2Response|bool
     */
    public function generatePackagesNumbersV2(\\Dpd\Services\StructType\GeneratePackagesNumbersV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV3 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV3Response|bool
     */
    public function generatePackagesNumbersV3(\\Dpd\Services\StructType\GeneratePackagesNumbersV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV4 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV4Response|bool
     */
    public function generatePackagesNumbersV4(\\Dpd\Services\StructType\GeneratePackagesNumbersV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GeneratePackagesNumbersV5 $parameters
     * @return \\Dpd\Services\StructType\GeneratePackagesNumbersV5Response|bool
     */
    public function generatePackagesNumbersV5(\\Dpd\Services\StructType\GeneratePackagesNumbersV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateReturnLabelV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateReturnLabelV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateReturnLabelV1Response|bool
     */
    public function generateReturnLabelV1(\\Dpd\Services\StructType\GenerateReturnLabelV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateReturnLabelV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateProtocolsWithDestinationsV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV1 $parameters
     * @return \\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV1Response|bool
     */
    public function generateProtocolsWithDestinationsV1(\\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolsWithDestinationsV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateProtocolsWithDestinationsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV2 $parameters
     * @return \\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV2Response|bool
     */
    public function generateProtocolsWithDestinationsV2(\\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolsWithDestinationsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Dpd\Services\StructType\GenerateDomesticReturnLabelV1Response|\\Dpd\Services\StructType\GenerateInternationalPackageNumbersV1Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV1Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV2Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV3Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV4Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV5Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV6Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV7Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV8Response|\\Dpd\Services\StructType\GeneratePackagesNumbersV9Response|\\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV1Response|\\Dpd\Services\StructType\GenerateProtocolsWithDestinationsV2Response|\\Dpd\Services\StructType\GenerateProtocolV1Response|\\Dpd\Services\StructType\GenerateProtocolV2Response|\\Dpd\Services\StructType\GenerateReturnLabelV1Response|\\Dpd\Services\StructType\GenerateReturnPackagesResponse|\\Dpd\Services\StructType\GenerateShipmentV1Response|\\Dpd\Services\StructType\GenerateShipmentV2Response|\\Dpd\Services\StructType\GenerateSpedLabelsV1Response|\\Dpd\Services\StructType\GenerateSpedLabelsV2Response|\\Dpd\Services\StructType\GenerateSpedLabelsV3Response|\\Dpd\Services\StructType\GenerateSpedLabelsV4Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
