<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionPGRV1 StructType
 * @subpackage Structs
 */
class SessionPGRV1 extends AbstractStructBase
{
    /**
     * The beginTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endTime;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \\Dpd\Services\StructType\PackagePGRV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for sessionPGRV1
     * @uses SessionPGRV1::setBeginTime()
     * @uses SessionPGRV1::setEndTime()
     * @uses SessionPGRV1::setPackages()
     * @uses SessionPGRV1::setSessionId()
     * @uses SessionPGRV1::setStatus()
     * @param string $beginTime
     * @param string $endTime
     * @param \\Dpd\Services\StructType\PackagePGRV1[] $packages
     * @param int $sessionId
     * @param string $status
     */
    public function __construct($beginTime = null, $endTime = null, array $packages = array(), $sessionId = null, $status = null)
    {
        $this
            ->setBeginTime($beginTime)
            ->setEndTime($endTime)
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatus($status);
    }
    /**
     * Get beginTime value
     * @return string|null
     */
    public function getBeginTime()
    {
        return $this->beginTime;
    }
    /**
     * Set beginTime value
     * @param string $beginTime
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function setBeginTime($beginTime = null)
    {
        $this->beginTime = $beginTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function setEndTime($endTime = null)
    {
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Dpd\Services\StructType\PackagePGRV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Dpd\Services\StructType\PackagePGRV1[] $packages
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function setPackages(array $packages = array())
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \\Dpd\Services\StructType\PackagePGRV1 $item
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function addToPackages(\\Dpd\Services\StructType\PackagePGRV1 $item)
    {
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function setSessionId($sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \\Dpd\Services\StructType\SessionPGRV1
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
}
