<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageDGRV2 StructType
 * @subpackage Structs
 */
class PackageDGRV2 extends AbstractStructBase
{
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \\Dpd\Services\StructType\ParcelDGRV2[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Dpd\Services\StructType\StatusInfoDGRV2
     */
    public $statusInfo;
    /**
     * Constructor method for packageDGRV2
     * @uses PackageDGRV2::setPackageId()
     * @uses PackageDGRV2::setParcels()
     * @uses PackageDGRV2::setReference()
     * @uses PackageDGRV2::setStatusInfo()
     * @param int $packageId
     * @param \\Dpd\Services\StructType\ParcelDGRV2[] $parcels
     * @param string $reference
     * @param \\Dpd\Services\StructType\StatusInfoDGRV2 $statusInfo
     */
    public function __construct($packageId = null, array $parcels = array(), $reference = null, \\Dpd\Services\StructType\StatusInfoDGRV2 $statusInfo = null)
    {
        $this
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \\Dpd\Services\StructType\PackageDGRV2
     */
    public function setPackageId($packageId = null)
    {
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Dpd\Services\StructType\ParcelDGRV2[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Dpd\Services\StructType\ParcelDGRV2[] $parcels
     * @return \\Dpd\Services\StructType\PackageDGRV2
     */
    public function setParcels(array $parcels = array())
    {
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \\Dpd\Services\StructType\ParcelDGRV2 $item
     * @return \\Dpd\Services\StructType\PackageDGRV2
     */
    public function addToParcels(\\Dpd\Services\StructType\ParcelDGRV2 $item)
    {
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \\Dpd\Services\StructType\PackageDGRV2
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \\Dpd\Services\StructType\StatusInfoDGRV2|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \\Dpd\Services\StructType\StatusInfoDGRV2 $statusInfo
     * @return \\Dpd\Services\StructType\PackageDGRV2
     */
    public function setStatusInfo(\\Dpd\Services\StructType\StatusInfoDGRV2 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
