<?php

namespace \Dpd\Services\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Packages ServiceType
 * @subpackage Services
 */
class Packages extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named packagesPickupCallV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\PackagesPickupCallV3 $parameters
     * @return \\Dpd\Services\StructType\PackagesPickupCallV3Response|bool
     */
    public function packagesPickupCallV3(\\Dpd\Services\StructType\PackagesPickupCallV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\PackagesPickupCallV4 $parameters
     * @return \\Dpd\Services\StructType\PackagesPickupCallV4Response|bool
     */
    public function packagesPickupCallV4(\\Dpd\Services\StructType\PackagesPickupCallV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\PackagesPickupCallV1 $parameters
     * @return \\Dpd\Services\StructType\PackagesPickupCallV1Response|bool
     */
    public function packagesPickupCallV1(\\Dpd\Services\StructType\PackagesPickupCallV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named packagesPickupCallV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\PackagesPickupCallV2 $parameters
     * @return \\Dpd\Services\StructType\PackagesPickupCallV2Response|bool
     */
    public function packagesPickupCallV2(\\Dpd\Services\StructType\PackagesPickupCallV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->packagesPickupCallV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Dpd\Services\StructType\PackagesPickupCallV1Response|\\Dpd\Services\StructType\PackagesPickupCallV2Response|\\Dpd\Services\StructType\PackagesPickupCallV3Response|\\Dpd\Services\StructType\PackagesPickupCallV4Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
