<?php

namespace \Dpd\Services\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findPostalCodeV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\FindPostalCodeV1 $parameters
     * @return \\Dpd\Services\StructType\FindPostalCodeV1Response|bool
     */
    public function findPostalCodeV1(\\Dpd\Services\StructType\FindPostalCodeV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPostalCodeV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Dpd\Services\StructType\FindPostalCodeV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
