<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for returnedWaybillsV1 StructType
 * @subpackage Structs
 */
class ReturnedWaybillsV1 extends AbstractStructBase
{
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $waybill;
    /**
     * Constructor method for returnedWaybillsV1
     * @uses ReturnedWaybillsV1::setWaybill()
     * @param string[] $waybill
     */
    public function __construct(array $waybill = array())
    {
        $this
            ->setWaybill($waybill);
    }
    /**
     * Get waybill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWaybill()
    {
        return isset($this->waybill) ? $this->waybill : null;
    }
    /**
     * Set waybill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string[] $waybill
     * @return \\Dpd\Services\StructType\ReturnedWaybillsV1
     */
    public function setWaybill(array $waybill = array())
    {
        if (is_null($waybill) || (is_array($waybill) && empty($waybill))) {
            unset($this->waybill);
        } else {
            $this->waybill = $waybill;
        }
        return $this;
    }
    /**
     * Add item to waybill value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\Dpd\Services\StructType\ReturnedWaybillsV1
     */
    public function addToWaybill($item)
    {
        $this->waybill[] = $item;
        return $this;
    }
}
