<?php

namespace \Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageDSPV1 StructType
 * @subpackage Structs
 */
class PackageDSPV1 extends AbstractStructBase
{
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \\Dpd\Services\StructType\ParcelDSPV1[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for packageDSPV1
     * @uses PackageDSPV1::setPackageId()
     * @uses PackageDSPV1::setParcels()
     * @uses PackageDSPV1::setReference()
     * @param int $packageId
     * @param \\Dpd\Services\StructType\ParcelDSPV1[] $parcels
     * @param string $reference
     */
    public function __construct($packageId = null, array $parcels = array(), $reference = null)
    {
        $this
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference);
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \\Dpd\Services\StructType\PackageDSPV1
     */
    public function setPackageId($packageId = null)
    {
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Dpd\Services\StructType\ParcelDSPV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Dpd\Services\StructType\ParcelDSPV1[] $parcels
     * @return \\Dpd\Services\StructType\PackageDSPV1
     */
    public function setParcels(array $parcels = array())
    {
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \\Dpd\Services\StructType\ParcelDSPV1 $item
     * @return \\Dpd\Services\StructType\PackageDSPV1
     */
    public function addToParcels(\\Dpd\Services\StructType\ParcelDSPV1 $item)
    {
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \\Dpd\Services\StructType\PackageDSPV1
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
}
