<?php

namespace \Dpd\Services\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCourierOrderAvailabilityV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Dpd\Services\StructType\GetCourierOrderAvailabilityV1 $parameters
     * @return \\Dpd\Services\StructType\GetCourierOrderAvailabilityV1Response|bool
     */
    public function getCourierOrderAvailabilityV1(\\Dpd\Services\StructType\GetCourierOrderAvailabilityV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCourierOrderAvailabilityV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Dpd\Services\StructType\GetCourierOrderAvailabilityV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
