<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateExternalProcessedPayment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateExternalProcessedPayment
 * @subpackage Structs
 */
class UpdateExternalProcessedPayment extends TransactionInfo
{
    /**
     * The UpdateExternalProcessedPaymentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UpdateExternalProcessedPayment
     */
    public $UpdateExternalProcessedPaymentRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ResponseFrom3DSecure
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResponseFrom3DSecure;
    /**
     * Constructor method for UpdateExternalProcessedPayment
     * @uses UpdateExternalProcessedPayment::setUpdateExternalProcessedPaymentRequest()
     * @uses UpdateExternalProcessedPayment::setActionType()
     * @uses UpdateExternalProcessedPayment::setReservationInfo()
     * @uses UpdateExternalProcessedPayment::setResponseFrom3DSecure()
     * @param \StructType\UpdateExternalProcessedPayment $updateExternalProcessedPaymentRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $responseFrom3DSecure
     */
    public function __construct(\StructType\UpdateExternalProcessedPayment $updateExternalProcessedPaymentRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $responseFrom3DSecure = null)
    {
        $this
            ->setUpdateExternalProcessedPaymentRequest($updateExternalProcessedPaymentRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setResponseFrom3DSecure($responseFrom3DSecure);
    }
    /**
     * Get UpdateExternalProcessedPaymentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UpdateExternalProcessedPayment|null
     */
    public function getUpdateExternalProcessedPaymentRequest()
    {
        return isset($this->UpdateExternalProcessedPaymentRequest) ? $this->UpdateExternalProcessedPaymentRequest : null;
    }
    /**
     * Set UpdateExternalProcessedPaymentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UpdateExternalProcessedPayment $updateExternalProcessedPaymentRequest
     * @return \StructType\UpdateExternalProcessedPayment
     */
    public function setUpdateExternalProcessedPaymentRequest(\StructType\UpdateExternalProcessedPayment $updateExternalProcessedPaymentRequest = null)
    {
        if (is_null($updateExternalProcessedPaymentRequest) || (is_array($updateExternalProcessedPaymentRequest) && empty($updateExternalProcessedPaymentRequest))) {
            unset($this->UpdateExternalProcessedPaymentRequest);
        } else {
            $this->UpdateExternalProcessedPaymentRequest = $updateExternalProcessedPaymentRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\UpdateExternalProcessedPayment_ActionTypes::valueIsValid()
     * @uses \EnumType\UpdateExternalProcessedPayment_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\UpdateExternalProcessedPayment
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateExternalProcessedPayment_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UpdateExternalProcessedPayment_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\UpdateExternalProcessedPayment_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\UpdateExternalProcessedPayment
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ResponseFrom3DSecure value
     * @return string|null
     */
    public function getResponseFrom3DSecure()
    {
        return $this->ResponseFrom3DSecure;
    }
    /**
     * Set ResponseFrom3DSecure value
     * @param string $responseFrom3DSecure
     * @return \StructType\UpdateExternalProcessedPayment
     */
    public function setResponseFrom3DSecure($responseFrom3DSecure = null)
    {
        // validation for constraint: string
        if (!is_null($responseFrom3DSecure) && !is_string($responseFrom3DSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseFrom3DSecure, true), gettype($responseFrom3DSecure)), __LINE__);
        }
        $this->ResponseFrom3DSecure = $responseFrom3DSecure;
        return $this;
    }
}
