<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalFlight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalFlight
 * @subpackage Structs
 */
class PhysicalFlight extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The DestinationDefaultTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationDefaultTerminal;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The LogicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierName;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FlightOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FlightOrder;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The OriginDefaultTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginDefaultTerminal;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginName;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationName;
    /**
     * The OriginMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginMetroGroup;
    /**
     * The DestinationMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationMetroGroup;
    /**
     * The SellingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellingCarrier;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The OperatingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The Arrivaltime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Arrivaltime;
    /**
     * The FlightDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FlightDuration;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Trip;
    /**
     * The Gate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gate;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalWeight;
    /**
     * The UIDisplayValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UIDisplayValue;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Customers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomer
     */
    public $Customers;
    /**
     * The FromTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTerminal;
    /**
     * The ToTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToTerminal;
    /**
     * The AirCraftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirCraftType;
    /**
     * The AirCraftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirCraftDescription;
    /**
     * The UTCDepartureOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UTCDepartureOffset;
    /**
     * The UTCArrivalOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UTCArrivalOffset;
    /**
     * The DeiDisclosure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeiDisclosure;
    /**
     * The MarketingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingFlightNumber;
    /**
     * The NonStopLogicalFlightId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NonStopLogicalFlightId;
    /**
     * The FlightDisruptionAlert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightDisruptionAlert;
    /**
     * Constructor method for PhysicalFlight
     * @uses PhysicalFlight::setKey()
     * @uses PhysicalFlight::setRecordNumber()
     * @uses PhysicalFlight::setDestinationDefaultTerminal()
     * @uses PhysicalFlight::setPhysicalFlightID()
     * @uses PhysicalFlight::setLogicalFlightID()
     * @uses PhysicalFlight::setCarrierCode()
     * @uses PhysicalFlight::setCarrierName()
     * @uses PhysicalFlight::setFlightNumber()
     * @uses PhysicalFlight::setFlightOrder()
     * @uses PhysicalFlight::setDepartureDate()
     * @uses PhysicalFlight::setOrigin()
     * @uses PhysicalFlight::setOriginDefaultTerminal()
     * @uses PhysicalFlight::setOriginName()
     * @uses PhysicalFlight::setDestination()
     * @uses PhysicalFlight::setDestinationName()
     * @uses PhysicalFlight::setOriginMetroGroup()
     * @uses PhysicalFlight::setDestinationMetroGroup()
     * @uses PhysicalFlight::setSellingCarrier()
     * @uses PhysicalFlight::setOperatingCarrier()
     * @uses PhysicalFlight::setOperatingFlightNumber()
     * @uses PhysicalFlight::setDepartureTime()
     * @uses PhysicalFlight::setArrivaltime()
     * @uses PhysicalFlight::setFlightDuration()
     * @uses PhysicalFlight::setTrip()
     * @uses PhysicalFlight::setGate()
     * @uses PhysicalFlight::setTotalWeight()
     * @uses PhysicalFlight::setUIDisplayValue()
     * @uses PhysicalFlight::setActive()
     * @uses PhysicalFlight::setCustomers()
     * @uses PhysicalFlight::setFromTerminal()
     * @uses PhysicalFlight::setToTerminal()
     * @uses PhysicalFlight::setAirCraftType()
     * @uses PhysicalFlight::setAirCraftDescription()
     * @uses PhysicalFlight::setUTCDepartureOffset()
     * @uses PhysicalFlight::setUTCArrivalOffset()
     * @uses PhysicalFlight::setDeiDisclosure()
     * @uses PhysicalFlight::setMarketingFlightNumber()
     * @uses PhysicalFlight::setNonStopLogicalFlightId()
     * @uses PhysicalFlight::setFlightDisruptionAlert()
     * @param string $key
     * @param int $recordNumber
     * @param string $destinationDefaultTerminal
     * @param int $physicalFlightID
     * @param int $logicalFlightID
     * @param string $carrierCode
     * @param string $carrierName
     * @param string $flightNumber
     * @param int $flightOrder
     * @param string $departureDate
     * @param string $origin
     * @param string $originDefaultTerminal
     * @param string $originName
     * @param string $destination
     * @param string $destinationName
     * @param string $originMetroGroup
     * @param string $destinationMetroGroup
     * @param string $sellingCarrier
     * @param string $operatingCarrier
     * @param string $operatingFlightNumber
     * @param string $departureTime
     * @param string $arrivaltime
     * @param float $flightDuration
     * @param int $trip
     * @param string $gate
     * @param float $totalWeight
     * @param int $uIDisplayValue
     * @param bool $active
     * @param \ArrayType\ArrayOfCustomer $customers
     * @param string $fromTerminal
     * @param string $toTerminal
     * @param string $airCraftType
     * @param string $airCraftDescription
     * @param string $uTCDepartureOffset
     * @param string $uTCArrivalOffset
     * @param string $deiDisclosure
     * @param string $marketingFlightNumber
     * @param int $nonStopLogicalFlightId
     * @param string $flightDisruptionAlert
     */
    public function __construct($key = null, $recordNumber = null, $destinationDefaultTerminal = null, $physicalFlightID = null, $logicalFlightID = null, $carrierCode = null, $carrierName = null, $flightNumber = null, $flightOrder = null, $departureDate = null, $origin = null, $originDefaultTerminal = null, $originName = null, $destination = null, $destinationName = null, $originMetroGroup = null, $destinationMetroGroup = null, $sellingCarrier = null, $operatingCarrier = null, $operatingFlightNumber = null, $departureTime = null, $arrivaltime = null, $flightDuration = null, $trip = null, $gate = null, $totalWeight = null, $uIDisplayValue = null, $active = null, \ArrayType\ArrayOfCustomer $customers = null, $fromTerminal = null, $toTerminal = null, $airCraftType = null, $airCraftDescription = null, $uTCDepartureOffset = null, $uTCArrivalOffset = null, $deiDisclosure = null, $marketingFlightNumber = null, $nonStopLogicalFlightId = null, $flightDisruptionAlert = null)
    {
        $this
            ->setKey($key)
            ->setRecordNumber($recordNumber)
            ->setDestinationDefaultTerminal($destinationDefaultTerminal)
            ->setPhysicalFlightID($physicalFlightID)
            ->setLogicalFlightID($logicalFlightID)
            ->setCarrierCode($carrierCode)
            ->setCarrierName($carrierName)
            ->setFlightNumber($flightNumber)
            ->setFlightOrder($flightOrder)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setOriginDefaultTerminal($originDefaultTerminal)
            ->setOriginName($originName)
            ->setDestination($destination)
            ->setDestinationName($destinationName)
            ->setOriginMetroGroup($originMetroGroup)
            ->setDestinationMetroGroup($destinationMetroGroup)
            ->setSellingCarrier($sellingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setDepartureTime($departureTime)
            ->setArrivaltime($arrivaltime)
            ->setFlightDuration($flightDuration)
            ->setTrip($trip)
            ->setGate($gate)
            ->setTotalWeight($totalWeight)
            ->setUIDisplayValue($uIDisplayValue)
            ->setActive($active)
            ->setCustomers($customers)
            ->setFromTerminal($fromTerminal)
            ->setToTerminal($toTerminal)
            ->setAirCraftType($airCraftType)
            ->setAirCraftDescription($airCraftDescription)
            ->setUTCDepartureOffset($uTCDepartureOffset)
            ->setUTCArrivalOffset($uTCArrivalOffset)
            ->setDeiDisclosure($deiDisclosure)
            ->setMarketingFlightNumber($marketingFlightNumber)
            ->setNonStopLogicalFlightId($nonStopLogicalFlightId)
            ->setFlightDisruptionAlert($flightDisruptionAlert);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\PhysicalFlight
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\PhysicalFlight
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get DestinationDefaultTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationDefaultTerminal()
    {
        return isset($this->DestinationDefaultTerminal) ? $this->DestinationDefaultTerminal : null;
    }
    /**
     * Set DestinationDefaultTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationDefaultTerminal
     * @return \StructType\PhysicalFlight
     */
    public function setDestinationDefaultTerminal($destinationDefaultTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($destinationDefaultTerminal) && !is_string($destinationDefaultTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationDefaultTerminal, true), gettype($destinationDefaultTerminal)), __LINE__);
        }
        if (is_null($destinationDefaultTerminal) || (is_array($destinationDefaultTerminal) && empty($destinationDefaultTerminal))) {
            unset($this->DestinationDefaultTerminal);
        } else {
            $this->DestinationDefaultTerminal = $destinationDefaultTerminal;
        }
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\PhysicalFlight
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\PhysicalFlight
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get CarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierCode()
    {
        return isset($this->CarrierCode) ? $this->CarrierCode : null;
    }
    /**
     * Set CarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierCode
     * @return \StructType\PhysicalFlight
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        if (is_null($carrierCode) || (is_array($carrierCode) && empty($carrierCode))) {
            unset($this->CarrierCode);
        } else {
            $this->CarrierCode = $carrierCode;
        }
        return $this;
    }
    /**
     * Get CarrierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierName()
    {
        return isset($this->CarrierName) ? $this->CarrierName : null;
    }
    /**
     * Set CarrierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierName
     * @return \StructType\PhysicalFlight
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        if (is_null($carrierName) || (is_array($carrierName) && empty($carrierName))) {
            unset($this->CarrierName);
        } else {
            $this->CarrierName = $carrierName;
        }
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\PhysicalFlight
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get FlightOrder value
     * @return int|null
     */
    public function getFlightOrder()
    {
        return $this->FlightOrder;
    }
    /**
     * Set FlightOrder value
     * @param int $flightOrder
     * @return \StructType\PhysicalFlight
     */
    public function setFlightOrder($flightOrder = null)
    {
        // validation for constraint: int
        if (!is_null($flightOrder) && !(is_int($flightOrder) || ctype_digit($flightOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightOrder, true), gettype($flightOrder)), __LINE__);
        }
        $this->FlightOrder = $flightOrder;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PhysicalFlight
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\PhysicalFlight
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get OriginDefaultTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginDefaultTerminal()
    {
        return isset($this->OriginDefaultTerminal) ? $this->OriginDefaultTerminal : null;
    }
    /**
     * Set OriginDefaultTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originDefaultTerminal
     * @return \StructType\PhysicalFlight
     */
    public function setOriginDefaultTerminal($originDefaultTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($originDefaultTerminal) && !is_string($originDefaultTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDefaultTerminal, true), gettype($originDefaultTerminal)), __LINE__);
        }
        if (is_null($originDefaultTerminal) || (is_array($originDefaultTerminal) && empty($originDefaultTerminal))) {
            unset($this->OriginDefaultTerminal);
        } else {
            $this->OriginDefaultTerminal = $originDefaultTerminal;
        }
        return $this;
    }
    /**
     * Get OriginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginName()
    {
        return isset($this->OriginName) ? $this->OriginName : null;
    }
    /**
     * Set OriginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originName
     * @return \StructType\PhysicalFlight
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        if (is_null($originName) || (is_array($originName) && empty($originName))) {
            unset($this->OriginName);
        } else {
            $this->OriginName = $originName;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\PhysicalFlight
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get DestinationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationName()
    {
        return isset($this->DestinationName) ? $this->DestinationName : null;
    }
    /**
     * Set DestinationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationName
     * @return \StructType\PhysicalFlight
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        if (is_null($destinationName) || (is_array($destinationName) && empty($destinationName))) {
            unset($this->DestinationName);
        } else {
            $this->DestinationName = $destinationName;
        }
        return $this;
    }
    /**
     * Get OriginMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginMetroGroup()
    {
        return isset($this->OriginMetroGroup) ? $this->OriginMetroGroup : null;
    }
    /**
     * Set OriginMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originMetroGroup
     * @return \StructType\PhysicalFlight
     */
    public function setOriginMetroGroup($originMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($originMetroGroup) && !is_string($originMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originMetroGroup, true), gettype($originMetroGroup)), __LINE__);
        }
        if (is_null($originMetroGroup) || (is_array($originMetroGroup) && empty($originMetroGroup))) {
            unset($this->OriginMetroGroup);
        } else {
            $this->OriginMetroGroup = $originMetroGroup;
        }
        return $this;
    }
    /**
     * Get DestinationMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationMetroGroup()
    {
        return isset($this->DestinationMetroGroup) ? $this->DestinationMetroGroup : null;
    }
    /**
     * Set DestinationMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationMetroGroup
     * @return \StructType\PhysicalFlight
     */
    public function setDestinationMetroGroup($destinationMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($destinationMetroGroup) && !is_string($destinationMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationMetroGroup, true), gettype($destinationMetroGroup)), __LINE__);
        }
        if (is_null($destinationMetroGroup) || (is_array($destinationMetroGroup) && empty($destinationMetroGroup))) {
            unset($this->DestinationMetroGroup);
        } else {
            $this->DestinationMetroGroup = $destinationMetroGroup;
        }
        return $this;
    }
    /**
     * Get SellingCarrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellingCarrier()
    {
        return isset($this->SellingCarrier) ? $this->SellingCarrier : null;
    }
    /**
     * Set SellingCarrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellingCarrier
     * @return \StructType\PhysicalFlight
     */
    public function setSellingCarrier($sellingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($sellingCarrier) && !is_string($sellingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingCarrier, true), gettype($sellingCarrier)), __LINE__);
        }
        if (is_null($sellingCarrier) || (is_array($sellingCarrier) && empty($sellingCarrier))) {
            unset($this->SellingCarrier);
        } else {
            $this->SellingCarrier = $sellingCarrier;
        }
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return isset($this->OperatingCarrier) ? $this->OperatingCarrier : null;
    }
    /**
     * Set OperatingCarrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrier
     * @return \StructType\PhysicalFlight
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        if (is_null($operatingCarrier) || (is_array($operatingCarrier) && empty($operatingCarrier))) {
            unset($this->OperatingCarrier);
        } else {
            $this->OperatingCarrier = $operatingCarrier;
        }
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return isset($this->OperatingFlightNumber) ? $this->OperatingFlightNumber : null;
    }
    /**
     * Set OperatingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingFlightNumber
     * @return \StructType\PhysicalFlight
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNumber, true), gettype($operatingFlightNumber)), __LINE__);
        }
        if (is_null($operatingFlightNumber) || (is_array($operatingFlightNumber) && empty($operatingFlightNumber))) {
            unset($this->OperatingFlightNumber);
        } else {
            $this->OperatingFlightNumber = $operatingFlightNumber;
        }
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\PhysicalFlight
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Arrivaltime value
     * @return string|null
     */
    public function getArrivaltime()
    {
        return $this->Arrivaltime;
    }
    /**
     * Set Arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\PhysicalFlight
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        $this->Arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get FlightDuration value
     * @return float|null
     */
    public function getFlightDuration()
    {
        return $this->FlightDuration;
    }
    /**
     * Set FlightDuration value
     * @param float $flightDuration
     * @return \StructType\PhysicalFlight
     */
    public function setFlightDuration($flightDuration = null)
    {
        // validation for constraint: float
        if (!is_null($flightDuration) && !(is_float($flightDuration) || is_numeric($flightDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flightDuration, true), gettype($flightDuration)), __LINE__);
        }
        $this->FlightDuration = $flightDuration;
        return $this;
    }
    /**
     * Get Trip value
     * @return int|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param int $trip
     * @return \StructType\PhysicalFlight
     */
    public function setTrip($trip = null)
    {
        // validation for constraint: int
        if (!is_null($trip) && !(is_int($trip) || ctype_digit($trip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trip, true), gettype($trip)), __LINE__);
        }
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Gate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGate()
    {
        return isset($this->Gate) ? $this->Gate : null;
    }
    /**
     * Set Gate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gate
     * @return \StructType\PhysicalFlight
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gate, true), gettype($gate)), __LINE__);
        }
        if (is_null($gate) || (is_array($gate) && empty($gate))) {
            unset($this->Gate);
        } else {
            $this->Gate = $gate;
        }
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param float $totalWeight
     * @return \StructType\PhysicalFlight
     */
    public function setTotalWeight($totalWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalWeight) && !(is_float($totalWeight) || is_numeric($totalWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalWeight, true), gettype($totalWeight)), __LINE__);
        }
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get UIDisplayValue value
     * @return int|null
     */
    public function getUIDisplayValue()
    {
        return $this->UIDisplayValue;
    }
    /**
     * Set UIDisplayValue value
     * @param int $uIDisplayValue
     * @return \StructType\PhysicalFlight
     */
    public function setUIDisplayValue($uIDisplayValue = null)
    {
        // validation for constraint: int
        if (!is_null($uIDisplayValue) && !(is_int($uIDisplayValue) || ctype_digit($uIDisplayValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uIDisplayValue, true), gettype($uIDisplayValue)), __LINE__);
        }
        $this->UIDisplayValue = $uIDisplayValue;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\PhysicalFlight
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Customers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomer|null
     */
    public function getCustomers()
    {
        return isset($this->Customers) ? $this->Customers : null;
    }
    /**
     * Set Customers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomer $customers
     * @return \StructType\PhysicalFlight
     */
    public function setCustomers(\ArrayType\ArrayOfCustomer $customers = null)
    {
        if (is_null($customers) || (is_array($customers) && empty($customers))) {
            unset($this->Customers);
        } else {
            $this->Customers = $customers;
        }
        return $this;
    }
    /**
     * Get FromTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTerminal()
    {
        return isset($this->FromTerminal) ? $this->FromTerminal : null;
    }
    /**
     * Set FromTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTerminal
     * @return \StructType\PhysicalFlight
     */
    public function setFromTerminal($fromTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($fromTerminal) && !is_string($fromTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTerminal, true), gettype($fromTerminal)), __LINE__);
        }
        if (is_null($fromTerminal) || (is_array($fromTerminal) && empty($fromTerminal))) {
            unset($this->FromTerminal);
        } else {
            $this->FromTerminal = $fromTerminal;
        }
        return $this;
    }
    /**
     * Get ToTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToTerminal()
    {
        return isset($this->ToTerminal) ? $this->ToTerminal : null;
    }
    /**
     * Set ToTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toTerminal
     * @return \StructType\PhysicalFlight
     */
    public function setToTerminal($toTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($toTerminal) && !is_string($toTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toTerminal, true), gettype($toTerminal)), __LINE__);
        }
        if (is_null($toTerminal) || (is_array($toTerminal) && empty($toTerminal))) {
            unset($this->ToTerminal);
        } else {
            $this->ToTerminal = $toTerminal;
        }
        return $this;
    }
    /**
     * Get AirCraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirCraftType()
    {
        return isset($this->AirCraftType) ? $this->AirCraftType : null;
    }
    /**
     * Set AirCraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airCraftType
     * @return \StructType\PhysicalFlight
     */
    public function setAirCraftType($airCraftType = null)
    {
        // validation for constraint: string
        if (!is_null($airCraftType) && !is_string($airCraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airCraftType, true), gettype($airCraftType)), __LINE__);
        }
        if (is_null($airCraftType) || (is_array($airCraftType) && empty($airCraftType))) {
            unset($this->AirCraftType);
        } else {
            $this->AirCraftType = $airCraftType;
        }
        return $this;
    }
    /**
     * Get AirCraftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirCraftDescription()
    {
        return isset($this->AirCraftDescription) ? $this->AirCraftDescription : null;
    }
    /**
     * Set AirCraftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airCraftDescription
     * @return \StructType\PhysicalFlight
     */
    public function setAirCraftDescription($airCraftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($airCraftDescription) && !is_string($airCraftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airCraftDescription, true), gettype($airCraftDescription)), __LINE__);
        }
        if (is_null($airCraftDescription) || (is_array($airCraftDescription) && empty($airCraftDescription))) {
            unset($this->AirCraftDescription);
        } else {
            $this->AirCraftDescription = $airCraftDescription;
        }
        return $this;
    }
    /**
     * Get UTCDepartureOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUTCDepartureOffset()
    {
        return isset($this->UTCDepartureOffset) ? $this->UTCDepartureOffset : null;
    }
    /**
     * Set UTCDepartureOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uTCDepartureOffset
     * @return \StructType\PhysicalFlight
     */
    public function setUTCDepartureOffset($uTCDepartureOffset = null)
    {
        // validation for constraint: string
        if (!is_null($uTCDepartureOffset) && !is_string($uTCDepartureOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTCDepartureOffset, true), gettype($uTCDepartureOffset)), __LINE__);
        }
        if (is_null($uTCDepartureOffset) || (is_array($uTCDepartureOffset) && empty($uTCDepartureOffset))) {
            unset($this->UTCDepartureOffset);
        } else {
            $this->UTCDepartureOffset = $uTCDepartureOffset;
        }
        return $this;
    }
    /**
     * Get UTCArrivalOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUTCArrivalOffset()
    {
        return isset($this->UTCArrivalOffset) ? $this->UTCArrivalOffset : null;
    }
    /**
     * Set UTCArrivalOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uTCArrivalOffset
     * @return \StructType\PhysicalFlight
     */
    public function setUTCArrivalOffset($uTCArrivalOffset = null)
    {
        // validation for constraint: string
        if (!is_null($uTCArrivalOffset) && !is_string($uTCArrivalOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTCArrivalOffset, true), gettype($uTCArrivalOffset)), __LINE__);
        }
        if (is_null($uTCArrivalOffset) || (is_array($uTCArrivalOffset) && empty($uTCArrivalOffset))) {
            unset($this->UTCArrivalOffset);
        } else {
            $this->UTCArrivalOffset = $uTCArrivalOffset;
        }
        return $this;
    }
    /**
     * Get DeiDisclosure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeiDisclosure()
    {
        return isset($this->DeiDisclosure) ? $this->DeiDisclosure : null;
    }
    /**
     * Set DeiDisclosure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deiDisclosure
     * @return \StructType\PhysicalFlight
     */
    public function setDeiDisclosure($deiDisclosure = null)
    {
        // validation for constraint: string
        if (!is_null($deiDisclosure) && !is_string($deiDisclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deiDisclosure, true), gettype($deiDisclosure)), __LINE__);
        }
        if (is_null($deiDisclosure) || (is_array($deiDisclosure) && empty($deiDisclosure))) {
            unset($this->DeiDisclosure);
        } else {
            $this->DeiDisclosure = $deiDisclosure;
        }
        return $this;
    }
    /**
     * Get MarketingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingFlightNumber()
    {
        return isset($this->MarketingFlightNumber) ? $this->MarketingFlightNumber : null;
    }
    /**
     * Set MarketingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingFlightNumber
     * @return \StructType\PhysicalFlight
     */
    public function setMarketingFlightNumber($marketingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($marketingFlightNumber) && !is_string($marketingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingFlightNumber, true), gettype($marketingFlightNumber)), __LINE__);
        }
        if (is_null($marketingFlightNumber) || (is_array($marketingFlightNumber) && empty($marketingFlightNumber))) {
            unset($this->MarketingFlightNumber);
        } else {
            $this->MarketingFlightNumber = $marketingFlightNumber;
        }
        return $this;
    }
    /**
     * Get NonStopLogicalFlightId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNonStopLogicalFlightId()
    {
        return isset($this->NonStopLogicalFlightId) ? $this->NonStopLogicalFlightId : null;
    }
    /**
     * Set NonStopLogicalFlightId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nonStopLogicalFlightId
     * @return \StructType\PhysicalFlight
     */
    public function setNonStopLogicalFlightId($nonStopLogicalFlightId = null)
    {
        // validation for constraint: int
        if (!is_null($nonStopLogicalFlightId) && !(is_int($nonStopLogicalFlightId) || ctype_digit($nonStopLogicalFlightId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonStopLogicalFlightId, true), gettype($nonStopLogicalFlightId)), __LINE__);
        }
        if (is_null($nonStopLogicalFlightId) || (is_array($nonStopLogicalFlightId) && empty($nonStopLogicalFlightId))) {
            unset($this->NonStopLogicalFlightId);
        } else {
            $this->NonStopLogicalFlightId = $nonStopLogicalFlightId;
        }
        return $this;
    }
    /**
     * Get FlightDisruptionAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightDisruptionAlert()
    {
        return isset($this->FlightDisruptionAlert) ? $this->FlightDisruptionAlert : null;
    }
    /**
     * Set FlightDisruptionAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightDisruptionAlert
     * @return \StructType\PhysicalFlight
     */
    public function setFlightDisruptionAlert($flightDisruptionAlert = null)
    {
        // validation for constraint: string
        if (!is_null($flightDisruptionAlert) && !is_string($flightDisruptionAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDisruptionAlert, true), gettype($flightDisruptionAlert)), __LINE__);
        }
        if (is_null($flightDisruptionAlert) || (is_array($flightDisruptionAlert) && empty($flightDisruptionAlert))) {
            unset($this->FlightDisruptionAlert);
        } else {
            $this->FlightDisruptionAlert = $flightDisruptionAlert;
        }
        return $this;
    }
}
