<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PNRPayments StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PNRPayments
 * @subpackage Structs
 */
class PNRPayments extends AbstractStructBase
{
    /**
     * The TransactionInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TransactionInfo
     */
    public $TransactionInfo;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The PNRPayments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfProcessPNRPayment
     */
    public $PNRPayments;
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActionType;
    /**
     * Constructor method for PNRPayments
     * @uses PNRPayments::setTransactionInfo()
     * @uses PNRPayments::setReservationInfo()
     * @uses PNRPayments::setPNRPayments()
     * @uses PNRPayments::setActionType()
     * @param \StructType\TransactionInfo $transactionInfo
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfProcessPNRPayment $pNRPayments
     * @param string $actionType
     */
    public function __construct(\StructType\TransactionInfo $transactionInfo = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfProcessPNRPayment $pNRPayments = null, $actionType = null)
    {
        $this
            ->setTransactionInfo($transactionInfo)
            ->setReservationInfo($reservationInfo)
            ->setPNRPayments($pNRPayments)
            ->setActionType($actionType);
    }
    /**
     * Get TransactionInfo value
     * @return \StructType\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->TransactionInfo;
    }
    /**
     * Set TransactionInfo value
     * @param \StructType\TransactionInfo $transactionInfo
     * @return \StructType\PNRPayments
     */
    public function setTransactionInfo(\StructType\TransactionInfo $transactionInfo = null)
    {
        $this->TransactionInfo = $transactionInfo;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\PNRPayments
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get PNRPayments value
     * @return \ArrayType\ArrayOfProcessPNRPayment|null
     */
    public function getPNRPayments()
    {
        return $this->PNRPayments;
    }
    /**
     * Set PNRPayments value
     * @param \ArrayType\ArrayOfProcessPNRPayment $pNRPayments
     * @return \StructType\PNRPayments
     */
    public function setPNRPayments(\ArrayType\ArrayOfProcessPNRPayment $pNRPayments = null)
    {
        $this->PNRPayments = $pNRPayments;
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\PNRPayments_ActionTypes::valueIsValid()
     * @uses \EnumType\PNRPayments_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\PNRPayments
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PNRPayments_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PNRPayments_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\PNRPayments_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
}
