<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPayments StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemPayments
 * @subpackage Structs
 */
class ItemPayments extends AbstractStructBase
{
    /**
     * The TransactionInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TransactionInfo
     */
    public $TransactionInfo;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ItemPayments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfProcessItemPayment
     */
    public $ItemPayments;
    /**
     * Constructor method for ItemPayments
     * @uses ItemPayments::setTransactionInfo()
     * @uses ItemPayments::setReservationInfo()
     * @uses ItemPayments::setItemPayments()
     * @param \StructType\TransactionInfo $transactionInfo
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfProcessItemPayment $itemPayments
     */
    public function __construct(\StructType\TransactionInfo $transactionInfo = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfProcessItemPayment $itemPayments = null)
    {
        $this
            ->setTransactionInfo($transactionInfo)
            ->setReservationInfo($reservationInfo)
            ->setItemPayments($itemPayments);
    }
    /**
     * Get TransactionInfo value
     * @return \StructType\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->TransactionInfo;
    }
    /**
     * Set TransactionInfo value
     * @param \StructType\TransactionInfo $transactionInfo
     * @return \StructType\ItemPayments
     */
    public function setTransactionInfo(\StructType\TransactionInfo $transactionInfo = null)
    {
        $this->TransactionInfo = $transactionInfo;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\ItemPayments
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ItemPayments value
     * @return \ArrayType\ArrayOfProcessItemPayment|null
     */
    public function getItemPayments()
    {
        return $this->ItemPayments;
    }
    /**
     * Set ItemPayments value
     * @param \ArrayType\ArrayOfProcessItemPayment $itemPayments
     * @return \StructType\ItemPayments
     */
    public function setItemPayments(\ArrayType\ArrayOfProcessItemPayment $itemPayments = null)
    {
        $this->ItemPayments = $itemPayments;
        return $this;
    }
}
