<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddVoucherToReservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddVoucherToReservation
 * @subpackage Structs
 */
class AddVoucherToReservation extends TransactionInfo
{
    /**
     * The AddVoucherToReservationRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddVoucherToReservation
     */
    public $AddVoucherToReservationRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $VoucherNumber;
    /**
     * Constructor method for AddVoucherToReservation
     * @uses AddVoucherToReservation::setAddVoucherToReservationRequest()
     * @uses AddVoucherToReservation::setReservationInfo()
     * @uses AddVoucherToReservation::setVoucherNumber()
     * @param \StructType\AddVoucherToReservation $addVoucherToReservationRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $voucherNumber
     */
    public function __construct(\StructType\AddVoucherToReservation $addVoucherToReservationRequest = null, \StructType\ReservationInfo $reservationInfo = null, $voucherNumber = null)
    {
        $this
            ->setAddVoucherToReservationRequest($addVoucherToReservationRequest)
            ->setReservationInfo($reservationInfo)
            ->setVoucherNumber($voucherNumber);
    }
    /**
     * Get AddVoucherToReservationRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddVoucherToReservation|null
     */
    public function getAddVoucherToReservationRequest()
    {
        return isset($this->AddVoucherToReservationRequest) ? $this->AddVoucherToReservationRequest : null;
    }
    /**
     * Set AddVoucherToReservationRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddVoucherToReservation $addVoucherToReservationRequest
     * @return \StructType\AddVoucherToReservation
     */
    public function setAddVoucherToReservationRequest(\StructType\AddVoucherToReservation $addVoucherToReservationRequest = null)
    {
        if (is_null($addVoucherToReservationRequest) || (is_array($addVoucherToReservationRequest) && empty($addVoucherToReservationRequest))) {
            unset($this->AddVoucherToReservationRequest);
        } else {
            $this->AddVoucherToReservationRequest = $addVoucherToReservationRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\AddVoucherToReservation
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param string $voucherNumber
     * @return \StructType\AddVoucherToReservation
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
}
