<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCharge ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCharge
 * @subpackage Arrays
 */
class ArrayOfCharge extends AbstractStructArrayBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Charge[]
     */
    public $Charge;
    /**
     * Constructor method for ArrayOfCharge
     * @uses ArrayOfCharge::setCharge()
     * @param \StructType\Charge[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Charge[]|null
     */
    public function getCharge()
    {
        return isset($this->Charge) ? $this->Charge : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfChargeChargeItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeChargeItem instanceof \StructType\Charge) {
                $invalidValues[] = is_object($arrayOfChargeChargeItem) ? get_class($arrayOfChargeChargeItem) : sprintf('%s(%s)', gettype($arrayOfChargeChargeItem), var_export($arrayOfChargeChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type \StructType\Charge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Charge[] $charge
     * @return \ArrayType\ArrayOfCharge
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        if (is_null($charge) || (is_array($charge) && empty($charge))) {
            unset($this->Charge);
        } else {
            $this->Charge = $charge;
        }
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \StructType\Charge $item
     * @return \ArrayType\ArrayOfCharge
     */
    public function addToCharge(\StructType\Charge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Charge) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type \StructType\Charge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Charge|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Charge|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Charge|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Charge|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Charge|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Charge
     */
    public function getAttributeName()
    {
        return 'Charge';
    }
}
