<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentDetails
 * @subpackage Structs
 */
class PaymentDetails extends AbstractStructBase
{
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The CVCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CVCode;
    /**
     * The CardCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardCurrency;
    /**
     * The CardHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolder;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CurrencyPaid
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyPaid;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantID;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentReference;
    /**
     * The ProcessorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessorID;
    /**
     * The ProcessorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessorName;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The ResPaymentId
     * @var int
     */
    public $ResPaymentId;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionID;
    /**
     * The TransactionStatus
     * @var string
     */
    public $TransactionStatus;
    /**
     * Constructor method for PaymentDetails
     * @uses PaymentDetails::setAuthorizationCode()
     * @uses PaymentDetails::setCVCode()
     * @uses PaymentDetails::setCardCurrency()
     * @uses PaymentDetails::setCardHolder()
     * @uses PaymentDetails::setCardNumber()
     * @uses PaymentDetails::setCurrencyPaid()
     * @uses PaymentDetails::setDatePaid()
     * @uses PaymentDetails::setExpirationDate()
     * @uses PaymentDetails::setMerchantID()
     * @uses PaymentDetails::setPaymentAmount()
     * @uses PaymentDetails::setPaymentMethod()
     * @uses PaymentDetails::setPaymentReference()
     * @uses PaymentDetails::setProcessorID()
     * @uses PaymentDetails::setProcessorName()
     * @uses PaymentDetails::setReference()
     * @uses PaymentDetails::setResPaymentId()
     * @uses PaymentDetails::setResponseCode()
     * @uses PaymentDetails::setResponseMessage()
     * @uses PaymentDetails::setResult()
     * @uses PaymentDetails::setTransactionID()
     * @uses PaymentDetails::setTransactionStatus()
     * @param string $authorizationCode
     * @param string $cVCode
     * @param string $cardCurrency
     * @param string $cardHolder
     * @param string $cardNumber
     * @param string $currencyPaid
     * @param string $datePaid
     * @param string $expirationDate
     * @param string $merchantID
     * @param float $paymentAmount
     * @param string $paymentMethod
     * @param string $paymentReference
     * @param string $processorID
     * @param string $processorName
     * @param string $reference
     * @param int $resPaymentId
     * @param string $responseCode
     * @param string $responseMessage
     * @param string $result
     * @param string $transactionID
     * @param string $transactionStatus
     */
    public function __construct($authorizationCode = null, $cVCode = null, $cardCurrency = null, $cardHolder = null, $cardNumber = null, $currencyPaid = null, $datePaid = null, $expirationDate = null, $merchantID = null, $paymentAmount = null, $paymentMethod = null, $paymentReference = null, $processorID = null, $processorName = null, $reference = null, $resPaymentId = null, $responseCode = null, $responseMessage = null, $result = null, $transactionID = null, $transactionStatus = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setCVCode($cVCode)
            ->setCardCurrency($cardCurrency)
            ->setCardHolder($cardHolder)
            ->setCardNumber($cardNumber)
            ->setCurrencyPaid($currencyPaid)
            ->setDatePaid($datePaid)
            ->setExpirationDate($expirationDate)
            ->setMerchantID($merchantID)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentReference($paymentReference)
            ->setProcessorID($processorID)
            ->setProcessorName($processorName)
            ->setReference($reference)
            ->setResPaymentId($resPaymentId)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage)
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setTransactionStatus($transactionStatus);
    }
    /**
     * Get AuthorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return isset($this->AuthorizationCode) ? $this->AuthorizationCode : null;
    }
    /**
     * Set AuthorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationCode
     * @return \StructType\PaymentDetails
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        if (is_null($authorizationCode) || (is_array($authorizationCode) && empty($authorizationCode))) {
            unset($this->AuthorizationCode);
        } else {
            $this->AuthorizationCode = $authorizationCode;
        }
        return $this;
    }
    /**
     * Get CVCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCVCode()
    {
        return isset($this->CVCode) ? $this->CVCode : null;
    }
    /**
     * Set CVCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cVCode
     * @return \StructType\PaymentDetails
     */
    public function setCVCode($cVCode = null)
    {
        // validation for constraint: string
        if (!is_null($cVCode) && !is_string($cVCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVCode, true), gettype($cVCode)), __LINE__);
        }
        if (is_null($cVCode) || (is_array($cVCode) && empty($cVCode))) {
            unset($this->CVCode);
        } else {
            $this->CVCode = $cVCode;
        }
        return $this;
    }
    /**
     * Get CardCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardCurrency()
    {
        return isset($this->CardCurrency) ? $this->CardCurrency : null;
    }
    /**
     * Set CardCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardCurrency
     * @return \StructType\PaymentDetails
     */
    public function setCardCurrency($cardCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cardCurrency) && !is_string($cardCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCurrency, true), gettype($cardCurrency)), __LINE__);
        }
        if (is_null($cardCurrency) || (is_array($cardCurrency) && empty($cardCurrency))) {
            unset($this->CardCurrency);
        } else {
            $this->CardCurrency = $cardCurrency;
        }
        return $this;
    }
    /**
     * Get CardHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolder()
    {
        return isset($this->CardHolder) ? $this->CardHolder : null;
    }
    /**
     * Set CardHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolder
     * @return \StructType\PaymentDetails
     */
    public function setCardHolder($cardHolder = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolder) && !is_string($cardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolder, true), gettype($cardHolder)), __LINE__);
        }
        if (is_null($cardHolder) || (is_array($cardHolder) && empty($cardHolder))) {
            unset($this->CardHolder);
        } else {
            $this->CardHolder = $cardHolder;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\PaymentDetails
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CurrencyPaid value
     * @return string|null
     */
    public function getCurrencyPaid()
    {
        return $this->CurrencyPaid;
    }
    /**
     * Set CurrencyPaid value
     * @param string $currencyPaid
     * @return \StructType\PaymentDetails
     */
    public function setCurrencyPaid($currencyPaid = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPaid) && !is_string($currencyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyPaid, true), gettype($currencyPaid)), __LINE__);
        }
        $this->CurrencyPaid = $currencyPaid;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \StructType\PaymentDetails
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\PaymentDetails
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get MerchantID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantID()
    {
        return isset($this->MerchantID) ? $this->MerchantID : null;
    }
    /**
     * Set MerchantID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantID
     * @return \StructType\PaymentDetails
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        if (is_null($merchantID) || (is_array($merchantID) && empty($merchantID))) {
            unset($this->MerchantID);
        } else {
            $this->MerchantID = $merchantID;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\PaymentDetails
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\PaymentDetails
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentReference()
    {
        return isset($this->PaymentReference) ? $this->PaymentReference : null;
    }
    /**
     * Set PaymentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentReference
     * @return \StructType\PaymentDetails
     */
    public function setPaymentReference($paymentReference = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReference) && !is_string($paymentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentReference, true), gettype($paymentReference)), __LINE__);
        }
        if (is_null($paymentReference) || (is_array($paymentReference) && empty($paymentReference))) {
            unset($this->PaymentReference);
        } else {
            $this->PaymentReference = $paymentReference;
        }
        return $this;
    }
    /**
     * Get ProcessorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessorID()
    {
        return isset($this->ProcessorID) ? $this->ProcessorID : null;
    }
    /**
     * Set ProcessorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processorID
     * @return \StructType\PaymentDetails
     */
    public function setProcessorID($processorID = null)
    {
        // validation for constraint: string
        if (!is_null($processorID) && !is_string($processorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processorID, true), gettype($processorID)), __LINE__);
        }
        if (is_null($processorID) || (is_array($processorID) && empty($processorID))) {
            unset($this->ProcessorID);
        } else {
            $this->ProcessorID = $processorID;
        }
        return $this;
    }
    /**
     * Get ProcessorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessorName()
    {
        return isset($this->ProcessorName) ? $this->ProcessorName : null;
    }
    /**
     * Set ProcessorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processorName
     * @return \StructType\PaymentDetails
     */
    public function setProcessorName($processorName = null)
    {
        // validation for constraint: string
        if (!is_null($processorName) && !is_string($processorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processorName, true), gettype($processorName)), __LINE__);
        }
        if (is_null($processorName) || (is_array($processorName) && empty($processorName))) {
            unset($this->ProcessorName);
        } else {
            $this->ProcessorName = $processorName;
        }
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\PaymentDetails
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Get ResPaymentId value
     * @return int|null
     */
    public function getResPaymentId()
    {
        return $this->ResPaymentId;
    }
    /**
     * Set ResPaymentId value
     * @param int $resPaymentId
     * @return \StructType\PaymentDetails
     */
    public function setResPaymentId($resPaymentId = null)
    {
        // validation for constraint: int
        if (!is_null($resPaymentId) && !(is_int($resPaymentId) || ctype_digit($resPaymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resPaymentId, true), gettype($resPaymentId)), __LINE__);
        }
        $this->ResPaymentId = $resPaymentId;
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\PaymentDetails
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\PaymentDetails
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $result
     * @return \StructType\PaymentDetails
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionID
     * @return \StructType\PaymentDetails
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Get TransactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->TransactionStatus;
    }
    /**
     * Set TransactionStatus value
     * @uses \EnumType\Enumerations_PaymentTransactionStatusTypes::valueIsValid()
     * @uses \EnumType\Enumerations_PaymentTransactionStatusTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\PaymentDetails
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PaymentTransactionStatusTypes::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PaymentTransactionStatusTypes', is_array($transactionStatus) ? implode(', ', $transactionStatus) : var_export($transactionStatus, true), implode(', ', \EnumType\Enumerations_PaymentTransactionStatusTypes::getValidValues())), __LINE__);
        }
        $this->TransactionStatus = $transactionStatus;
        return $this;
    }
}
