<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogicalFlight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LogicalFlight
 * @subpackage Structs
 */
class LogicalFlight extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The LogicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The OriginDefaultTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginDefaultTerminal;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginName;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DestinationDefaultTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationDefaultTerminal;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationName;
    /**
     * The OriginMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginMetroGroup;
    /**
     * The DestinationMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationMetroGroup;
    /**
     * The SellingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellingCarrier;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The OperatingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The Arrivaltime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Arrivaltime;
    /**
     * The PackageItemID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackageItemID;
    /**
     * The PackageItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageItemName;
    /**
     * The PackageItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageItemDescription;
    /**
     * The PackageItemBookDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageItemBookDate;
    /**
     * The PackageItemStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageItemStartDate;
    /**
     * The PackageItemEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageItemEndDate;
    /**
     * The VendorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VendorId;
    /**
     * The VendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VendorName;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The VendorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VendorDescription;
    /**
     * The UIDisplayValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UIDisplayValue;
    /**
     * The PhysicalFlights
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPhysicalFlight
     */
    public $PhysicalFlights;
    /**
     * The FlightDisruptionAlert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightDisruptionAlert;
    /**
     * The MarketingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingFlightNumber;
    /**
     * Constructor method for LogicalFlight
     * @uses LogicalFlight::setKey()
     * @uses LogicalFlight::setRecordNumber()
     * @uses LogicalFlight::setLogicalFlightID()
     * @uses LogicalFlight::setDepartureDate()
     * @uses LogicalFlight::setOrigin()
     * @uses LogicalFlight::setOriginDefaultTerminal()
     * @uses LogicalFlight::setOriginName()
     * @uses LogicalFlight::setDestination()
     * @uses LogicalFlight::setDestinationDefaultTerminal()
     * @uses LogicalFlight::setDestinationName()
     * @uses LogicalFlight::setOriginMetroGroup()
     * @uses LogicalFlight::setDestinationMetroGroup()
     * @uses LogicalFlight::setSellingCarrier()
     * @uses LogicalFlight::setOperatingCarrier()
     * @uses LogicalFlight::setOperatingFlightNumber()
     * @uses LogicalFlight::setDepartureTime()
     * @uses LogicalFlight::setArrivaltime()
     * @uses LogicalFlight::setPackageItemID()
     * @uses LogicalFlight::setPackageItemName()
     * @uses LogicalFlight::setPackageItemDescription()
     * @uses LogicalFlight::setPackageItemBookDate()
     * @uses LogicalFlight::setPackageItemStartDate()
     * @uses LogicalFlight::setPackageItemEndDate()
     * @uses LogicalFlight::setVendorId()
     * @uses LogicalFlight::setVendorName()
     * @uses LogicalFlight::setActive()
     * @uses LogicalFlight::setVendorDescription()
     * @uses LogicalFlight::setUIDisplayValue()
     * @uses LogicalFlight::setPhysicalFlights()
     * @uses LogicalFlight::setFlightDisruptionAlert()
     * @uses LogicalFlight::setMarketingFlightNumber()
     * @param string $key
     * @param int $recordNumber
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $origin
     * @param string $originDefaultTerminal
     * @param string $originName
     * @param string $destination
     * @param string $destinationDefaultTerminal
     * @param string $destinationName
     * @param string $originMetroGroup
     * @param string $destinationMetroGroup
     * @param string $sellingCarrier
     * @param string $operatingCarrier
     * @param string $operatingFlightNumber
     * @param string $departureTime
     * @param string $arrivaltime
     * @param int $packageItemID
     * @param string $packageItemName
     * @param string $packageItemDescription
     * @param string $packageItemBookDate
     * @param string $packageItemStartDate
     * @param string $packageItemEndDate
     * @param int $vendorId
     * @param string $vendorName
     * @param bool $active
     * @param string $vendorDescription
     * @param int $uIDisplayValue
     * @param \ArrayType\ArrayOfPhysicalFlight $physicalFlights
     * @param string $flightDisruptionAlert
     * @param string $marketingFlightNumber
     */
    public function __construct($key = null, $recordNumber = null, $logicalFlightID = null, $departureDate = null, $origin = null, $originDefaultTerminal = null, $originName = null, $destination = null, $destinationDefaultTerminal = null, $destinationName = null, $originMetroGroup = null, $destinationMetroGroup = null, $sellingCarrier = null, $operatingCarrier = null, $operatingFlightNumber = null, $departureTime = null, $arrivaltime = null, $packageItemID = null, $packageItemName = null, $packageItemDescription = null, $packageItemBookDate = null, $packageItemStartDate = null, $packageItemEndDate = null, $vendorId = null, $vendorName = null, $active = null, $vendorDescription = null, $uIDisplayValue = null, \ArrayType\ArrayOfPhysicalFlight $physicalFlights = null, $flightDisruptionAlert = null, $marketingFlightNumber = null)
    {
        $this
            ->setKey($key)
            ->setRecordNumber($recordNumber)
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setOriginDefaultTerminal($originDefaultTerminal)
            ->setOriginName($originName)
            ->setDestination($destination)
            ->setDestinationDefaultTerminal($destinationDefaultTerminal)
            ->setDestinationName($destinationName)
            ->setOriginMetroGroup($originMetroGroup)
            ->setDestinationMetroGroup($destinationMetroGroup)
            ->setSellingCarrier($sellingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setDepartureTime($departureTime)
            ->setArrivaltime($arrivaltime)
            ->setPackageItemID($packageItemID)
            ->setPackageItemName($packageItemName)
            ->setPackageItemDescription($packageItemDescription)
            ->setPackageItemBookDate($packageItemBookDate)
            ->setPackageItemStartDate($packageItemStartDate)
            ->setPackageItemEndDate($packageItemEndDate)
            ->setVendorId($vendorId)
            ->setVendorName($vendorName)
            ->setActive($active)
            ->setVendorDescription($vendorDescription)
            ->setUIDisplayValue($uIDisplayValue)
            ->setPhysicalFlights($physicalFlights)
            ->setFlightDisruptionAlert($flightDisruptionAlert)
            ->setMarketingFlightNumber($marketingFlightNumber);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\LogicalFlight
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\LogicalFlight
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\LogicalFlight
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\LogicalFlight
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\LogicalFlight
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get OriginDefaultTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginDefaultTerminal()
    {
        return isset($this->OriginDefaultTerminal) ? $this->OriginDefaultTerminal : null;
    }
    /**
     * Set OriginDefaultTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originDefaultTerminal
     * @return \StructType\LogicalFlight
     */
    public function setOriginDefaultTerminal($originDefaultTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($originDefaultTerminal) && !is_string($originDefaultTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDefaultTerminal, true), gettype($originDefaultTerminal)), __LINE__);
        }
        if (is_null($originDefaultTerminal) || (is_array($originDefaultTerminal) && empty($originDefaultTerminal))) {
            unset($this->OriginDefaultTerminal);
        } else {
            $this->OriginDefaultTerminal = $originDefaultTerminal;
        }
        return $this;
    }
    /**
     * Get OriginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginName()
    {
        return isset($this->OriginName) ? $this->OriginName : null;
    }
    /**
     * Set OriginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originName
     * @return \StructType\LogicalFlight
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        if (is_null($originName) || (is_array($originName) && empty($originName))) {
            unset($this->OriginName);
        } else {
            $this->OriginName = $originName;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\LogicalFlight
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get DestinationDefaultTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationDefaultTerminal()
    {
        return isset($this->DestinationDefaultTerminal) ? $this->DestinationDefaultTerminal : null;
    }
    /**
     * Set DestinationDefaultTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationDefaultTerminal
     * @return \StructType\LogicalFlight
     */
    public function setDestinationDefaultTerminal($destinationDefaultTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($destinationDefaultTerminal) && !is_string($destinationDefaultTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationDefaultTerminal, true), gettype($destinationDefaultTerminal)), __LINE__);
        }
        if (is_null($destinationDefaultTerminal) || (is_array($destinationDefaultTerminal) && empty($destinationDefaultTerminal))) {
            unset($this->DestinationDefaultTerminal);
        } else {
            $this->DestinationDefaultTerminal = $destinationDefaultTerminal;
        }
        return $this;
    }
    /**
     * Get DestinationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationName()
    {
        return isset($this->DestinationName) ? $this->DestinationName : null;
    }
    /**
     * Set DestinationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationName
     * @return \StructType\LogicalFlight
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        if (is_null($destinationName) || (is_array($destinationName) && empty($destinationName))) {
            unset($this->DestinationName);
        } else {
            $this->DestinationName = $destinationName;
        }
        return $this;
    }
    /**
     * Get OriginMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginMetroGroup()
    {
        return isset($this->OriginMetroGroup) ? $this->OriginMetroGroup : null;
    }
    /**
     * Set OriginMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originMetroGroup
     * @return \StructType\LogicalFlight
     */
    public function setOriginMetroGroup($originMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($originMetroGroup) && !is_string($originMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originMetroGroup, true), gettype($originMetroGroup)), __LINE__);
        }
        if (is_null($originMetroGroup) || (is_array($originMetroGroup) && empty($originMetroGroup))) {
            unset($this->OriginMetroGroup);
        } else {
            $this->OriginMetroGroup = $originMetroGroup;
        }
        return $this;
    }
    /**
     * Get DestinationMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationMetroGroup()
    {
        return isset($this->DestinationMetroGroup) ? $this->DestinationMetroGroup : null;
    }
    /**
     * Set DestinationMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationMetroGroup
     * @return \StructType\LogicalFlight
     */
    public function setDestinationMetroGroup($destinationMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($destinationMetroGroup) && !is_string($destinationMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationMetroGroup, true), gettype($destinationMetroGroup)), __LINE__);
        }
        if (is_null($destinationMetroGroup) || (is_array($destinationMetroGroup) && empty($destinationMetroGroup))) {
            unset($this->DestinationMetroGroup);
        } else {
            $this->DestinationMetroGroup = $destinationMetroGroup;
        }
        return $this;
    }
    /**
     * Get SellingCarrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellingCarrier()
    {
        return isset($this->SellingCarrier) ? $this->SellingCarrier : null;
    }
    /**
     * Set SellingCarrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellingCarrier
     * @return \StructType\LogicalFlight
     */
    public function setSellingCarrier($sellingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($sellingCarrier) && !is_string($sellingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingCarrier, true), gettype($sellingCarrier)), __LINE__);
        }
        if (is_null($sellingCarrier) || (is_array($sellingCarrier) && empty($sellingCarrier))) {
            unset($this->SellingCarrier);
        } else {
            $this->SellingCarrier = $sellingCarrier;
        }
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return isset($this->OperatingCarrier) ? $this->OperatingCarrier : null;
    }
    /**
     * Set OperatingCarrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrier
     * @return \StructType\LogicalFlight
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        if (is_null($operatingCarrier) || (is_array($operatingCarrier) && empty($operatingCarrier))) {
            unset($this->OperatingCarrier);
        } else {
            $this->OperatingCarrier = $operatingCarrier;
        }
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return isset($this->OperatingFlightNumber) ? $this->OperatingFlightNumber : null;
    }
    /**
     * Set OperatingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingFlightNumber
     * @return \StructType\LogicalFlight
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNumber, true), gettype($operatingFlightNumber)), __LINE__);
        }
        if (is_null($operatingFlightNumber) || (is_array($operatingFlightNumber) && empty($operatingFlightNumber))) {
            unset($this->OperatingFlightNumber);
        } else {
            $this->OperatingFlightNumber = $operatingFlightNumber;
        }
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\LogicalFlight
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Arrivaltime value
     * @return string|null
     */
    public function getArrivaltime()
    {
        return $this->Arrivaltime;
    }
    /**
     * Set Arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\LogicalFlight
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        $this->Arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get PackageItemID value
     * @return int|null
     */
    public function getPackageItemID()
    {
        return $this->PackageItemID;
    }
    /**
     * Set PackageItemID value
     * @param int $packageItemID
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemID($packageItemID = null)
    {
        // validation for constraint: int
        if (!is_null($packageItemID) && !(is_int($packageItemID) || ctype_digit($packageItemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageItemID, true), gettype($packageItemID)), __LINE__);
        }
        $this->PackageItemID = $packageItemID;
        return $this;
    }
    /**
     * Get PackageItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageItemName()
    {
        return isset($this->PackageItemName) ? $this->PackageItemName : null;
    }
    /**
     * Set PackageItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageItemName
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemName($packageItemName = null)
    {
        // validation for constraint: string
        if (!is_null($packageItemName) && !is_string($packageItemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageItemName, true), gettype($packageItemName)), __LINE__);
        }
        if (is_null($packageItemName) || (is_array($packageItemName) && empty($packageItemName))) {
            unset($this->PackageItemName);
        } else {
            $this->PackageItemName = $packageItemName;
        }
        return $this;
    }
    /**
     * Get PackageItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageItemDescription()
    {
        return isset($this->PackageItemDescription) ? $this->PackageItemDescription : null;
    }
    /**
     * Set PackageItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageItemDescription
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemDescription($packageItemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageItemDescription) && !is_string($packageItemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageItemDescription, true), gettype($packageItemDescription)), __LINE__);
        }
        if (is_null($packageItemDescription) || (is_array($packageItemDescription) && empty($packageItemDescription))) {
            unset($this->PackageItemDescription);
        } else {
            $this->PackageItemDescription = $packageItemDescription;
        }
        return $this;
    }
    /**
     * Get PackageItemBookDate value
     * @return string|null
     */
    public function getPackageItemBookDate()
    {
        return $this->PackageItemBookDate;
    }
    /**
     * Set PackageItemBookDate value
     * @param string $packageItemBookDate
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemBookDate($packageItemBookDate = null)
    {
        // validation for constraint: string
        if (!is_null($packageItemBookDate) && !is_string($packageItemBookDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageItemBookDate, true), gettype($packageItemBookDate)), __LINE__);
        }
        $this->PackageItemBookDate = $packageItemBookDate;
        return $this;
    }
    /**
     * Get PackageItemStartDate value
     * @return string|null
     */
    public function getPackageItemStartDate()
    {
        return $this->PackageItemStartDate;
    }
    /**
     * Set PackageItemStartDate value
     * @param string $packageItemStartDate
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemStartDate($packageItemStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($packageItemStartDate) && !is_string($packageItemStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageItemStartDate, true), gettype($packageItemStartDate)), __LINE__);
        }
        $this->PackageItemStartDate = $packageItemStartDate;
        return $this;
    }
    /**
     * Get PackageItemEndDate value
     * @return string|null
     */
    public function getPackageItemEndDate()
    {
        return $this->PackageItemEndDate;
    }
    /**
     * Set PackageItemEndDate value
     * @param string $packageItemEndDate
     * @return \StructType\LogicalFlight
     */
    public function setPackageItemEndDate($packageItemEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($packageItemEndDate) && !is_string($packageItemEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageItemEndDate, true), gettype($packageItemEndDate)), __LINE__);
        }
        $this->PackageItemEndDate = $packageItemEndDate;
        return $this;
    }
    /**
     * Get VendorId value
     * @return int|null
     */
    public function getVendorId()
    {
        return $this->VendorId;
    }
    /**
     * Set VendorId value
     * @param int $vendorId
     * @return \StructType\LogicalFlight
     */
    public function setVendorId($vendorId = null)
    {
        // validation for constraint: int
        if (!is_null($vendorId) && !(is_int($vendorId) || ctype_digit($vendorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vendorId, true), gettype($vendorId)), __LINE__);
        }
        $this->VendorId = $vendorId;
        return $this;
    }
    /**
     * Get VendorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVendorName()
    {
        return isset($this->VendorName) ? $this->VendorName : null;
    }
    /**
     * Set VendorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vendorName
     * @return \StructType\LogicalFlight
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        if (is_null($vendorName) || (is_array($vendorName) && empty($vendorName))) {
            unset($this->VendorName);
        } else {
            $this->VendorName = $vendorName;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\LogicalFlight
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get VendorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVendorDescription()
    {
        return isset($this->VendorDescription) ? $this->VendorDescription : null;
    }
    /**
     * Set VendorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vendorDescription
     * @return \StructType\LogicalFlight
     */
    public function setVendorDescription($vendorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($vendorDescription) && !is_string($vendorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorDescription, true), gettype($vendorDescription)), __LINE__);
        }
        if (is_null($vendorDescription) || (is_array($vendorDescription) && empty($vendorDescription))) {
            unset($this->VendorDescription);
        } else {
            $this->VendorDescription = $vendorDescription;
        }
        return $this;
    }
    /**
     * Get UIDisplayValue value
     * @return int|null
     */
    public function getUIDisplayValue()
    {
        return $this->UIDisplayValue;
    }
    /**
     * Set UIDisplayValue value
     * @param int $uIDisplayValue
     * @return \StructType\LogicalFlight
     */
    public function setUIDisplayValue($uIDisplayValue = null)
    {
        // validation for constraint: int
        if (!is_null($uIDisplayValue) && !(is_int($uIDisplayValue) || ctype_digit($uIDisplayValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uIDisplayValue, true), gettype($uIDisplayValue)), __LINE__);
        }
        $this->UIDisplayValue = $uIDisplayValue;
        return $this;
    }
    /**
     * Get PhysicalFlights value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPhysicalFlight|null
     */
    public function getPhysicalFlights()
    {
        return isset($this->PhysicalFlights) ? $this->PhysicalFlights : null;
    }
    /**
     * Set PhysicalFlights value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPhysicalFlight $physicalFlights
     * @return \StructType\LogicalFlight
     */
    public function setPhysicalFlights(\ArrayType\ArrayOfPhysicalFlight $physicalFlights = null)
    {
        if (is_null($physicalFlights) || (is_array($physicalFlights) && empty($physicalFlights))) {
            unset($this->PhysicalFlights);
        } else {
            $this->PhysicalFlights = $physicalFlights;
        }
        return $this;
    }
    /**
     * Get FlightDisruptionAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightDisruptionAlert()
    {
        return isset($this->FlightDisruptionAlert) ? $this->FlightDisruptionAlert : null;
    }
    /**
     * Set FlightDisruptionAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightDisruptionAlert
     * @return \StructType\LogicalFlight
     */
    public function setFlightDisruptionAlert($flightDisruptionAlert = null)
    {
        // validation for constraint: string
        if (!is_null($flightDisruptionAlert) && !is_string($flightDisruptionAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDisruptionAlert, true), gettype($flightDisruptionAlert)), __LINE__);
        }
        if (is_null($flightDisruptionAlert) || (is_array($flightDisruptionAlert) && empty($flightDisruptionAlert))) {
            unset($this->FlightDisruptionAlert);
        } else {
            $this->FlightDisruptionAlert = $flightDisruptionAlert;
        }
        return $this;
    }
    /**
     * Get MarketingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingFlightNumber()
    {
        return isset($this->MarketingFlightNumber) ? $this->MarketingFlightNumber : null;
    }
    /**
     * Set MarketingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingFlightNumber
     * @return \StructType\LogicalFlight
     */
    public function setMarketingFlightNumber($marketingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($marketingFlightNumber) && !is_string($marketingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingFlightNumber, true), gettype($marketingFlightNumber)), __LINE__);
        }
        if (is_null($marketingFlightNumber) || (is_array($marketingFlightNumber) && empty($marketingFlightNumber))) {
            unset($this->MarketingFlightNumber);
        } else {
            $this->MarketingFlightNumber = $marketingFlightNumber;
        }
        return $this;
    }
}
