<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyConversion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CurrencyConversion
 * @subpackage Structs
 */
class CurrencyConversion extends AbstractStructBase
{
    /**
     * The CurrencyToConvertFrom
     * @var string
     */
    public $CurrencyToConvertFrom;
    /**
     * The CurrencyToConvertTo
     * @var string
     */
    public $CurrencyToConvertTo;
    /**
     * The AmountToConvert
     * @var float
     */
    public $AmountToConvert;
    /**
     * The AmountPriorToConversion
     * @var float
     */
    public $AmountPriorToConversion;
    /**
     * The ConvertedAmount
     * @var float
     */
    public $ConvertedAmount;
    /**
     * The ExchangeRate
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * Constructor method for CurrencyConversion
     * @uses CurrencyConversion::setCurrencyToConvertFrom()
     * @uses CurrencyConversion::setCurrencyToConvertTo()
     * @uses CurrencyConversion::setAmountToConvert()
     * @uses CurrencyConversion::setAmountPriorToConversion()
     * @uses CurrencyConversion::setConvertedAmount()
     * @uses CurrencyConversion::setExchangeRate()
     * @uses CurrencyConversion::setExchangeRateDate()
     * @param string $currencyToConvertFrom
     * @param string $currencyToConvertTo
     * @param float $amountToConvert
     * @param float $amountPriorToConversion
     * @param float $convertedAmount
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     */
    public function __construct($currencyToConvertFrom = null, $currencyToConvertTo = null, $amountToConvert = null, $amountPriorToConversion = null, $convertedAmount = null, $exchangeRate = null, $exchangeRateDate = null)
    {
        $this
            ->setCurrencyToConvertFrom($currencyToConvertFrom)
            ->setCurrencyToConvertTo($currencyToConvertTo)
            ->setAmountToConvert($amountToConvert)
            ->setAmountPriorToConversion($amountPriorToConversion)
            ->setConvertedAmount($convertedAmount)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate);
    }
    /**
     * Get CurrencyToConvertFrom value
     * @return string|null
     */
    public function getCurrencyToConvertFrom()
    {
        return $this->CurrencyToConvertFrom;
    }
    /**
     * Set CurrencyToConvertFrom value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyToConvertFrom
     * @return \StructType\CurrencyConversion
     */
    public function setCurrencyToConvertFrom($currencyToConvertFrom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyToConvertFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyToConvertFrom) ? implode(', ', $currencyToConvertFrom) : var_export($currencyToConvertFrom, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyToConvertFrom = $currencyToConvertFrom;
        return $this;
    }
    /**
     * Get CurrencyToConvertTo value
     * @return string|null
     */
    public function getCurrencyToConvertTo()
    {
        return $this->CurrencyToConvertTo;
    }
    /**
     * Set CurrencyToConvertTo value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyToConvertTo
     * @return \StructType\CurrencyConversion
     */
    public function setCurrencyToConvertTo($currencyToConvertTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currencyToConvertTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currencyToConvertTo) ? implode(', ', $currencyToConvertTo) : var_export($currencyToConvertTo, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->CurrencyToConvertTo = $currencyToConvertTo;
        return $this;
    }
    /**
     * Get AmountToConvert value
     * @return float|null
     */
    public function getAmountToConvert()
    {
        return $this->AmountToConvert;
    }
    /**
     * Set AmountToConvert value
     * @param float $amountToConvert
     * @return \StructType\CurrencyConversion
     */
    public function setAmountToConvert($amountToConvert = null)
    {
        // validation for constraint: float
        if (!is_null($amountToConvert) && !(is_float($amountToConvert) || is_numeric($amountToConvert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountToConvert, true), gettype($amountToConvert)), __LINE__);
        }
        $this->AmountToConvert = $amountToConvert;
        return $this;
    }
    /**
     * Get AmountPriorToConversion value
     * @return float|null
     */
    public function getAmountPriorToConversion()
    {
        return $this->AmountPriorToConversion;
    }
    /**
     * Set AmountPriorToConversion value
     * @param float $amountPriorToConversion
     * @return \StructType\CurrencyConversion
     */
    public function setAmountPriorToConversion($amountPriorToConversion = null)
    {
        // validation for constraint: float
        if (!is_null($amountPriorToConversion) && !(is_float($amountPriorToConversion) || is_numeric($amountPriorToConversion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPriorToConversion, true), gettype($amountPriorToConversion)), __LINE__);
        }
        $this->AmountPriorToConversion = $amountPriorToConversion;
        return $this;
    }
    /**
     * Get ConvertedAmount value
     * @return float|null
     */
    public function getConvertedAmount()
    {
        return $this->ConvertedAmount;
    }
    /**
     * Set ConvertedAmount value
     * @param float $convertedAmount
     * @return \StructType\CurrencyConversion
     */
    public function setConvertedAmount($convertedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($convertedAmount) && !(is_float($convertedAmount) || is_numeric($convertedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($convertedAmount, true), gettype($convertedAmount)), __LINE__);
        }
        $this->ConvertedAmount = $convertedAmount;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CurrencyConversion
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\CurrencyConversion
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
}
