<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessPNRPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPNRPayment $parameters
     * @return \StructType\ProcessPNRPaymentResponse|bool
     */
    public function ProcessPNRPayment(\StructType\ProcessPNRPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPNRPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessItemPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessItemPayment $parameters
     * @return \StructType\ProcessItemPaymentResponse|bool
     */
    public function ProcessItemPayment(\StructType\ProcessItemPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessItemPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessItemPaymentResponse|\StructType\ProcessPNRPaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
