<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessPNRPayment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessPNRPayment
 * @subpackage Structs
 */
class ProcessPNRPayment extends Payment
{
    /**
     * The PNRPaymentRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PNRPayments
     */
    public $PNRPaymentRequest;
    /**
     * Constructor method for ProcessPNRPayment
     * @uses ProcessPNRPayment::setPNRPaymentRequest()
     * @param \StructType\PNRPayments $pNRPaymentRequest
     */
    public function __construct(\StructType\PNRPayments $pNRPaymentRequest = null)
    {
        $this
            ->setPNRPaymentRequest($pNRPaymentRequest);
    }
    /**
     * Get PNRPaymentRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PNRPayments|null
     */
    public function getPNRPaymentRequest()
    {
        return isset($this->PNRPaymentRequest) ? $this->PNRPaymentRequest : null;
    }
    /**
     * Set PNRPaymentRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PNRPayments $pNRPaymentRequest
     * @return \StructType\ProcessPNRPayment
     */
    public function setPNRPaymentRequest(\StructType\PNRPayments $pNRPaymentRequest = null)
    {
        if (is_null($pNRPaymentRequest) || (is_array($pNRPaymentRequest) && empty($pNRPaymentRequest))) {
            unset($this->PNRPaymentRequest);
        } else {
            $this->PNRPaymentRequest = $pNRPaymentRequest;
        }
        return $this;
    }
}
