<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalProcessedPayments StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExternalProcessedPayments
 * @subpackage Structs
 */
class ExternalProcessedPayments extends AbstractStructBase
{
    /**
     * The TransactionInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TransactionInfo
     */
    public $TransactionInfo;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ExternalPayments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInsertExternalProcessedPayment
     */
    public $ExternalPayments;
    /**
     * Constructor method for ExternalProcessedPayments
     * @uses ExternalProcessedPayments::setTransactionInfo()
     * @uses ExternalProcessedPayments::setReservationInfo()
     * @uses ExternalProcessedPayments::setExternalPayments()
     * @param \StructType\TransactionInfo $transactionInfo
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfInsertExternalProcessedPayment $externalPayments
     */
    public function __construct(\StructType\TransactionInfo $transactionInfo = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfInsertExternalProcessedPayment $externalPayments = null)
    {
        $this
            ->setTransactionInfo($transactionInfo)
            ->setReservationInfo($reservationInfo)
            ->setExternalPayments($externalPayments);
    }
    /**
     * Get TransactionInfo value
     * @return \StructType\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->TransactionInfo;
    }
    /**
     * Set TransactionInfo value
     * @param \StructType\TransactionInfo $transactionInfo
     * @return \StructType\ExternalProcessedPayments
     */
    public function setTransactionInfo(\StructType\TransactionInfo $transactionInfo = null)
    {
        $this->TransactionInfo = $transactionInfo;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\ExternalProcessedPayments
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ExternalPayments value
     * @return \ArrayType\ArrayOfInsertExternalProcessedPayment|null
     */
    public function getExternalPayments()
    {
        return $this->ExternalPayments;
    }
    /**
     * Set ExternalPayments value
     * @param \ArrayType\ArrayOfInsertExternalProcessedPayment $externalPayments
     * @return \StructType\ExternalProcessedPayments
     */
    public function setExternalPayments(\ArrayType\ArrayOfInsertExternalProcessedPayment $externalPayments = null)
    {
        $this->ExternalPayments = $externalPayments;
        return $this;
    }
}
