<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewPNR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewPNR
 * @subpackage Structs
 */
class ViewPNR extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The BookingAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingAgent;
    /**
     * The CRSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CRSCode;
    /**
     * The TravelGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TravelGroupID;
    /**
     * The IATANumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATANumber;
    /**
     * The ExternalAppID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalAppID;
    /**
     * The WebBookingID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebBookingID;
    /**
     * The PromotionalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PromotionalID;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromotionalCode;
    /**
     * The RecieptLanguageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecieptLanguageID;
    /**
     * The ReservationCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationCurrency;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * The PNRPin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PNRPin;
    /**
     * The BookDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookDate;
    /**
     * The ReservationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationType;
    /**
     * The TodaysDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TodaysDate;
    /**
     * The LastModified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastModified;
    /**
     * The ReservationExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationExpirationDate;
    /**
     * The CorporationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CorporationID;
    /**
     * The SecurityGuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityGuid;
    /**
     * The HasTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasTickets;
    /**
     * The ValuePackageData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValuePackageData;
    /**
     * The UserIPAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserIPAddress;
    /**
     * The ManageBookingAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManageBookingAgent;
    /**
     * The HistoricConfirmationNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoricConfirmationNum;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The ReservationBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ReservationBalance;
    /**
     * The ChangeFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ChangeFee;
    /**
     * The LogicalFlightCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LogicalFlightCount;
    /**
     * The ActivePassengerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ActivePassengerCount;
    /**
     * The BalancedReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BalancedReservation;
    /**
     * The ReservationFulfillmentRequiredByGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationFulfillmentRequiredByGMT;
    /**
     * The ReservationFulfillmentRequiredByODT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationFulfillmentRequiredByODT;
    /**
     * The Airlines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirline
     */
    public $Airlines;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayment
     */
    public $Payments;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHistory
     */
    public $History;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfComment
     */
    public $Comments;
    /**
     * The GDSHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGDSHistory
     */
    public $GDSHistory;
    /**
     * The ReservationContacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReservationContact
     */
    public $ReservationContacts;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfos;
    /**
     * The Vouchers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVoucher
     */
    public $Vouchers;
    /**
     * The Cars
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCar
     */
    public $Cars;
    /**
     * The Hotels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotel
     */
    public $Hotels;
    /**
     * The Packages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPackage
     */
    public $Packages;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The TotalCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalCommission;
    /**
     * The IsExternalPriced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExternalPriced;
    /**
     * Constructor method for ViewPNR
     * @uses ViewPNR::setKey()
     * @uses ViewPNR::setSeriesNumber()
     * @uses ViewPNR::setConfirmationNumber()
     * @uses ViewPNR::setBookingAgent()
     * @uses ViewPNR::setCRSCode()
     * @uses ViewPNR::setTravelGroupID()
     * @uses ViewPNR::setIATANumber()
     * @uses ViewPNR::setExternalAppID()
     * @uses ViewPNR::setWebBookingID()
     * @uses ViewPNR::setPromotionalID()
     * @uses ViewPNR::setPromotionalCode()
     * @uses ViewPNR::setRecieptLanguageID()
     * @uses ViewPNR::setReservationCurrency()
     * @uses ViewPNR::setProfileID()
     * @uses ViewPNR::setPNRPin()
     * @uses ViewPNR::setBookDate()
     * @uses ViewPNR::setReservationType()
     * @uses ViewPNR::setTodaysDate()
     * @uses ViewPNR::setLastModified()
     * @uses ViewPNR::setReservationExpirationDate()
     * @uses ViewPNR::setCorporationID()
     * @uses ViewPNR::setSecurityGuid()
     * @uses ViewPNR::setHasTickets()
     * @uses ViewPNR::setValuePackageData()
     * @uses ViewPNR::setUserIPAddress()
     * @uses ViewPNR::setManageBookingAgent()
     * @uses ViewPNR::setHistoricConfirmationNum()
     * @uses ViewPNR::setCabin()
     * @uses ViewPNR::setReservationBalance()
     * @uses ViewPNR::setChangeFee()
     * @uses ViewPNR::setLogicalFlightCount()
     * @uses ViewPNR::setActivePassengerCount()
     * @uses ViewPNR::setBalancedReservation()
     * @uses ViewPNR::setReservationFulfillmentRequiredByGMT()
     * @uses ViewPNR::setReservationFulfillmentRequiredByODT()
     * @uses ViewPNR::setAirlines()
     * @uses ViewPNR::setPayments()
     * @uses ViewPNR::setHistory()
     * @uses ViewPNR::setComments()
     * @uses ViewPNR::setGDSHistory()
     * @uses ViewPNR::setReservationContacts()
     * @uses ViewPNR::setContactInfos()
     * @uses ViewPNR::setVouchers()
     * @uses ViewPNR::setCars()
     * @uses ViewPNR::setHotels()
     * @uses ViewPNR::setPackages()
     * @uses ViewPNR::setExceptions()
     * @uses ViewPNR::setTotalCommission()
     * @uses ViewPNR::setIsExternalPriced()
     * @param string $key
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $bookingAgent
     * @param string $cRSCode
     * @param int $travelGroupID
     * @param string $iATANumber
     * @param string $externalAppID
     * @param string $webBookingID
     * @param int $promotionalID
     * @param string $promotionalCode
     * @param int $recieptLanguageID
     * @param string $reservationCurrency
     * @param int $profileID
     * @param int $pNRPin
     * @param string $bookDate
     * @param string $reservationType
     * @param string $todaysDate
     * @param string $lastModified
     * @param string $reservationExpirationDate
     * @param string $corporationID
     * @param string $securityGuid
     * @param bool $hasTickets
     * @param string $valuePackageData
     * @param string $userIPAddress
     * @param string $manageBookingAgent
     * @param string $historicConfirmationNum
     * @param string $cabin
     * @param float $reservationBalance
     * @param float $changeFee
     * @param int $logicalFlightCount
     * @param int $activePassengerCount
     * @param bool $balancedReservation
     * @param string $reservationFulfillmentRequiredByGMT
     * @param string $reservationFulfillmentRequiredByODT
     * @param \ArrayType\ArrayOfAirline $airlines
     * @param \ArrayType\ArrayOfPayment $payments
     * @param \ArrayType\ArrayOfHistory $history
     * @param \ArrayType\ArrayOfComment $comments
     * @param \ArrayType\ArrayOfGDSHistory $gDSHistory
     * @param \ArrayType\ArrayOfReservationContact $reservationContacts
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @param \ArrayType\ArrayOfVoucher $vouchers
     * @param \ArrayType\ArrayOfCar $cars
     * @param \ArrayType\ArrayOfHotel $hotels
     * @param \ArrayType\ArrayOfPackage $packages
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param float $totalCommission
     * @param bool $isExternalPriced
     */
    public function __construct($key = null, $seriesNumber = null, $confirmationNumber = null, $bookingAgent = null, $cRSCode = null, $travelGroupID = null, $iATANumber = null, $externalAppID = null, $webBookingID = null, $promotionalID = null, $promotionalCode = null, $recieptLanguageID = null, $reservationCurrency = null, $profileID = null, $pNRPin = null, $bookDate = null, $reservationType = null, $todaysDate = null, $lastModified = null, $reservationExpirationDate = null, $corporationID = null, $securityGuid = null, $hasTickets = null, $valuePackageData = null, $userIPAddress = null, $manageBookingAgent = null, $historicConfirmationNum = null, $cabin = null, $reservationBalance = null, $changeFee = null, $logicalFlightCount = null, $activePassengerCount = null, $balancedReservation = null, $reservationFulfillmentRequiredByGMT = null, $reservationFulfillmentRequiredByODT = null, \ArrayType\ArrayOfAirline $airlines = null, \ArrayType\ArrayOfPayment $payments = null, \ArrayType\ArrayOfHistory $history = null, \ArrayType\ArrayOfComment $comments = null, \ArrayType\ArrayOfGDSHistory $gDSHistory = null, \ArrayType\ArrayOfReservationContact $reservationContacts = null, \ArrayType\ArrayOfContactInfo $contactInfos = null, \ArrayType\ArrayOfVoucher $vouchers = null, \ArrayType\ArrayOfCar $cars = null, \ArrayType\ArrayOfHotel $hotels = null, \ArrayType\ArrayOfPackage $packages = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, $totalCommission = null, $isExternalPriced = null)
    {
        $this
            ->setKey($key)
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setBookingAgent($bookingAgent)
            ->setCRSCode($cRSCode)
            ->setTravelGroupID($travelGroupID)
            ->setIATANumber($iATANumber)
            ->setExternalAppID($externalAppID)
            ->setWebBookingID($webBookingID)
            ->setPromotionalID($promotionalID)
            ->setPromotionalCode($promotionalCode)
            ->setRecieptLanguageID($recieptLanguageID)
            ->setReservationCurrency($reservationCurrency)
            ->setProfileID($profileID)
            ->setPNRPin($pNRPin)
            ->setBookDate($bookDate)
            ->setReservationType($reservationType)
            ->setTodaysDate($todaysDate)
            ->setLastModified($lastModified)
            ->setReservationExpirationDate($reservationExpirationDate)
            ->setCorporationID($corporationID)
            ->setSecurityGuid($securityGuid)
            ->setHasTickets($hasTickets)
            ->setValuePackageData($valuePackageData)
            ->setUserIPAddress($userIPAddress)
            ->setManageBookingAgent($manageBookingAgent)
            ->setHistoricConfirmationNum($historicConfirmationNum)
            ->setCabin($cabin)
            ->setReservationBalance($reservationBalance)
            ->setChangeFee($changeFee)
            ->setLogicalFlightCount($logicalFlightCount)
            ->setActivePassengerCount($activePassengerCount)
            ->setBalancedReservation($balancedReservation)
            ->setReservationFulfillmentRequiredByGMT($reservationFulfillmentRequiredByGMT)
            ->setReservationFulfillmentRequiredByODT($reservationFulfillmentRequiredByODT)
            ->setAirlines($airlines)
            ->setPayments($payments)
            ->setHistory($history)
            ->setComments($comments)
            ->setGDSHistory($gDSHistory)
            ->setReservationContacts($reservationContacts)
            ->setContactInfos($contactInfos)
            ->setVouchers($vouchers)
            ->setCars($cars)
            ->setHotels($hotels)
            ->setPackages($packages)
            ->setExceptions($exceptions)
            ->setTotalCommission($totalCommission)
            ->setIsExternalPriced($isExternalPriced);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\ViewPNR
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get SeriesNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return isset($this->SeriesNumber) ? $this->SeriesNumber : null;
    }
    /**
     * Set SeriesNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNumber
     * @return \StructType\ViewPNR
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        if (is_null($seriesNumber) || (is_array($seriesNumber) && empty($seriesNumber))) {
            unset($this->SeriesNumber);
        } else {
            $this->SeriesNumber = $seriesNumber;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\ViewPNR
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get BookingAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingAgent()
    {
        return isset($this->BookingAgent) ? $this->BookingAgent : null;
    }
    /**
     * Set BookingAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingAgent
     * @return \StructType\ViewPNR
     */
    public function setBookingAgent($bookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($bookingAgent) && !is_string($bookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingAgent, true), gettype($bookingAgent)), __LINE__);
        }
        if (is_null($bookingAgent) || (is_array($bookingAgent) && empty($bookingAgent))) {
            unset($this->BookingAgent);
        } else {
            $this->BookingAgent = $bookingAgent;
        }
        return $this;
    }
    /**
     * Get CRSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCRSCode()
    {
        return isset($this->CRSCode) ? $this->CRSCode : null;
    }
    /**
     * Set CRSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cRSCode
     * @return \StructType\ViewPNR
     */
    public function setCRSCode($cRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($cRSCode) && !is_string($cRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSCode, true), gettype($cRSCode)), __LINE__);
        }
        if (is_null($cRSCode) || (is_array($cRSCode) && empty($cRSCode))) {
            unset($this->CRSCode);
        } else {
            $this->CRSCode = $cRSCode;
        }
        return $this;
    }
    /**
     * Get TravelGroupID value
     * @return int|null
     */
    public function getTravelGroupID()
    {
        return $this->TravelGroupID;
    }
    /**
     * Set TravelGroupID value
     * @param int $travelGroupID
     * @return \StructType\ViewPNR
     */
    public function setTravelGroupID($travelGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroupID) && !(is_int($travelGroupID) || ctype_digit($travelGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroupID, true), gettype($travelGroupID)), __LINE__);
        }
        $this->TravelGroupID = $travelGroupID;
        return $this;
    }
    /**
     * Get IATANumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATANumber()
    {
        return isset($this->IATANumber) ? $this->IATANumber : null;
    }
    /**
     * Set IATANumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATANumber
     * @return \StructType\ViewPNR
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATANumber, true), gettype($iATANumber)), __LINE__);
        }
        if (is_null($iATANumber) || (is_array($iATANumber) && empty($iATANumber))) {
            unset($this->IATANumber);
        } else {
            $this->IATANumber = $iATANumber;
        }
        return $this;
    }
    /**
     * Get ExternalAppID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalAppID()
    {
        return isset($this->ExternalAppID) ? $this->ExternalAppID : null;
    }
    /**
     * Set ExternalAppID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalAppID
     * @return \StructType\ViewPNR
     */
    public function setExternalAppID($externalAppID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAppID) && !is_string($externalAppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAppID, true), gettype($externalAppID)), __LINE__);
        }
        if (is_null($externalAppID) || (is_array($externalAppID) && empty($externalAppID))) {
            unset($this->ExternalAppID);
        } else {
            $this->ExternalAppID = $externalAppID;
        }
        return $this;
    }
    /**
     * Get WebBookingID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebBookingID()
    {
        return isset($this->WebBookingID) ? $this->WebBookingID : null;
    }
    /**
     * Set WebBookingID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webBookingID
     * @return \StructType\ViewPNR
     */
    public function setWebBookingID($webBookingID = null)
    {
        // validation for constraint: string
        if (!is_null($webBookingID) && !is_string($webBookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webBookingID, true), gettype($webBookingID)), __LINE__);
        }
        if (is_null($webBookingID) || (is_array($webBookingID) && empty($webBookingID))) {
            unset($this->WebBookingID);
        } else {
            $this->WebBookingID = $webBookingID;
        }
        return $this;
    }
    /**
     * Get PromotionalID value
     * @return int|null
     */
    public function getPromotionalID()
    {
        return $this->PromotionalID;
    }
    /**
     * Set PromotionalID value
     * @param int $promotionalID
     * @return \StructType\ViewPNR
     */
    public function setPromotionalID($promotionalID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionalID) && !(is_int($promotionalID) || ctype_digit($promotionalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($promotionalID, true), gettype($promotionalID)), __LINE__);
        }
        $this->PromotionalID = $promotionalID;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return isset($this->PromotionalCode) ? $this->PromotionalCode : null;
    }
    /**
     * Set PromotionalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promotionalCode
     * @return \StructType\ViewPNR
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        if (is_null($promotionalCode) || (is_array($promotionalCode) && empty($promotionalCode))) {
            unset($this->PromotionalCode);
        } else {
            $this->PromotionalCode = $promotionalCode;
        }
        return $this;
    }
    /**
     * Get RecieptLanguageID value
     * @return int|null
     */
    public function getRecieptLanguageID()
    {
        return $this->RecieptLanguageID;
    }
    /**
     * Set RecieptLanguageID value
     * @param int $recieptLanguageID
     * @return \StructType\ViewPNR
     */
    public function setRecieptLanguageID($recieptLanguageID = null)
    {
        // validation for constraint: int
        if (!is_null($recieptLanguageID) && !(is_int($recieptLanguageID) || ctype_digit($recieptLanguageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recieptLanguageID, true), gettype($recieptLanguageID)), __LINE__);
        }
        $this->RecieptLanguageID = $recieptLanguageID;
        return $this;
    }
    /**
     * Get ReservationCurrency value
     * @return string|null
     */
    public function getReservationCurrency()
    {
        return $this->ReservationCurrency;
    }
    /**
     * Set ReservationCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationCurrency
     * @return \StructType\ViewPNR
     */
    public function setReservationCurrency($reservationCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($reservationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($reservationCurrency) ? implode(', ', $reservationCurrency) : var_export($reservationCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->ReservationCurrency = $reservationCurrency;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\ViewPNR
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get PNRPin value
     * @return int|null
     */
    public function getPNRPin()
    {
        return $this->PNRPin;
    }
    /**
     * Set PNRPin value
     * @param int $pNRPin
     * @return \StructType\ViewPNR
     */
    public function setPNRPin($pNRPin = null)
    {
        // validation for constraint: int
        if (!is_null($pNRPin) && !(is_int($pNRPin) || ctype_digit($pNRPin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pNRPin, true), gettype($pNRPin)), __LINE__);
        }
        $this->PNRPin = $pNRPin;
        return $this;
    }
    /**
     * Get BookDate value
     * @return string|null
     */
    public function getBookDate()
    {
        return $this->BookDate;
    }
    /**
     * Set BookDate value
     * @param string $bookDate
     * @return \StructType\ViewPNR
     */
    public function setBookDate($bookDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookDate) && !is_string($bookDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookDate, true), gettype($bookDate)), __LINE__);
        }
        $this->BookDate = $bookDate;
        return $this;
    }
    /**
     * Get ReservationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationType()
    {
        return isset($this->ReservationType) ? $this->ReservationType : null;
    }
    /**
     * Set ReservationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationType
     * @return \StructType\ViewPNR
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationType, true), gettype($reservationType)), __LINE__);
        }
        if (is_null($reservationType) || (is_array($reservationType) && empty($reservationType))) {
            unset($this->ReservationType);
        } else {
            $this->ReservationType = $reservationType;
        }
        return $this;
    }
    /**
     * Get TodaysDate value
     * @return string|null
     */
    public function getTodaysDate()
    {
        return $this->TodaysDate;
    }
    /**
     * Set TodaysDate value
     * @param string $todaysDate
     * @return \StructType\ViewPNR
     */
    public function setTodaysDate($todaysDate = null)
    {
        // validation for constraint: string
        if (!is_null($todaysDate) && !is_string($todaysDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($todaysDate, true), gettype($todaysDate)), __LINE__);
        }
        $this->TodaysDate = $todaysDate;
        return $this;
    }
    /**
     * Get LastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->LastModified;
    }
    /**
     * Set LastModified value
     * @param string $lastModified
     * @return \StructType\ViewPNR
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->LastModified = $lastModified;
        return $this;
    }
    /**
     * Get ReservationExpirationDate value
     * @return string|null
     */
    public function getReservationExpirationDate()
    {
        return $this->ReservationExpirationDate;
    }
    /**
     * Set ReservationExpirationDate value
     * @param string $reservationExpirationDate
     * @return \StructType\ViewPNR
     */
    public function setReservationExpirationDate($reservationExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpirationDate) && !is_string($reservationExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpirationDate, true), gettype($reservationExpirationDate)), __LINE__);
        }
        $this->ReservationExpirationDate = $reservationExpirationDate;
        return $this;
    }
    /**
     * Get CorporationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorporationID()
    {
        return isset($this->CorporationID) ? $this->CorporationID : null;
    }
    /**
     * Set CorporationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $corporationID
     * @return \StructType\ViewPNR
     */
    public function setCorporationID($corporationID = null)
    {
        // validation for constraint: string
        if (!is_null($corporationID) && !is_string($corporationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporationID, true), gettype($corporationID)), __LINE__);
        }
        if (is_null($corporationID) || (is_array($corporationID) && empty($corporationID))) {
            unset($this->CorporationID);
        } else {
            $this->CorporationID = $corporationID;
        }
        return $this;
    }
    /**
     * Get SecurityGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityGuid()
    {
        return isset($this->SecurityGuid) ? $this->SecurityGuid : null;
    }
    /**
     * Set SecurityGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityGuid
     * @return \StructType\ViewPNR
     */
    public function setSecurityGuid($securityGuid = null)
    {
        // validation for constraint: string
        if (!is_null($securityGuid) && !is_string($securityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityGuid, true), gettype($securityGuid)), __LINE__);
        }
        if (is_null($securityGuid) || (is_array($securityGuid) && empty($securityGuid))) {
            unset($this->SecurityGuid);
        } else {
            $this->SecurityGuid = $securityGuid;
        }
        return $this;
    }
    /**
     * Get HasTickets value
     * @return bool|null
     */
    public function getHasTickets()
    {
        return $this->HasTickets;
    }
    /**
     * Set HasTickets value
     * @param bool $hasTickets
     * @return \StructType\ViewPNR
     */
    public function setHasTickets($hasTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTickets) && !is_bool($hasTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTickets, true), gettype($hasTickets)), __LINE__);
        }
        $this->HasTickets = $hasTickets;
        return $this;
    }
    /**
     * Get ValuePackageData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValuePackageData()
    {
        return isset($this->ValuePackageData) ? $this->ValuePackageData : null;
    }
    /**
     * Set ValuePackageData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valuePackageData
     * @return \StructType\ViewPNR
     */
    public function setValuePackageData($valuePackageData = null)
    {
        // validation for constraint: string
        if (!is_null($valuePackageData) && !is_string($valuePackageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valuePackageData, true), gettype($valuePackageData)), __LINE__);
        }
        if (is_null($valuePackageData) || (is_array($valuePackageData) && empty($valuePackageData))) {
            unset($this->ValuePackageData);
        } else {
            $this->ValuePackageData = $valuePackageData;
        }
        return $this;
    }
    /**
     * Get UserIPAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserIPAddress()
    {
        return isset($this->UserIPAddress) ? $this->UserIPAddress : null;
    }
    /**
     * Set UserIPAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userIPAddress
     * @return \StructType\ViewPNR
     */
    public function setUserIPAddress($userIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($userIPAddress) && !is_string($userIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIPAddress, true), gettype($userIPAddress)), __LINE__);
        }
        if (is_null($userIPAddress) || (is_array($userIPAddress) && empty($userIPAddress))) {
            unset($this->UserIPAddress);
        } else {
            $this->UserIPAddress = $userIPAddress;
        }
        return $this;
    }
    /**
     * Get ManageBookingAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManageBookingAgent()
    {
        return isset($this->ManageBookingAgent) ? $this->ManageBookingAgent : null;
    }
    /**
     * Set ManageBookingAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $manageBookingAgent
     * @return \StructType\ViewPNR
     */
    public function setManageBookingAgent($manageBookingAgent = null)
    {
        // validation for constraint: string
        if (!is_null($manageBookingAgent) && !is_string($manageBookingAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manageBookingAgent, true), gettype($manageBookingAgent)), __LINE__);
        }
        if (is_null($manageBookingAgent) || (is_array($manageBookingAgent) && empty($manageBookingAgent))) {
            unset($this->ManageBookingAgent);
        } else {
            $this->ManageBookingAgent = $manageBookingAgent;
        }
        return $this;
    }
    /**
     * Get HistoricConfirmationNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoricConfirmationNum()
    {
        return isset($this->HistoricConfirmationNum) ? $this->HistoricConfirmationNum : null;
    }
    /**
     * Set HistoricConfirmationNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historicConfirmationNum
     * @return \StructType\ViewPNR
     */
    public function setHistoricConfirmationNum($historicConfirmationNum = null)
    {
        // validation for constraint: string
        if (!is_null($historicConfirmationNum) && !is_string($historicConfirmationNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historicConfirmationNum, true), gettype($historicConfirmationNum)), __LINE__);
        }
        if (is_null($historicConfirmationNum) || (is_array($historicConfirmationNum) && empty($historicConfirmationNum))) {
            unset($this->HistoricConfirmationNum);
        } else {
            $this->HistoricConfirmationNum = $historicConfirmationNum;
        }
        return $this;
    }
    /**
     * Get Cabin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabin()
    {
        return isset($this->Cabin) ? $this->Cabin : null;
    }
    /**
     * Set Cabin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabin
     * @return \StructType\ViewPNR
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        if (is_null($cabin) || (is_array($cabin) && empty($cabin))) {
            unset($this->Cabin);
        } else {
            $this->Cabin = $cabin;
        }
        return $this;
    }
    /**
     * Get ReservationBalance value
     * @return float|null
     */
    public function getReservationBalance()
    {
        return $this->ReservationBalance;
    }
    /**
     * Set ReservationBalance value
     * @param float $reservationBalance
     * @return \StructType\ViewPNR
     */
    public function setReservationBalance($reservationBalance = null)
    {
        // validation for constraint: float
        if (!is_null($reservationBalance) && !(is_float($reservationBalance) || is_numeric($reservationBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservationBalance, true), gettype($reservationBalance)), __LINE__);
        }
        $this->ReservationBalance = $reservationBalance;
        return $this;
    }
    /**
     * Get ChangeFee value
     * @return float|null
     */
    public function getChangeFee()
    {
        return $this->ChangeFee;
    }
    /**
     * Set ChangeFee value
     * @param float $changeFee
     * @return \StructType\ViewPNR
     */
    public function setChangeFee($changeFee = null)
    {
        // validation for constraint: float
        if (!is_null($changeFee) && !(is_float($changeFee) || is_numeric($changeFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($changeFee, true), gettype($changeFee)), __LINE__);
        }
        $this->ChangeFee = $changeFee;
        return $this;
    }
    /**
     * Get LogicalFlightCount value
     * @return int|null
     */
    public function getLogicalFlightCount()
    {
        return $this->LogicalFlightCount;
    }
    /**
     * Set LogicalFlightCount value
     * @param int $logicalFlightCount
     * @return \StructType\ViewPNR
     */
    public function setLogicalFlightCount($logicalFlightCount = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightCount) && !(is_int($logicalFlightCount) || ctype_digit($logicalFlightCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightCount, true), gettype($logicalFlightCount)), __LINE__);
        }
        $this->LogicalFlightCount = $logicalFlightCount;
        return $this;
    }
    /**
     * Get ActivePassengerCount value
     * @return int|null
     */
    public function getActivePassengerCount()
    {
        return $this->ActivePassengerCount;
    }
    /**
     * Set ActivePassengerCount value
     * @param int $activePassengerCount
     * @return \StructType\ViewPNR
     */
    public function setActivePassengerCount($activePassengerCount = null)
    {
        // validation for constraint: int
        if (!is_null($activePassengerCount) && !(is_int($activePassengerCount) || ctype_digit($activePassengerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activePassengerCount, true), gettype($activePassengerCount)), __LINE__);
        }
        $this->ActivePassengerCount = $activePassengerCount;
        return $this;
    }
    /**
     * Get BalancedReservation value
     * @return bool|null
     */
    public function getBalancedReservation()
    {
        return $this->BalancedReservation;
    }
    /**
     * Set BalancedReservation value
     * @param bool $balancedReservation
     * @return \StructType\ViewPNR
     */
    public function setBalancedReservation($balancedReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($balancedReservation) && !is_bool($balancedReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($balancedReservation, true), gettype($balancedReservation)), __LINE__);
        }
        $this->BalancedReservation = $balancedReservation;
        return $this;
    }
    /**
     * Get ReservationFulfillmentRequiredByGMT value
     * @return string|null
     */
    public function getReservationFulfillmentRequiredByGMT()
    {
        return $this->ReservationFulfillmentRequiredByGMT;
    }
    /**
     * Set ReservationFulfillmentRequiredByGMT value
     * @param string $reservationFulfillmentRequiredByGMT
     * @return \StructType\ViewPNR
     */
    public function setReservationFulfillmentRequiredByGMT($reservationFulfillmentRequiredByGMT = null)
    {
        // validation for constraint: string
        if (!is_null($reservationFulfillmentRequiredByGMT) && !is_string($reservationFulfillmentRequiredByGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationFulfillmentRequiredByGMT, true), gettype($reservationFulfillmentRequiredByGMT)), __LINE__);
        }
        $this->ReservationFulfillmentRequiredByGMT = $reservationFulfillmentRequiredByGMT;
        return $this;
    }
    /**
     * Get ReservationFulfillmentRequiredByODT value
     * @return string|null
     */
    public function getReservationFulfillmentRequiredByODT()
    {
        return $this->ReservationFulfillmentRequiredByODT;
    }
    /**
     * Set ReservationFulfillmentRequiredByODT value
     * @param string $reservationFulfillmentRequiredByODT
     * @return \StructType\ViewPNR
     */
    public function setReservationFulfillmentRequiredByODT($reservationFulfillmentRequiredByODT = null)
    {
        // validation for constraint: string
        if (!is_null($reservationFulfillmentRequiredByODT) && !is_string($reservationFulfillmentRequiredByODT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationFulfillmentRequiredByODT, true), gettype($reservationFulfillmentRequiredByODT)), __LINE__);
        }
        $this->ReservationFulfillmentRequiredByODT = $reservationFulfillmentRequiredByODT;
        return $this;
    }
    /**
     * Get Airlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirline|null
     */
    public function getAirlines()
    {
        return isset($this->Airlines) ? $this->Airlines : null;
    }
    /**
     * Set Airlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirline $airlines
     * @return \StructType\ViewPNR
     */
    public function setAirlines(\ArrayType\ArrayOfAirline $airlines = null)
    {
        if (is_null($airlines) || (is_array($airlines) && empty($airlines))) {
            unset($this->Airlines);
        } else {
            $this->Airlines = $airlines;
        }
        return $this;
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayment|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayment $payments
     * @return \StructType\ViewPNR
     */
    public function setPayments(\ArrayType\ArrayOfPayment $payments = null)
    {
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHistory|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHistory $history
     * @return \StructType\ViewPNR
     */
    public function setHistory(\ArrayType\ArrayOfHistory $history = null)
    {
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfComment|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfComment $comments
     * @return \StructType\ViewPNR
     */
    public function setComments(\ArrayType\ArrayOfComment $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get GDSHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGDSHistory|null
     */
    public function getGDSHistory()
    {
        return isset($this->GDSHistory) ? $this->GDSHistory : null;
    }
    /**
     * Set GDSHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGDSHistory $gDSHistory
     * @return \StructType\ViewPNR
     */
    public function setGDSHistory(\ArrayType\ArrayOfGDSHistory $gDSHistory = null)
    {
        if (is_null($gDSHistory) || (is_array($gDSHistory) && empty($gDSHistory))) {
            unset($this->GDSHistory);
        } else {
            $this->GDSHistory = $gDSHistory;
        }
        return $this;
    }
    /**
     * Get ReservationContacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReservationContact|null
     */
    public function getReservationContacts()
    {
        return isset($this->ReservationContacts) ? $this->ReservationContacts : null;
    }
    /**
     * Set ReservationContacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReservationContact $reservationContacts
     * @return \StructType\ViewPNR
     */
    public function setReservationContacts(\ArrayType\ArrayOfReservationContact $reservationContacts = null)
    {
        if (is_null($reservationContacts) || (is_array($reservationContacts) && empty($reservationContacts))) {
            unset($this->ReservationContacts);
        } else {
            $this->ReservationContacts = $reservationContacts;
        }
        return $this;
    }
    /**
     * Get ContactInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfos()
    {
        return isset($this->ContactInfos) ? $this->ContactInfos : null;
    }
    /**
     * Set ContactInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @return \StructType\ViewPNR
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        if (is_null($contactInfos) || (is_array($contactInfos) && empty($contactInfos))) {
            unset($this->ContactInfos);
        } else {
            $this->ContactInfos = $contactInfos;
        }
        return $this;
    }
    /**
     * Get Vouchers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVoucher|null
     */
    public function getVouchers()
    {
        return isset($this->Vouchers) ? $this->Vouchers : null;
    }
    /**
     * Set Vouchers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVoucher $vouchers
     * @return \StructType\ViewPNR
     */
    public function setVouchers(\ArrayType\ArrayOfVoucher $vouchers = null)
    {
        if (is_null($vouchers) || (is_array($vouchers) && empty($vouchers))) {
            unset($this->Vouchers);
        } else {
            $this->Vouchers = $vouchers;
        }
        return $this;
    }
    /**
     * Get Cars value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCar|null
     */
    public function getCars()
    {
        return isset($this->Cars) ? $this->Cars : null;
    }
    /**
     * Set Cars value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCar $cars
     * @return \StructType\ViewPNR
     */
    public function setCars(\ArrayType\ArrayOfCar $cars = null)
    {
        if (is_null($cars) || (is_array($cars) && empty($cars))) {
            unset($this->Cars);
        } else {
            $this->Cars = $cars;
        }
        return $this;
    }
    /**
     * Get Hotels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotel|null
     */
    public function getHotels()
    {
        return isset($this->Hotels) ? $this->Hotels : null;
    }
    /**
     * Set Hotels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotel $hotels
     * @return \StructType\ViewPNR
     */
    public function setHotels(\ArrayType\ArrayOfHotel $hotels = null)
    {
        if (is_null($hotels) || (is_array($hotels) && empty($hotels))) {
            unset($this->Hotels);
        } else {
            $this->Hotels = $hotels;
        }
        return $this;
    }
    /**
     * Get Packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPackage|null
     */
    public function getPackages()
    {
        return isset($this->Packages) ? $this->Packages : null;
    }
    /**
     * Set Packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPackage $packages
     * @return \StructType\ViewPNR
     */
    public function setPackages(\ArrayType\ArrayOfPackage $packages = null)
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->Packages);
        } else {
            $this->Packages = $packages;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewPNR
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
    /**
     * Get TotalCommission value
     * @return float|null
     */
    public function getTotalCommission()
    {
        return $this->TotalCommission;
    }
    /**
     * Set TotalCommission value
     * @param float $totalCommission
     * @return \StructType\ViewPNR
     */
    public function setTotalCommission($totalCommission = null)
    {
        // validation for constraint: float
        if (!is_null($totalCommission) && !(is_float($totalCommission) || is_numeric($totalCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCommission, true), gettype($totalCommission)), __LINE__);
        }
        $this->TotalCommission = $totalCommission;
        return $this;
    }
    /**
     * Get IsExternalPriced value
     * @return bool|null
     */
    public function getIsExternalPriced()
    {
        return $this->IsExternalPriced;
    }
    /**
     * Set IsExternalPriced value
     * @param bool $isExternalPriced
     * @return \StructType\ViewPNR
     */
    public function setIsExternalPriced($isExternalPriced = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternalPriced) && !is_bool($isExternalPriced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternalPriced, true), gettype($isExternalPriced)), __LINE__);
        }
        $this->IsExternalPriced = $isExternalPriced;
        return $this;
    }
}
