<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationContact StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationContact
 * @subpackage Structs
 */
class ReservationContact extends Person
{
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VendorID;
    /**
     * The MarketingOptIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MarketingOptIn;
    /**
     * The RedressNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RedressNum;
    /**
     * The KnownTravNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KnownTravNum;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContactInfo
     */
    public $ContactInfos;
    /**
     * Constructor method for ReservationContact
     * @uses ReservationContact::setVendorID()
     * @uses ReservationContact::setMarketingOptIn()
     * @uses ReservationContact::setRedressNum()
     * @uses ReservationContact::setKnownTravNum()
     * @uses ReservationContact::setContactInfos()
     * @param int $vendorID
     * @param bool $marketingOptIn
     * @param string $redressNum
     * @param string $knownTravNum
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     */
    public function __construct($vendorID = null, $marketingOptIn = null, $redressNum = null, $knownTravNum = null, \ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        $this
            ->setVendorID($vendorID)
            ->setMarketingOptIn($marketingOptIn)
            ->setRedressNum($redressNum)
            ->setKnownTravNum($knownTravNum)
            ->setContactInfos($contactInfos);
    }
    /**
     * Get VendorID value
     * @return int|null
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param int $vendorID
     * @return \StructType\ReservationContact
     */
    public function setVendorID($vendorID = null)
    {
        // validation for constraint: int
        if (!is_null($vendorID) && !(is_int($vendorID) || ctype_digit($vendorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vendorID, true), gettype($vendorID)), __LINE__);
        }
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get MarketingOptIn value
     * @return bool|null
     */
    public function getMarketingOptIn()
    {
        return $this->MarketingOptIn;
    }
    /**
     * Set MarketingOptIn value
     * @param bool $marketingOptIn
     * @return \StructType\ReservationContact
     */
    public function setMarketingOptIn($marketingOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketingOptIn) && !is_bool($marketingOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketingOptIn, true), gettype($marketingOptIn)), __LINE__);
        }
        $this->MarketingOptIn = $marketingOptIn;
        return $this;
    }
    /**
     * Get RedressNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedressNum()
    {
        return isset($this->RedressNum) ? $this->RedressNum : null;
    }
    /**
     * Set RedressNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redressNum
     * @return \StructType\ReservationContact
     */
    public function setRedressNum($redressNum = null)
    {
        // validation for constraint: string
        if (!is_null($redressNum) && !is_string($redressNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redressNum, true), gettype($redressNum)), __LINE__);
        }
        if (is_null($redressNum) || (is_array($redressNum) && empty($redressNum))) {
            unset($this->RedressNum);
        } else {
            $this->RedressNum = $redressNum;
        }
        return $this;
    }
    /**
     * Get KnownTravNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnownTravNum()
    {
        return isset($this->KnownTravNum) ? $this->KnownTravNum : null;
    }
    /**
     * Set KnownTravNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knownTravNum
     * @return \StructType\ReservationContact
     */
    public function setKnownTravNum($knownTravNum = null)
    {
        // validation for constraint: string
        if (!is_null($knownTravNum) && !is_string($knownTravNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knownTravNum, true), gettype($knownTravNum)), __LINE__);
        }
        if (is_null($knownTravNum) || (is_array($knownTravNum) && empty($knownTravNum))) {
            unset($this->KnownTravNum);
        } else {
            $this->KnownTravNum = $knownTravNum;
        }
        return $this;
    }
    /**
     * Get ContactInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContactInfo|null
     */
    public function getContactInfos()
    {
        return isset($this->ContactInfos) ? $this->ContactInfos : null;
    }
    /**
     * Set ContactInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContactInfo $contactInfos
     * @return \StructType\ReservationContact
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfo $contactInfos = null)
    {
        if (is_null($contactInfos) || (is_array($contactInfos) && empty($contactInfos))) {
            unset($this->ContactInfos);
        } else {
            $this->ContactInfos = $contactInfos;
        }
        return $this;
    }
}
