<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPointsPayment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddPointsPayment
 * @subpackage Structs
 */
class AddPointsPayment extends AbstractStructBase
{
    /**
     * The PaymentAmount
     * @var float
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentComment;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The Payor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Person
     */
    public $Payor;
    /**
     * The DatePaid
     * @var string
     */
    public $DatePaid;
    /**
     * The MetaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPaymentMetaData
     */
    public $MetaData;
    /**
     * Constructor method for AddPointsPayment
     * @uses AddPointsPayment::setPaymentAmount()
     * @uses AddPointsPayment::setPaymentMethod()
     * @uses AddPointsPayment::setPaymentComment()
     * @uses AddPointsPayment::setAccountNumber()
     * @uses AddPointsPayment::setUserID()
     * @uses AddPointsPayment::setPayor()
     * @uses AddPointsPayment::setDatePaid()
     * @uses AddPointsPayment::setMetaData()
     * @param float $paymentAmount
     * @param string $paymentMethod
     * @param string $paymentComment
     * @param string $accountNumber
     * @param string $userID
     * @param \StructType\Person $payor
     * @param string $datePaid
     * @param \ArrayType\ArrayOfPaymentMetaData $metaData
     */
    public function __construct($paymentAmount = null, $paymentMethod = null, $paymentComment = null, $accountNumber = null, $userID = null, \StructType\Person $payor = null, $datePaid = null, \ArrayType\ArrayOfPaymentMetaData $metaData = null)
    {
        $this
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentComment($paymentComment)
            ->setAccountNumber($accountNumber)
            ->setUserID($userID)
            ->setPayor($payor)
            ->setDatePaid($datePaid)
            ->setMetaData($metaData);
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\AddPointsPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\AddPointsPayment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentComment()
    {
        return isset($this->PaymentComment) ? $this->PaymentComment : null;
    }
    /**
     * Set PaymentComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentComment
     * @return \StructType\AddPointsPayment
     */
    public function setPaymentComment($paymentComment = null)
    {
        // validation for constraint: string
        if (!is_null($paymentComment) && !is_string($paymentComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentComment, true), gettype($paymentComment)), __LINE__);
        }
        if (is_null($paymentComment) || (is_array($paymentComment) && empty($paymentComment))) {
            unset($this->PaymentComment);
        } else {
            $this->PaymentComment = $paymentComment;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\AddPointsPayment
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\AddPointsPayment
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Payor value
     * @return \StructType\Person|null
     */
    public function getPayor()
    {
        return $this->Payor;
    }
    /**
     * Set Payor value
     * @param \StructType\Person $payor
     * @return \StructType\AddPointsPayment
     */
    public function setPayor(\StructType\Person $payor = null)
    {
        $this->Payor = $payor;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \StructType\AddPointsPayment
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get MetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPaymentMetaData|null
     */
    public function getMetaData()
    {
        return isset($this->MetaData) ? $this->MetaData : null;
    }
    /**
     * Set MetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPaymentMetaData $metaData
     * @return \StructType\AddPointsPayment
     */
    public function setMetaData(\ArrayType\ArrayOfPaymentMetaData $metaData = null)
    {
        if (is_null($metaData) || (is_array($metaData) && empty($metaData))) {
            unset($this->MetaData);
        } else {
            $this->MetaData = $metaData;
        }
        return $this;
    }
}
