<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertExternalProcessedPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertExternalProcessedPayment $parameters
     * @return \StructType\InsertExternalProcessedPaymentResponse|bool
     */
    public function InsertExternalProcessedPayment(\StructType\InsertExternalProcessedPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertExternalProcessedPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertExternalProcessedPaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
