<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Format ServiceType
 * @subpackage Services
 */
class Format extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Format3DSecureInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Format3DSecureInformation $parameters
     * @return \StructType\Format3DSecureInformationResponse|bool
     */
    public function Format3DSecureInformation(\StructType\Format3DSecureInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Format3DSecureInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Format3DSecureInformationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
