<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @subpackage Services
 */
class Convert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConvertCurrencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConvertCurrencies $parameters
     * @return \StructType\ConvertCurrenciesResponse|bool
     */
    public function ConvertCurrencies(\StructType\ConvertCurrencies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConvertCurrencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConvertCurrenciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
