<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return StructType
 * @subpackage Structs
 */
class _Return extends AbstractStructBase
{
    /**
     * The ReturnDateTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ReturnDateTime;
    /**
     * The ReturnAddress
     * @var \StructType\AddressType
     */
    public $ReturnAddress;
    /**
     * Constructor method for Return
     * @uses _Return::setReturnDateTime()
     * @uses _Return::setReturnAddress()
     * @param string $returnDateTime
     * @param \StructType\AddressType $returnAddress
     */
    public function __construct($returnDateTime = null, \StructType\AddressType $returnAddress = null)
    {
        $this
            ->setReturnDateTime($returnDateTime)
            ->setReturnAddress($returnAddress);
    }
    /**
     * Get ReturnDateTime value
     * @return string
     */
    public function getReturnDateTime()
    {
        return $this->ReturnDateTime;
    }
    /**
     * Set ReturnDateTime value
     * @param string $returnDateTime
     * @return \StructType\_Return
     */
    public function setReturnDateTime($returnDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($returnDateTime) && !is_string($returnDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDateTime, true), gettype($returnDateTime)), __LINE__);
        }
        $this->ReturnDateTime = $returnDateTime;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \StructType\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \StructType\AddressType $returnAddress
     * @return \StructType\_Return
     */
    public function setReturnAddress(\StructType\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
}
