<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Visa StructType
 * @subpackage Structs
 */
class Visa extends AbstractStructBase
{
    /**
     * The PlaceOfIssue
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PlaceOfIssue;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $IssueDate;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Number;
    /**
     * The ApplicableCountry
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ApplicableCountry;
    /**
     * Constructor method for Visa
     * @uses Visa::setPlaceOfIssue()
     * @uses Visa::setIssueDate()
     * @uses Visa::setNumber()
     * @uses Visa::setApplicableCountry()
     * @param string $placeOfIssue
     * @param string $issueDate
     * @param string $number
     * @param string $applicableCountry
     */
    public function __construct($placeOfIssue = null, $issueDate = null, $number = null, $applicableCountry = null)
    {
        $this
            ->setPlaceOfIssue($placeOfIssue)
            ->setIssueDate($issueDate)
            ->setNumber($number)
            ->setApplicableCountry($applicableCountry);
    }
    /**
     * Get PlaceOfIssue value
     * @return string
     */
    public function getPlaceOfIssue()
    {
        return $this->PlaceOfIssue;
    }
    /**
     * Set PlaceOfIssue value
     * @param string $placeOfIssue
     * @return \StructType\Visa
     */
    public function setPlaceOfIssue($placeOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfIssue) && !is_string($placeOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeOfIssue, true), gettype($placeOfIssue)), __LINE__);
        }
        $this->PlaceOfIssue = $placeOfIssue;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\Visa
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get Number value
     * @return string
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Visa
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ApplicableCountry value
     * @return string
     */
    public function getApplicableCountry()
    {
        return $this->ApplicableCountry;
    }
    /**
     * Set ApplicableCountry value
     * @param string $applicableCountry
     * @return \StructType\Visa
     */
    public function setApplicableCountry($applicableCountry = null)
    {
        // validation for constraint: string
        if (!is_null($applicableCountry) && !is_string($applicableCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableCountry, true), gettype($applicableCountry)), __LINE__);
        }
        $this->ApplicableCountry = $applicableCountry;
        return $this;
    }
}
