<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VirtualCard StructType
 * @subpackage Structs
 */
class VirtualCard extends AbstractStructBase
{
    /**
     * The VirtualCardTransID
     * Meta information extracted from the WSDL
     * - documentation: SabreTransactionID as returned in GetCard response
     * - use: required
     * @var string
     */
    public $VirtualCardTransID;
    /**
     * Constructor method for VirtualCard
     * @uses VirtualCard::setVirtualCardTransID()
     * @param string $virtualCardTransID
     */
    public function __construct($virtualCardTransID = null)
    {
        $this
            ->setVirtualCardTransID($virtualCardTransID);
    }
    /**
     * Get VirtualCardTransID value
     * @return string
     */
    public function getVirtualCardTransID()
    {
        return $this->VirtualCardTransID;
    }
    /**
     * Set VirtualCardTransID value
     * @param string $virtualCardTransID
     * @return \StructType\VirtualCard
     */
    public function setVirtualCardTransID($virtualCardTransID = null)
    {
        // validation for constraint: string
        if (!is_null($virtualCardTransID) && !is_string($virtualCardTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualCardTransID, true), gettype($virtualCardTransID)), __LINE__);
        }
        $this->VirtualCardTransID = $virtualCardTransID;
        return $this;
    }
}
