<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket StructType
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $TicketNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Class
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Class;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Cost;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setDescription()
     * @uses Ticket::setClass()
     * @uses Ticket::setCost()
     * @param float $ticketNumber
     * @param string $description
     * @param string $class
     * @param float $cost
     */
    public function __construct($ticketNumber = null, $description = null, $class = null, $cost = null)
    {
        $this
            ->setTicketNumber($ticketNumber)
            ->setDescription($description)
            ->setClass($class)
            ->setCost($cost);
    }
    /**
     * Get TicketNumber value
     * @return float|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param float $ticketNumber
     * @return \StructType\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: float
        if (!is_null($ticketNumber) && !(is_float($ticketNumber) || is_numeric($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($ticketNumber) && mb_strlen(mb_substr($ticketNumber, false !== mb_strpos($ticketNumber, '.') ? mb_strpos($ticketNumber, '.') + 1 : mb_strlen($ticketNumber))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($ticketNumber, true), mb_strlen(mb_substr($ticketNumber, mb_strpos($ticketNumber, '.') + 1))), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Ticket
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\Ticket
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \StructType\Ticket
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cost) && mb_strlen(mb_substr($cost, false !== mb_strpos($cost, '.') ? mb_strpos($cost, '.') + 1 : mb_strlen($cost))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cost, true), mb_strlen(mb_substr($cost, mb_strpos($cost, '.') + 1))), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
}
