<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for T3DS_ResultType StructType
 * @subpackage Structs
 */
class T3DS_ResultType extends AbstractStructBase
{
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The CAVV
     * Meta information extracted from the WSDL
     * - documentation: A string token provided by Issuing bank as a response from 3DSecure authentication request for Verified By Visa or MasterCard Secure Code.
     * - use: optional
     * @var string
     */
    public $CAVV;
    /**
     * The CAVV_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: Cardholder Authentication Verification Value Result Code
     * - use: optional
     * @var string
     */
    public $CAVV_ResultCode;
    /**
     * The T3DS_Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $T3DS_Remarks;
    /**
     * The PA_Request
     * Meta information extracted from the WSDL
     * - documentation: Payer Authentication Request
     * - use: optional
     * @var string
     */
    public $PA_Request;
    /**
     * The PA_ResponseCode
     * Meta information extracted from the WSDL
     * - documentation: Payer Authentication Response Code
     * - use: optional
     * @var string
     */
    public $PA_ResponseCode;
    /**
     * The VE_ResponseCode
     * Meta information extracted from the WSDL
     * - documentation: Verify Enrollment Response Code
     * - use: optional
     * @var string
     */
    public $VE_ResponseCode;
    /**
     * The IssuerURL
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IssuerURL;
    /**
     * The MD
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MD;
    /**
     * The ECI
     * Meta information extracted from the WSDL
     * - documentation: Electronic Commerce Indicator
     * - use: optional
     * @var string
     */
    public $ECI;
    /**
     * The ECI_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: Electronic Commerce Indicator Result Code
     * - use: optional
     * @var string
     */
    public $ECI_ResultCode;
    /**
     * The UCAF_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: Mastercard Universal Cardholder Authentication Field Result Code
     * - use: optional
     * @var string
     */
    public $UCAF_ResultCode;
    /**
     * The XID
     * Meta information extracted from the WSDL
     * - documentation: American Express SafeKey Transaction ID (Electronic Commerce Transaction Identifier)
     * - use: optional
     * @var string
     */
    public $XID;
    /**
     * The LiabilityShiftInd
     * Meta information extracted from the WSDL
     * - documentation: Set to true if 3D-Secure resulted in merchant liability shift
     * - use: optional
     * @var bool
     */
    public $LiabilityShiftInd;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: 3DS Version
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * The DirectoryServerTrxID
     * Meta information extracted from the WSDL
     * - documentation: Directory Server Transaction ID. A unique transaction identifier assigned by the scheme Directory Server to identify the 3DS transaction.
     * - use: optional
     * @var string
     */
    public $DirectoryServerTrxID;
    /**
     * The ThreeDSServerTransID
     * Meta information extracted from the WSDL
     * - documentation: A unique transaction identifier assigned by 3DS Server to identify the authentication.
     * - use: optional
     * @var string
     */
    public $ThreeDSServerTransID;
    /**
     * Constructor method for T3DS_ResultType
     * @uses T3DS_ResultType::setAdditionalDetail()
     * @uses T3DS_ResultType::setCAVV()
     * @uses T3DS_ResultType::setCAVV_ResultCode()
     * @uses T3DS_ResultType::setT3DS_Remarks()
     * @uses T3DS_ResultType::setPA_Request()
     * @uses T3DS_ResultType::setPA_ResponseCode()
     * @uses T3DS_ResultType::setVE_ResponseCode()
     * @uses T3DS_ResultType::setIssuerURL()
     * @uses T3DS_ResultType::setMD()
     * @uses T3DS_ResultType::setECI()
     * @uses T3DS_ResultType::setECI_ResultCode()
     * @uses T3DS_ResultType::setUCAF_ResultCode()
     * @uses T3DS_ResultType::setXID()
     * @uses T3DS_ResultType::setLiabilityShiftInd()
     * @uses T3DS_ResultType::setVersion()
     * @uses T3DS_ResultType::setDirectoryServerTrxID()
     * @uses T3DS_ResultType::setThreeDSServerTransID()
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @param string $cAVV
     * @param string $cAVV_ResultCode
     * @param string $t3DS_Remarks
     * @param string $pA_Request
     * @param string $pA_ResponseCode
     * @param string $vE_ResponseCode
     * @param string $issuerURL
     * @param string $mD
     * @param string $eCI
     * @param string $eCI_ResultCode
     * @param string $uCAF_ResultCode
     * @param string $xID
     * @param bool $liabilityShiftInd
     * @param string $version
     * @param string $directoryServerTrxID
     * @param string $threeDSServerTransID
     */
    public function __construct(\StructType\AdditionalDetailType $additionalDetail = null, $cAVV = null, $cAVV_ResultCode = null, $t3DS_Remarks = null, $pA_Request = null, $pA_ResponseCode = null, $vE_ResponseCode = null, $issuerURL = null, $mD = null, $eCI = null, $eCI_ResultCode = null, $uCAF_ResultCode = null, $xID = null, $liabilityShiftInd = null, $version = null, $directoryServerTrxID = null, $threeDSServerTransID = null)
    {
        $this
            ->setAdditionalDetail($additionalDetail)
            ->setCAVV($cAVV)
            ->setCAVV_ResultCode($cAVV_ResultCode)
            ->setT3DS_Remarks($t3DS_Remarks)
            ->setPA_Request($pA_Request)
            ->setPA_ResponseCode($pA_ResponseCode)
            ->setVE_ResponseCode($vE_ResponseCode)
            ->setIssuerURL($issuerURL)
            ->setMD($mD)
            ->setECI($eCI)
            ->setECI_ResultCode($eCI_ResultCode)
            ->setUCAF_ResultCode($uCAF_ResultCode)
            ->setXID($xID)
            ->setLiabilityShiftInd($liabilityShiftInd)
            ->setVersion($version)
            ->setDirectoryServerTrxID($directoryServerTrxID)
            ->setThreeDSServerTransID($threeDSServerTransID);
    }
    /**
     * Get AdditionalDetail value
     * @return \StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \StructType\AdditionalDetailType $additionalDetail
     * @return \StructType\T3DS_ResultType
     */
    public function setAdditionalDetail(\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get CAVV value
     * @return string|null
     */
    public function getCAVV()
    {
        return $this->CAVV;
    }
    /**
     * Set CAVV value
     * @param string $cAVV
     * @return \StructType\T3DS_ResultType
     */
    public function setCAVV($cAVV = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV) && !is_string($cAVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV, true), gettype($cAVV)), __LINE__);
        }
        $this->CAVV = $cAVV;
        return $this;
    }
    /**
     * Get CAVV_ResultCode value
     * @return string|null
     */
    public function getCAVV_ResultCode()
    {
        return $this->CAVV_ResultCode;
    }
    /**
     * Set CAVV_ResultCode value
     * @param string $cAVV_ResultCode
     * @return \StructType\T3DS_ResultType
     */
    public function setCAVV_ResultCode($cAVV_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_ResultCode) && !is_string($cAVV_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_ResultCode, true), gettype($cAVV_ResultCode)), __LINE__);
        }
        $this->CAVV_ResultCode = $cAVV_ResultCode;
        return $this;
    }
    /**
     * Get T3DS_Remarks value
     * @return string|null
     */
    public function getT3DS_Remarks()
    {
        return $this->T3DS_Remarks;
    }
    /**
     * Set T3DS_Remarks value
     * @param string $t3DS_Remarks
     * @return \StructType\T3DS_ResultType
     */
    public function setT3DS_Remarks($t3DS_Remarks = null)
    {
        // validation for constraint: string
        if (!is_null($t3DS_Remarks) && !is_string($t3DS_Remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($t3DS_Remarks, true), gettype($t3DS_Remarks)), __LINE__);
        }
        $this->T3DS_Remarks = $t3DS_Remarks;
        return $this;
    }
    /**
     * Get PA_Request value
     * @return string|null
     */
    public function getPA_Request()
    {
        return $this->PA_Request;
    }
    /**
     * Set PA_Request value
     * @param string $pA_Request
     * @return \StructType\T3DS_ResultType
     */
    public function setPA_Request($pA_Request = null)
    {
        // validation for constraint: string
        if (!is_null($pA_Request) && !is_string($pA_Request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pA_Request, true), gettype($pA_Request)), __LINE__);
        }
        $this->PA_Request = $pA_Request;
        return $this;
    }
    /**
     * Get PA_ResponseCode value
     * @return string|null
     */
    public function getPA_ResponseCode()
    {
        return $this->PA_ResponseCode;
    }
    /**
     * Set PA_ResponseCode value
     * @param string $pA_ResponseCode
     * @return \StructType\T3DS_ResultType
     */
    public function setPA_ResponseCode($pA_ResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($pA_ResponseCode) && !is_string($pA_ResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pA_ResponseCode, true), gettype($pA_ResponseCode)), __LINE__);
        }
        $this->PA_ResponseCode = $pA_ResponseCode;
        return $this;
    }
    /**
     * Get VE_ResponseCode value
     * @return string|null
     */
    public function getVE_ResponseCode()
    {
        return $this->VE_ResponseCode;
    }
    /**
     * Set VE_ResponseCode value
     * @param string $vE_ResponseCode
     * @return \StructType\T3DS_ResultType
     */
    public function setVE_ResponseCode($vE_ResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($vE_ResponseCode) && !is_string($vE_ResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vE_ResponseCode, true), gettype($vE_ResponseCode)), __LINE__);
        }
        $this->VE_ResponseCode = $vE_ResponseCode;
        return $this;
    }
    /**
     * Get IssuerURL value
     * @return string|null
     */
    public function getIssuerURL()
    {
        return $this->IssuerURL;
    }
    /**
     * Set IssuerURL value
     * @param string $issuerURL
     * @return \StructType\T3DS_ResultType
     */
    public function setIssuerURL($issuerURL = null)
    {
        // validation for constraint: string
        if (!is_null($issuerURL) && !is_string($issuerURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerURL, true), gettype($issuerURL)), __LINE__);
        }
        $this->IssuerURL = $issuerURL;
        return $this;
    }
    /**
     * Get MD value
     * @return string|null
     */
    public function getMD()
    {
        return $this->MD;
    }
    /**
     * Set MD value
     * @param string $mD
     * @return \StructType\T3DS_ResultType
     */
    public function setMD($mD = null)
    {
        // validation for constraint: string
        if (!is_null($mD) && !is_string($mD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mD, true), gettype($mD)), __LINE__);
        }
        $this->MD = $mD;
        return $this;
    }
    /**
     * Get ECI value
     * @return string|null
     */
    public function getECI()
    {
        return $this->ECI;
    }
    /**
     * Set ECI value
     * @param string $eCI
     * @return \StructType\T3DS_ResultType
     */
    public function setECI($eCI = null)
    {
        // validation for constraint: string
        if (!is_null($eCI) && !is_string($eCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCI, true), gettype($eCI)), __LINE__);
        }
        $this->ECI = $eCI;
        return $this;
    }
    /**
     * Get ECI_ResultCode value
     * @return string|null
     */
    public function getECI_ResultCode()
    {
        return $this->ECI_ResultCode;
    }
    /**
     * Set ECI_ResultCode value
     * @param string $eCI_ResultCode
     * @return \StructType\T3DS_ResultType
     */
    public function setECI_ResultCode($eCI_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($eCI_ResultCode) && !is_string($eCI_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCI_ResultCode, true), gettype($eCI_ResultCode)), __LINE__);
        }
        $this->ECI_ResultCode = $eCI_ResultCode;
        return $this;
    }
    /**
     * Get UCAF_ResultCode value
     * @return string|null
     */
    public function getUCAF_ResultCode()
    {
        return $this->UCAF_ResultCode;
    }
    /**
     * Set UCAF_ResultCode value
     * @param string $uCAF_ResultCode
     * @return \StructType\T3DS_ResultType
     */
    public function setUCAF_ResultCode($uCAF_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($uCAF_ResultCode) && !is_string($uCAF_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uCAF_ResultCode, true), gettype($uCAF_ResultCode)), __LINE__);
        }
        $this->UCAF_ResultCode = $uCAF_ResultCode;
        return $this;
    }
    /**
     * Get XID value
     * @return string|null
     */
    public function getXID()
    {
        return $this->XID;
    }
    /**
     * Set XID value
     * @param string $xID
     * @return \StructType\T3DS_ResultType
     */
    public function setXID($xID = null)
    {
        // validation for constraint: string
        if (!is_null($xID) && !is_string($xID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xID, true), gettype($xID)), __LINE__);
        }
        $this->XID = $xID;
        return $this;
    }
    /**
     * Get LiabilityShiftInd value
     * @return bool|null
     */
    public function getLiabilityShiftInd()
    {
        return $this->LiabilityShiftInd;
    }
    /**
     * Set LiabilityShiftInd value
     * @param bool $liabilityShiftInd
     * @return \StructType\T3DS_ResultType
     */
    public function setLiabilityShiftInd($liabilityShiftInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($liabilityShiftInd) && !is_bool($liabilityShiftInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($liabilityShiftInd, true), gettype($liabilityShiftInd)), __LINE__);
        }
        $this->LiabilityShiftInd = $liabilityShiftInd;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\T3DS_ResultType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get DirectoryServerTrxID value
     * @return string|null
     */
    public function getDirectoryServerTrxID()
    {
        return $this->DirectoryServerTrxID;
    }
    /**
     * Set DirectoryServerTrxID value
     * @param string $directoryServerTrxID
     * @return \StructType\T3DS_ResultType
     */
    public function setDirectoryServerTrxID($directoryServerTrxID = null)
    {
        // validation for constraint: string
        if (!is_null($directoryServerTrxID) && !is_string($directoryServerTrxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryServerTrxID, true), gettype($directoryServerTrxID)), __LINE__);
        }
        $this->DirectoryServerTrxID = $directoryServerTrxID;
        return $this;
    }
    /**
     * Get ThreeDSServerTransID value
     * @return string|null
     */
    public function getThreeDSServerTransID()
    {
        return $this->ThreeDSServerTransID;
    }
    /**
     * Set ThreeDSServerTransID value
     * @param string $threeDSServerTransID
     * @return \StructType\T3DS_ResultType
     */
    public function setThreeDSServerTransID($threeDSServerTransID = null)
    {
        // validation for constraint: string
        if (!is_null($threeDSServerTransID) && !is_string($threeDSServerTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threeDSServerTransID, true), gettype($threeDSServerTransID)), __LINE__);
        }
        $this->ThreeDSServerTransID = $threeDSServerTransID;
        return $this;
    }
}
