<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonID_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Document detail
 * @subpackage Structs
 */
class PersonID_Type extends AbstractStructBase
{
    /**
     * The Passport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Passport
     */
    public $Passport;
    /**
     * The Visa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Visa
     */
    public $Visa;
    /**
     * The Other
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Other[]
     */
    public $Other;
    /**
     * Constructor method for PersonID_Type
     * @uses PersonID_Type::setPassport()
     * @uses PersonID_Type::setVisa()
     * @uses PersonID_Type::setOther()
     * @param \StructType\Passport $passport
     * @param \StructType\Visa $visa
     * @param \StructType\Other[] $other
     */
    public function __construct(\StructType\Passport $passport = null, \StructType\Visa $visa = null, array $other = array())
    {
        $this
            ->setPassport($passport)
            ->setVisa($visa)
            ->setOther($other);
    }
    /**
     * Get Passport value
     * @return \StructType\Passport|null
     */
    public function getPassport()
    {
        return $this->Passport;
    }
    /**
     * Set Passport value
     * @param \StructType\Passport $passport
     * @return \StructType\PersonID_Type
     */
    public function setPassport(\StructType\Passport $passport = null)
    {
        $this->Passport = $passport;
        return $this;
    }
    /**
     * Get Visa value
     * @return \StructType\Visa|null
     */
    public function getVisa()
    {
        return $this->Visa;
    }
    /**
     * Set Visa value
     * @param \StructType\Visa $visa
     * @return \StructType\PersonID_Type
     */
    public function setVisa(\StructType\Visa $visa = null)
    {
        $this->Visa = $visa;
        return $this;
    }
    /**
     * Get Other value
     * @return \StructType\Other[]|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * This method is responsible for validating the values passed to the setOther method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOther method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherForArrayConstraintsFromSetOther(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personID_TypeOtherItem) {
            // validation for constraint: itemType
            if (!$personID_TypeOtherItem instanceof \StructType\Other) {
                $invalidValues[] = is_object($personID_TypeOtherItem) ? get_class($personID_TypeOtherItem) : sprintf('%s(%s)', gettype($personID_TypeOtherItem), var_export($personID_TypeOtherItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Other property can only contain items of type \StructType\Other, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Other value
     * @throws \InvalidArgumentException
     * @param \StructType\Other[] $other
     * @return \StructType\PersonID_Type
     */
    public function setOther(array $other = array())
    {
        // validation for constraint: array
        if ('' !== ($otherArrayErrorMessage = self::validateOtherForArrayConstraintsFromSetOther($other))) {
            throw new \InvalidArgumentException($otherArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($other) && count($other) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($other)), __LINE__);
        }
        $this->Other = $other;
        return $this;
    }
    /**
     * Add item to Other value
     * @throws \InvalidArgumentException
     * @param \StructType\Other $item
     * @return \StructType\PersonID_Type
     */
    public function addToOther(\StructType\Other $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Other) {
            throw new \InvalidArgumentException(sprintf('The Other property can only contain items of type \StructType\Other, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Other) && count($this->Other) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Other)), __LINE__);
        }
        $this->Other[] = $item;
        return $this;
    }
}
