<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfoType StructType
 * @subpackage Structs
 */
class PaymentInfoType extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentSite
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentSite;
    /**
     * The PurchaseSite
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PurchaseSite;
    /**
     * The PaymentTerm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentTerm;
    /**
     * The PayDateLookupCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PayDateLookupCode;
    /**
     * The TermDateBasis
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TermDateBasis;
    /**
     * Constructor method for PaymentInfoType
     * @uses PaymentInfoType::setPaymentMethod()
     * @uses PaymentInfoType::setPaymentSite()
     * @uses PaymentInfoType::setPurchaseSite()
     * @uses PaymentInfoType::setPaymentTerm()
     * @uses PaymentInfoType::setPayDateLookupCode()
     * @uses PaymentInfoType::setTermDateBasis()
     * @param string $paymentMethod
     * @param string $paymentSite
     * @param string $purchaseSite
     * @param string $paymentTerm
     * @param string $payDateLookupCode
     * @param string $termDateBasis
     */
    public function __construct($paymentMethod = null, $paymentSite = null, $purchaseSite = null, $paymentTerm = null, $payDateLookupCode = null, $termDateBasis = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setPaymentSite($paymentSite)
            ->setPurchaseSite($purchaseSite)
            ->setPaymentTerm($paymentTerm)
            ->setPayDateLookupCode($payDateLookupCode)
            ->setTermDateBasis($termDateBasis);
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentSite value
     * @return string|null
     */
    public function getPaymentSite()
    {
        return $this->PaymentSite;
    }
    /**
     * Set PaymentSite value
     * @param string $paymentSite
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentSite($paymentSite = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSite) && !is_string($paymentSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSite, true), gettype($paymentSite)), __LINE__);
        }
        $this->PaymentSite = $paymentSite;
        return $this;
    }
    /**
     * Get PurchaseSite value
     * @return string|null
     */
    public function getPurchaseSite()
    {
        return $this->PurchaseSite;
    }
    /**
     * Set PurchaseSite value
     * @param string $purchaseSite
     * @return \StructType\PaymentInfoType
     */
    public function setPurchaseSite($purchaseSite = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseSite) && !is_string($purchaseSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseSite, true), gettype($purchaseSite)), __LINE__);
        }
        $this->PurchaseSite = $purchaseSite;
        return $this;
    }
    /**
     * Get PaymentTerm value
     * @return string|null
     */
    public function getPaymentTerm()
    {
        return $this->PaymentTerm;
    }
    /**
     * Set PaymentTerm value
     * @param string $paymentTerm
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentTerm($paymentTerm = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerm) && !is_string($paymentTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTerm, true), gettype($paymentTerm)), __LINE__);
        }
        $this->PaymentTerm = $paymentTerm;
        return $this;
    }
    /**
     * Get PayDateLookupCode value
     * @return string|null
     */
    public function getPayDateLookupCode()
    {
        return $this->PayDateLookupCode;
    }
    /**
     * Set PayDateLookupCode value
     * @param string $payDateLookupCode
     * @return \StructType\PaymentInfoType
     */
    public function setPayDateLookupCode($payDateLookupCode = null)
    {
        // validation for constraint: string
        if (!is_null($payDateLookupCode) && !is_string($payDateLookupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDateLookupCode, true), gettype($payDateLookupCode)), __LINE__);
        }
        $this->PayDateLookupCode = $payDateLookupCode;
        return $this;
    }
    /**
     * Get TermDateBasis value
     * @return string|null
     */
    public function getTermDateBasis()
    {
        return $this->TermDateBasis;
    }
    /**
     * Set TermDateBasis value
     * @param string $termDateBasis
     * @return \StructType\PaymentInfoType
     */
    public function setTermDateBasis($termDateBasis = null)
    {
        // validation for constraint: string
        if (!is_null($termDateBasis) && !is_string($termDateBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termDateBasis, true), gettype($termDateBasis)), __LINE__);
        }
        $this->TermDateBasis = $termDateBasis;
        return $this;
    }
}
