<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Point of Sales information.
 * @subpackage Structs
 */
class POS_Type extends AbstractStructBase
{
    /**
     * The BrowserDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BrowserDetail
     */
    public $BrowserDetail;
    /**
     * The Javascript
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Javascript;
    /**
     * The POS_Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $POS_Address;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: POS Contact Information
     * - minOccurs: 0
     * @var \StructType\ContactInfoType
     */
    public $ContactInfo;
    /**
     * The CityCode
     * Meta information extracted from the WSDL
     * - documentation: 3-alpha city code
     * - use: optional
     * @var string
     */
    public $CityCode;
    /**
     * The OfficeCode
     * Meta information extracted from the WSDL
     * - documentation: 2-alpha office code
     * - use: optional
     * @var string
     */
    public $OfficeCode;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Agency Name assigned to an office/agency/pseudo city code
     * - use: optional
     * @var string
     */
    public $AgencyName;
    /**
     * The AgentSine
     * Meta information extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity.
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The AgentDutyCode
     * Meta information extracted from the WSDL
     * - documentation: An authority code assigned to a requestor.
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The LNIATA
     * Meta information extracted from the WSDL
     * - documentation: Agent set LNIATA
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * The StationNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StationNumber;
    /**
     * The ISOCountry
     * Meta information extracted from the WSDL
     * - documentation: The country code of the requesting party. | 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The SettlementPlan
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SettlementPlan;
    /**
     * The AgencyOwner
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AgencyOwner;
    /**
     * The IP_Address
     * Meta information extracted from the WSDL
     * - documentation: For web transaction only. Must be in the range of 0.0.0.1 - 999.999.999.999
     * - use: optional
     * @var string
     */
    public $IP_Address;
    /**
     * The ChannelID
     * Meta information extracted from the WSDL
     * - documentation: e.g. WEB, RES, ATO, CTO
     * - use: optional
     * @var string
     */
    public $ChannelID;
    /**
     * The LocalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Local date/time of the POS in ISO 8601 format
     * - use: optional
     * @var string
     */
    public $LocalDateTime;
    /**
     * The SourceID
     * Meta information extracted from the WSDL
     * - documentation: Client application ID e.g. SSW, SE, INTERACT
     * - use: optional
     * @var string
     */
    public $SourceID;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Language Code e.g. en-US, en-GB
     * - use: optional
     * @var string
     */
    public $LanguageCode;
    /**
     * The NdcInd
     * Meta information extracted from the WSDL
     * - documentation: Indicate request via New Distribution Capability (NDC) program
     * - use: optional
     * @var bool
     */
    public $NdcInd;
    /**
     * Constructor method for POS_Type
     * @uses POS_Type::setBrowserDetail()
     * @uses POS_Type::setJavascript()
     * @uses POS_Type::setPOS_Address()
     * @uses POS_Type::setContactInfo()
     * @uses POS_Type::setCityCode()
     * @uses POS_Type::setOfficeCode()
     * @uses POS_Type::setPseudoCityCode()
     * @uses POS_Type::setAgencyName()
     * @uses POS_Type::setAgentSine()
     * @uses POS_Type::setAgentDutyCode()
     * @uses POS_Type::setLNIATA()
     * @uses POS_Type::setStationNumber()
     * @uses POS_Type::setISOCountry()
     * @uses POS_Type::setSettlementPlan()
     * @uses POS_Type::setAgencyOwner()
     * @uses POS_Type::setIP_Address()
     * @uses POS_Type::setChannelID()
     * @uses POS_Type::setLocalDateTime()
     * @uses POS_Type::setSourceID()
     * @uses POS_Type::setLanguageCode()
     * @uses POS_Type::setNdcInd()
     * @param \StructType\BrowserDetail $browserDetail
     * @param string $javascript
     * @param \StructType\AddressType $pOS_Address
     * @param \StructType\ContactInfoType $contactInfo
     * @param string $cityCode
     * @param string $officeCode
     * @param string $pseudoCityCode
     * @param string $agencyName
     * @param string $agentSine
     * @param string $agentDutyCode
     * @param string $lNIATA
     * @param string $stationNumber
     * @param string $iSOCountry
     * @param string $settlementPlan
     * @param string $agencyOwner
     * @param string $iP_Address
     * @param string $channelID
     * @param string $localDateTime
     * @param string $sourceID
     * @param string $languageCode
     * @param bool $ndcInd
     */
    public function __construct(\StructType\BrowserDetail $browserDetail = null, $javascript = null, \StructType\AddressType $pOS_Address = null, \StructType\ContactInfoType $contactInfo = null, $cityCode = null, $officeCode = null, $pseudoCityCode = null, $agencyName = null, $agentSine = null, $agentDutyCode = null, $lNIATA = null, $stationNumber = null, $iSOCountry = null, $settlementPlan = null, $agencyOwner = null, $iP_Address = null, $channelID = null, $localDateTime = null, $sourceID = null, $languageCode = null, $ndcInd = null)
    {
        $this
            ->setBrowserDetail($browserDetail)
            ->setJavascript($javascript)
            ->setPOS_Address($pOS_Address)
            ->setContactInfo($contactInfo)
            ->setCityCode($cityCode)
            ->setOfficeCode($officeCode)
            ->setPseudoCityCode($pseudoCityCode)
            ->setAgencyName($agencyName)
            ->setAgentSine($agentSine)
            ->setAgentDutyCode($agentDutyCode)
            ->setLNIATA($lNIATA)
            ->setStationNumber($stationNumber)
            ->setISOCountry($iSOCountry)
            ->setSettlementPlan($settlementPlan)
            ->setAgencyOwner($agencyOwner)
            ->setIP_Address($iP_Address)
            ->setChannelID($channelID)
            ->setLocalDateTime($localDateTime)
            ->setSourceID($sourceID)
            ->setLanguageCode($languageCode)
            ->setNdcInd($ndcInd);
    }
    /**
     * Get BrowserDetail value
     * @return \StructType\BrowserDetail|null
     */
    public function getBrowserDetail()
    {
        return $this->BrowserDetail;
    }
    /**
     * Set BrowserDetail value
     * @param \StructType\BrowserDetail $browserDetail
     * @return \StructType\POS_Type
     */
    public function setBrowserDetail(\StructType\BrowserDetail $browserDetail = null)
    {
        $this->BrowserDetail = $browserDetail;
        return $this;
    }
    /**
     * Get Javascript value
     * @return string|null
     */
    public function getJavascript()
    {
        return $this->Javascript;
    }
    /**
     * Set Javascript value
     * @param string $javascript
     * @return \StructType\POS_Type
     */
    public function setJavascript($javascript = null)
    {
        // validation for constraint: string
        if (!is_null($javascript) && !is_string($javascript)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($javascript, true), gettype($javascript)), __LINE__);
        }
        $this->Javascript = $javascript;
        return $this;
    }
    /**
     * Get POS_Address value
     * @return \StructType\AddressType|null
     */
    public function getPOS_Address()
    {
        return $this->POS_Address;
    }
    /**
     * Set POS_Address value
     * @param \StructType\AddressType $pOS_Address
     * @return \StructType\POS_Type
     */
    public function setPOS_Address(\StructType\AddressType $pOS_Address = null)
    {
        $this->POS_Address = $pOS_Address;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfoType $contactInfo
     * @return \StructType\POS_Type
     */
    public function setContactInfo(\StructType\ContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \StructType\POS_Type
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityCode, true), gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get OfficeCode value
     * @return string|null
     */
    public function getOfficeCode()
    {
        return $this->OfficeCode;
    }
    /**
     * Set OfficeCode value
     * @param string $officeCode
     * @return \StructType\POS_Type
     */
    public function setOfficeCode($officeCode = null)
    {
        // validation for constraint: string
        if (!is_null($officeCode) && !is_string($officeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officeCode, true), gettype($officeCode)), __LINE__);
        }
        $this->OfficeCode = $officeCode;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\POS_Type
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\POS_Type
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \StructType\POS_Type
     */
    public function setAgentSine($agentSine = null)
    {
        // validation for constraint: string
        if (!is_null($agentSine) && !is_string($agentSine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSine, true), gettype($agentSine)), __LINE__);
        }
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \StructType\POS_Type
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyCode) && !is_string($agentDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDutyCode, true), gettype($agentDutyCode)), __LINE__);
        }
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \StructType\POS_Type
     */
    public function setLNIATA($lNIATA = null)
    {
        // validation for constraint: string
        if (!is_null($lNIATA) && !is_string($lNIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lNIATA, true), gettype($lNIATA)), __LINE__);
        }
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Get StationNumber value
     * @return string|null
     */
    public function getStationNumber()
    {
        return $this->StationNumber;
    }
    /**
     * Set StationNumber value
     * @param string $stationNumber
     * @return \StructType\POS_Type
     */
    public function setStationNumber($stationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($stationNumber) && !is_string($stationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationNumber, true), gettype($stationNumber)), __LINE__);
        }
        $this->StationNumber = $stationNumber;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \StructType\POS_Type
     */
    public function setISOCountry($iSOCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountry) && !is_string($iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCountry, true), gettype($iSOCountry)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($iSOCountry) && !preg_match('/[a-zA-Z]{2}/', $iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($iSOCountry, true)), __LINE__);
        }
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get SettlementPlan value
     * @return string|null
     */
    public function getSettlementPlan()
    {
        return $this->SettlementPlan;
    }
    /**
     * Set SettlementPlan value
     * @param string $settlementPlan
     * @return \StructType\POS_Type
     */
    public function setSettlementPlan($settlementPlan = null)
    {
        // validation for constraint: string
        if (!is_null($settlementPlan) && !is_string($settlementPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementPlan, true), gettype($settlementPlan)), __LINE__);
        }
        $this->SettlementPlan = $settlementPlan;
        return $this;
    }
    /**
     * Get AgencyOwner value
     * @return string|null
     */
    public function getAgencyOwner()
    {
        return $this->AgencyOwner;
    }
    /**
     * Set AgencyOwner value
     * @param string $agencyOwner
     * @return \StructType\POS_Type
     */
    public function setAgencyOwner($agencyOwner = null)
    {
        // validation for constraint: string
        if (!is_null($agencyOwner) && !is_string($agencyOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyOwner, true), gettype($agencyOwner)), __LINE__);
        }
        $this->AgencyOwner = $agencyOwner;
        return $this;
    }
    /**
     * Get IP_Address value
     * @return string|null
     */
    public function getIP_Address()
    {
        return $this->IP_Address;
    }
    /**
     * Set IP_Address value
     * @param string $iP_Address
     * @return \StructType\POS_Type
     */
    public function setIP_Address($iP_Address = null)
    {
        // validation for constraint: string
        if (!is_null($iP_Address) && !is_string($iP_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iP_Address, true), gettype($iP_Address)), __LINE__);
        }
        $this->IP_Address = $iP_Address;
        return $this;
    }
    /**
     * Get ChannelID value
     * @return string|null
     */
    public function getChannelID()
    {
        return $this->ChannelID;
    }
    /**
     * Set ChannelID value
     * @param string $channelID
     * @return \StructType\POS_Type
     */
    public function setChannelID($channelID = null)
    {
        // validation for constraint: string
        if (!is_null($channelID) && !is_string($channelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelID, true), gettype($channelID)), __LINE__);
        }
        $this->ChannelID = $channelID;
        return $this;
    }
    /**
     * Get LocalDateTime value
     * @return string|null
     */
    public function getLocalDateTime()
    {
        return $this->LocalDateTime;
    }
    /**
     * Set LocalDateTime value
     * @param string $localDateTime
     * @return \StructType\POS_Type
     */
    public function setLocalDateTime($localDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($localDateTime) && !is_string($localDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDateTime, true), gettype($localDateTime)), __LINE__);
        }
        $this->LocalDateTime = $localDateTime;
        return $this;
    }
    /**
     * Get SourceID value
     * @return string|null
     */
    public function getSourceID()
    {
        return $this->SourceID;
    }
    /**
     * Set SourceID value
     * @param string $sourceID
     * @return \StructType\POS_Type
     */
    public function setSourceID($sourceID = null)
    {
        // validation for constraint: string
        if (!is_null($sourceID) && !is_string($sourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceID, true), gettype($sourceID)), __LINE__);
        }
        $this->SourceID = $sourceID;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\POS_Type
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get NdcInd value
     * @return bool|null
     */
    public function getNdcInd()
    {
        return $this->NdcInd;
    }
    /**
     * Set NdcInd value
     * @param bool $ndcInd
     * @return \StructType\POS_Type
     */
    public function setNdcInd($ndcInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ndcInd) && !is_bool($ndcInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ndcInd, true), gettype($ndcInd)), __LINE__);
        }
        $this->NdcInd = $ndcInd;
        return $this;
    }
}
