<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetail StructType
 * @subpackage Structs
 */
class OrderDetail extends AbstractStructBase
{
    /**
     * The ProductDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ProductDetailType[]
     */
    public $ProductDetail;
    /**
     * The PassengerDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\PassengerDetailType[]
     */
    public $PassengerDetail;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactInfoType
     */
    public $ContactInfo;
    /**
     * The FlightDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\FlightDetailType[]
     */
    public $FlightDetail;
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\HotelType[]
     */
    public $Hotel;
    /**
     * The CarRental
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CarRentalType[]
     */
    public $CarRental;
    /**
     * The Rail
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RailType[]
     */
    public $Rail;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $ShippingAddress;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The MCP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MCPType
     */
    public $MCP;
    /**
     * The MsfAgencyFeeDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MsfAgencyFeeDetail
     */
    public $MsfAgencyFeeDetail;
    /**
     * The RemarkLines
     * Meta information extracted from the WSDL
     * - documentation: e.g. PNR Remarks
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RemarkLinesType[]
     */
    public $RemarkLines;
    /**
     * The UniqueBookingID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for tracking transactions originating from the same booking/PNR
     * @var string
     */
    public $UniqueBookingID;
    /**
     * The SessionID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for tracking transactions from the same session
     * @var string
     */
    public $SessionID;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for tracking purposes.
     * @var string
     */
    public $OrderID;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - documentation: O - Original (default) EE - Even Exchange EA - Exchange w/ Add Collect ER - Exchange w/ Refund R - Refund
     * @var string
     */
    public $OrderType;
    /**
     * The OrderOfferType
     * @var string
     */
    public $OrderOfferType;
    /**
     * The OrderCreateDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the creation date of the order in UTC using the following format specified by ISO 8601; YYYY-MM-DD
     * @var string
     */
    public $OrderCreateDate;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - documentation: PNR Record locator
     * @var string
     */
    public $RecordLocator;
    /**
     * The DollarAmountPaid
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $DollarAmountPaid;
    /**
     * The InvoiceNumber
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ThirdPartyBookingInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the booking was made by a 3rd party. i.e. if the card holder is not one of the passengers, set this to true.
     * @var bool
     */
    public $ThirdPartyBookingInd;
    /**
     * The OneWayInd
     * Meta information extracted from the WSDL
     * - documentation: Set to true if the booking is a one-way trip.
     * @var bool
     */
    public $OneWayInd;
    /**
     * The MultiCityInd
     * Meta information extracted from the WSDL
     * - documentation: Set to true if the booking involves more than 1 destination cities.
     * @var bool
     */
    public $MultiCityInd;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: For BML: "SAC06M" - 6-month Same As Cash
     * @var string
     */
    public $PromotionCode;
    /**
     * The ValidatingCarrierCode
     * @var string
     */
    public $ValidatingCarrierCode;
    /**
     * The ValidatingCarrierNbr
     * @var string
     */
    public $ValidatingCarrierNbr;
    /**
     * The OrderExpireDateTime
     * Meta information extracted from the WSDL
     * - documentation: Indicates the expiration date and time of the order in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2017, 1:59:38 pm UTC becomes
     * 2017-11-20T13:59:38Z).
     * @var string
     */
    public $OrderExpireDateTime;
    /**
     * The ClearingSequence
     * Meta information extracted from the WSDL
     * - documentation: Indicates the tracking clearing sequence number
     * @var string
     */
    public $ClearingSequence;
    /**
     * The ClearingCount
     * Meta information extracted from the WSDL
     * - documentation: Indicates the total of clearing count
     * @var string
     */
    public $ClearingCount;
    /**
     * Constructor method for OrderDetail
     * @uses OrderDetail::setProductDetail()
     * @uses OrderDetail::setPassengerDetail()
     * @uses OrderDetail::setContactInfo()
     * @uses OrderDetail::setFlightDetail()
     * @uses OrderDetail::setHotel()
     * @uses OrderDetail::setCarRental()
     * @uses OrderDetail::setRail()
     * @uses OrderDetail::setShippingAddress()
     * @uses OrderDetail::setRemarks()
     * @uses OrderDetail::setMCP()
     * @uses OrderDetail::setMsfAgencyFeeDetail()
     * @uses OrderDetail::setRemarkLines()
     * @uses OrderDetail::setUniqueBookingID()
     * @uses OrderDetail::setSessionID()
     * @uses OrderDetail::setOrderID()
     * @uses OrderDetail::setOrderType()
     * @uses OrderDetail::setOrderOfferType()
     * @uses OrderDetail::setOrderCreateDate()
     * @uses OrderDetail::setRecordLocator()
     * @uses OrderDetail::setDollarAmountPaid()
     * @uses OrderDetail::setInvoiceNumber()
     * @uses OrderDetail::setThirdPartyBookingInd()
     * @uses OrderDetail::setOneWayInd()
     * @uses OrderDetail::setMultiCityInd()
     * @uses OrderDetail::setPromotionCode()
     * @uses OrderDetail::setValidatingCarrierCode()
     * @uses OrderDetail::setValidatingCarrierNbr()
     * @uses OrderDetail::setOrderExpireDateTime()
     * @uses OrderDetail::setClearingSequence()
     * @uses OrderDetail::setClearingCount()
     * @param \StructType\ProductDetailType[] $productDetail
     * @param \StructType\PassengerDetailType[] $passengerDetail
     * @param \StructType\ContactInfoType $contactInfo
     * @param \StructType\FlightDetailType[] $flightDetail
     * @param \StructType\HotelType[] $hotel
     * @param \StructType\CarRentalType[] $carRental
     * @param \StructType\RailType[] $rail
     * @param \StructType\AddressType $shippingAddress
     * @param string $remarks
     * @param \StructType\MCPType $mCP
     * @param \StructType\MsfAgencyFeeDetail $msfAgencyFeeDetail
     * @param \StructType\RemarkLinesType[] $remarkLines
     * @param string $uniqueBookingID
     * @param string $sessionID
     * @param string $orderID
     * @param string $orderType
     * @param string $orderOfferType
     * @param string $orderCreateDate
     * @param string $recordLocator
     * @param float $dollarAmountPaid
     * @param string $invoiceNumber
     * @param bool $thirdPartyBookingInd
     * @param bool $oneWayInd
     * @param bool $multiCityInd
     * @param string $promotionCode
     * @param string $validatingCarrierCode
     * @param string $validatingCarrierNbr
     * @param string $orderExpireDateTime
     * @param string $clearingSequence
     * @param string $clearingCount
     */
    public function __construct(array $productDetail = array(), array $passengerDetail = array(), \StructType\ContactInfoType $contactInfo = null, array $flightDetail = array(), array $hotel = array(), array $carRental = array(), array $rail = array(), \StructType\AddressType $shippingAddress = null, $remarks = null, \StructType\MCPType $mCP = null, \StructType\MsfAgencyFeeDetail $msfAgencyFeeDetail = null, array $remarkLines = array(), $uniqueBookingID = null, $sessionID = null, $orderID = null, $orderType = null, $orderOfferType = null, $orderCreateDate = null, $recordLocator = null, $dollarAmountPaid = null, $invoiceNumber = null, $thirdPartyBookingInd = null, $oneWayInd = null, $multiCityInd = null, $promotionCode = null, $validatingCarrierCode = null, $validatingCarrierNbr = null, $orderExpireDateTime = null, $clearingSequence = null, $clearingCount = null)
    {
        $this
            ->setProductDetail($productDetail)
            ->setPassengerDetail($passengerDetail)
            ->setContactInfo($contactInfo)
            ->setFlightDetail($flightDetail)
            ->setHotel($hotel)
            ->setCarRental($carRental)
            ->setRail($rail)
            ->setShippingAddress($shippingAddress)
            ->setRemarks($remarks)
            ->setMCP($mCP)
            ->setMsfAgencyFeeDetail($msfAgencyFeeDetail)
            ->setRemarkLines($remarkLines)
            ->setUniqueBookingID($uniqueBookingID)
            ->setSessionID($sessionID)
            ->setOrderID($orderID)
            ->setOrderType($orderType)
            ->setOrderOfferType($orderOfferType)
            ->setOrderCreateDate($orderCreateDate)
            ->setRecordLocator($recordLocator)
            ->setDollarAmountPaid($dollarAmountPaid)
            ->setInvoiceNumber($invoiceNumber)
            ->setThirdPartyBookingInd($thirdPartyBookingInd)
            ->setOneWayInd($oneWayInd)
            ->setMultiCityInd($multiCityInd)
            ->setPromotionCode($promotionCode)
            ->setValidatingCarrierCode($validatingCarrierCode)
            ->setValidatingCarrierNbr($validatingCarrierNbr)
            ->setOrderExpireDateTime($orderExpireDateTime)
            ->setClearingSequence($clearingSequence)
            ->setClearingCount($clearingCount);
    }
    /**
     * Get ProductDetail value
     * @return \StructType\ProductDetailType[]|null
     */
    public function getProductDetail()
    {
        return $this->ProductDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setProductDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductDetailForArrayConstraintsFromSetProductDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailProductDetailItem) {
            // validation for constraint: itemType
            if (!$orderDetailProductDetailItem instanceof \StructType\ProductDetailType) {
                $invalidValues[] = is_object($orderDetailProductDetailItem) ? get_class($orderDetailProductDetailItem) : sprintf('%s(%s)', gettype($orderDetailProductDetailItem), var_export($orderDetailProductDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductDetail property can only contain items of type \StructType\ProductDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetailType[] $productDetail
     * @return \StructType\OrderDetail
     */
    public function setProductDetail(array $productDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($productDetailArrayErrorMessage = self::validateProductDetailForArrayConstraintsFromSetProductDetail($productDetail))) {
            throw new \InvalidArgumentException($productDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($productDetail) && count($productDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($productDetail)), __LINE__);
        }
        $this->ProductDetail = $productDetail;
        return $this;
    }
    /**
     * Add item to ProductDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetailType $item
     * @return \StructType\OrderDetail
     */
    public function addToProductDetail(\StructType\ProductDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductDetailType) {
            throw new \InvalidArgumentException(sprintf('The ProductDetail property can only contain items of type \StructType\ProductDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ProductDetail) && count($this->ProductDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ProductDetail)), __LINE__);
        }
        $this->ProductDetail[] = $item;
        return $this;
    }
    /**
     * Get PassengerDetail value
     * @return \StructType\PassengerDetailType[]|null
     */
    public function getPassengerDetail()
    {
        return $this->PassengerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerDetailForArrayConstraintsFromSetPassengerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailPassengerDetailItem) {
            // validation for constraint: itemType
            if (!$orderDetailPassengerDetailItem instanceof \StructType\PassengerDetailType) {
                $invalidValues[] = is_object($orderDetailPassengerDetailItem) ? get_class($orderDetailPassengerDetailItem) : sprintf('%s(%s)', gettype($orderDetailPassengerDetailItem), var_export($orderDetailPassengerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetailType[] $passengerDetail
     * @return \StructType\OrderDetail
     */
    public function setPassengerDetail(array $passengerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerDetailArrayErrorMessage = self::validatePassengerDetailForArrayConstraintsFromSetPassengerDetail($passengerDetail))) {
            throw new \InvalidArgumentException($passengerDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerDetail) && count($passengerDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerDetail)), __LINE__);
        }
        $this->PassengerDetail = $passengerDetail;
        return $this;
    }
    /**
     * Add item to PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetailType $item
     * @return \StructType\OrderDetail
     */
    public function addToPassengerDetail(\StructType\PassengerDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerDetailType) {
            throw new \InvalidArgumentException(sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerDetail) && count($this->PassengerDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerDetail)), __LINE__);
        }
        $this->PassengerDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfoType $contactInfo
     * @return \StructType\OrderDetail
     */
    public function setContactInfo(\StructType\ContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get FlightDetail value
     * @return \StructType\FlightDetailType[]|null
     */
    public function getFlightDetail()
    {
        return $this->FlightDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightDetailForArrayConstraintsFromSetFlightDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailFlightDetailItem) {
            // validation for constraint: itemType
            if (!$orderDetailFlightDetailItem instanceof \StructType\FlightDetailType) {
                $invalidValues[] = is_object($orderDetailFlightDetailItem) ? get_class($orderDetailFlightDetailItem) : sprintf('%s(%s)', gettype($orderDetailFlightDetailItem), var_export($orderDetailFlightDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightDetail property can only contain items of type \StructType\FlightDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightDetailType[] $flightDetail
     * @return \StructType\OrderDetail
     */
    public function setFlightDetail(array $flightDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($flightDetailArrayErrorMessage = self::validateFlightDetailForArrayConstraintsFromSetFlightDetail($flightDetail))) {
            throw new \InvalidArgumentException($flightDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($flightDetail) && count($flightDetail) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($flightDetail)), __LINE__);
        }
        $this->FlightDetail = $flightDetail;
        return $this;
    }
    /**
     * Add item to FlightDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightDetailType $item
     * @return \StructType\OrderDetail
     */
    public function addToFlightDetail(\StructType\FlightDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightDetailType) {
            throw new \InvalidArgumentException(sprintf('The FlightDetail property can only contain items of type \StructType\FlightDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->FlightDetail) && count($this->FlightDetail) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->FlightDetail)), __LINE__);
        }
        $this->FlightDetail[] = $item;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \StructType\HotelType[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailHotelItem) {
            // validation for constraint: itemType
            if (!$orderDetailHotelItem instanceof \StructType\HotelType) {
                $invalidValues[] = is_object($orderDetailHotelItem) ? get_class($orderDetailHotelItem) : sprintf('%s(%s)', gettype($orderDetailHotelItem), var_export($orderDetailHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\HotelType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelType[] $hotel
     * @return \StructType\OrderDetail
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($hotel) && count($hotel) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($hotel)), __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelType $item
     * @return \StructType\OrderDetail
     */
    public function addToHotel(\StructType\HotelType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelType) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\HotelType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Hotel) && count($this->Hotel) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Hotel)), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Get CarRental value
     * @return \StructType\CarRentalType[]|null
     */
    public function getCarRental()
    {
        return $this->CarRental;
    }
    /**
     * This method is responsible for validating the values passed to the setCarRental method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarRental method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarRentalForArrayConstraintsFromSetCarRental(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailCarRentalItem) {
            // validation for constraint: itemType
            if (!$orderDetailCarRentalItem instanceof \StructType\CarRentalType) {
                $invalidValues[] = is_object($orderDetailCarRentalItem) ? get_class($orderDetailCarRentalItem) : sprintf('%s(%s)', gettype($orderDetailCarRentalItem), var_export($orderDetailCarRentalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarRental property can only contain items of type \StructType\CarRentalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarRental value
     * @throws \InvalidArgumentException
     * @param \StructType\CarRentalType[] $carRental
     * @return \StructType\OrderDetail
     */
    public function setCarRental(array $carRental = array())
    {
        // validation for constraint: array
        if ('' !== ($carRentalArrayErrorMessage = self::validateCarRentalForArrayConstraintsFromSetCarRental($carRental))) {
            throw new \InvalidArgumentException($carRentalArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($carRental) && count($carRental) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($carRental)), __LINE__);
        }
        $this->CarRental = $carRental;
        return $this;
    }
    /**
     * Add item to CarRental value
     * @throws \InvalidArgumentException
     * @param \StructType\CarRentalType $item
     * @return \StructType\OrderDetail
     */
    public function addToCarRental(\StructType\CarRentalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarRentalType) {
            throw new \InvalidArgumentException(sprintf('The CarRental property can only contain items of type \StructType\CarRentalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CarRental) && count($this->CarRental) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CarRental)), __LINE__);
        }
        $this->CarRental[] = $item;
        return $this;
    }
    /**
     * Get Rail value
     * @return \StructType\RailType[]|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * This method is responsible for validating the values passed to the setRail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailForArrayConstraintsFromSetRail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailRailItem) {
            // validation for constraint: itemType
            if (!$orderDetailRailItem instanceof \StructType\RailType) {
                $invalidValues[] = is_object($orderDetailRailItem) ? get_class($orderDetailRailItem) : sprintf('%s(%s)', gettype($orderDetailRailItem), var_export($orderDetailRailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rail property can only contain items of type \StructType\RailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rail value
     * @throws \InvalidArgumentException
     * @param \StructType\RailType[] $rail
     * @return \StructType\OrderDetail
     */
    public function setRail(array $rail = array())
    {
        // validation for constraint: array
        if ('' !== ($railArrayErrorMessage = self::validateRailForArrayConstraintsFromSetRail($rail))) {
            throw new \InvalidArgumentException($railArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rail) && count($rail) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rail)), __LINE__);
        }
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Add item to Rail value
     * @throws \InvalidArgumentException
     * @param \StructType\RailType $item
     * @return \StructType\OrderDetail
     */
    public function addToRail(\StructType\RailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RailType) {
            throw new \InvalidArgumentException(sprintf('The Rail property can only contain items of type \StructType\RailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Rail) && count($this->Rail) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Rail)), __LINE__);
        }
        $this->Rail[] = $item;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\AddressType|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\AddressType $shippingAddress
     * @return \StructType\OrderDetail
     */
    public function setShippingAddress(\StructType\AddressType $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\OrderDetail
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get MCP value
     * @return \StructType\MCPType|null
     */
    public function getMCP()
    {
        return $this->MCP;
    }
    /**
     * Set MCP value
     * @param \StructType\MCPType $mCP
     * @return \StructType\OrderDetail
     */
    public function setMCP(\StructType\MCPType $mCP = null)
    {
        $this->MCP = $mCP;
        return $this;
    }
    /**
     * Get MsfAgencyFeeDetail value
     * @return \StructType\MsfAgencyFeeDetail|null
     */
    public function getMsfAgencyFeeDetail()
    {
        return $this->MsfAgencyFeeDetail;
    }
    /**
     * Set MsfAgencyFeeDetail value
     * @param \StructType\MsfAgencyFeeDetail $msfAgencyFeeDetail
     * @return \StructType\OrderDetail
     */
    public function setMsfAgencyFeeDetail(\StructType\MsfAgencyFeeDetail $msfAgencyFeeDetail = null)
    {
        $this->MsfAgencyFeeDetail = $msfAgencyFeeDetail;
        return $this;
    }
    /**
     * Get RemarkLines value
     * @return \StructType\RemarkLinesType[]|null
     */
    public function getRemarkLines()
    {
        return $this->RemarkLines;
    }
    /**
     * This method is responsible for validating the values passed to the setRemarkLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemarkLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkLinesForArrayConstraintsFromSetRemarkLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailRemarkLinesItem) {
            // validation for constraint: itemType
            if (!$orderDetailRemarkLinesItem instanceof \StructType\RemarkLinesType) {
                $invalidValues[] = is_object($orderDetailRemarkLinesItem) ? get_class($orderDetailRemarkLinesItem) : sprintf('%s(%s)', gettype($orderDetailRemarkLinesItem), var_export($orderDetailRemarkLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RemarkLines property can only contain items of type \StructType\RemarkLinesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RemarkLines value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkLinesType[] $remarkLines
     * @return \StructType\OrderDetail
     */
    public function setRemarkLines(array $remarkLines = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkLinesArrayErrorMessage = self::validateRemarkLinesForArrayConstraintsFromSetRemarkLines($remarkLines))) {
            throw new \InvalidArgumentException($remarkLinesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($remarkLines) && count($remarkLines) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($remarkLines)), __LINE__);
        }
        $this->RemarkLines = $remarkLines;
        return $this;
    }
    /**
     * Add item to RemarkLines value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkLinesType $item
     * @return \StructType\OrderDetail
     */
    public function addToRemarkLines(\StructType\RemarkLinesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkLinesType) {
            throw new \InvalidArgumentException(sprintf('The RemarkLines property can only contain items of type \StructType\RemarkLinesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RemarkLines) && count($this->RemarkLines) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RemarkLines)), __LINE__);
        }
        $this->RemarkLines[] = $item;
        return $this;
    }
    /**
     * Get UniqueBookingID value
     * @return string|null
     */
    public function getUniqueBookingID()
    {
        return $this->UniqueBookingID;
    }
    /**
     * Set UniqueBookingID value
     * @param string $uniqueBookingID
     * @return \StructType\OrderDetail
     */
    public function setUniqueBookingID($uniqueBookingID = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueBookingID) && !is_string($uniqueBookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueBookingID, true), gettype($uniqueBookingID)), __LINE__);
        }
        $this->UniqueBookingID = $uniqueBookingID;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\OrderDetail
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\OrderDetail
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \StructType\OrderDetail
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderOfferType value
     * @return string|null
     */
    public function getOrderOfferType()
    {
        return $this->OrderOfferType;
    }
    /**
     * Set OrderOfferType value
     * @param string $orderOfferType
     * @return \StructType\OrderDetail
     */
    public function setOrderOfferType($orderOfferType = null)
    {
        // validation for constraint: string
        if (!is_null($orderOfferType) && !is_string($orderOfferType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderOfferType, true), gettype($orderOfferType)), __LINE__);
        }
        $this->OrderOfferType = $orderOfferType;
        return $this;
    }
    /**
     * Get OrderCreateDate value
     * @return string|null
     */
    public function getOrderCreateDate()
    {
        return $this->OrderCreateDate;
    }
    /**
     * Set OrderCreateDate value
     * @param string $orderCreateDate
     * @return \StructType\OrderDetail
     */
    public function setOrderCreateDate($orderCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderCreateDate) && !is_string($orderCreateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderCreateDate, true), gettype($orderCreateDate)), __LINE__);
        }
        $this->OrderCreateDate = $orderCreateDate;
        return $this;
    }
    /**
     * Get RecordLocator value
     * @return string|null
     */
    public function getRecordLocator()
    {
        return $this->RecordLocator;
    }
    /**
     * Set RecordLocator value
     * @param string $recordLocator
     * @return \StructType\OrderDetail
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        $this->RecordLocator = $recordLocator;
        return $this;
    }
    /**
     * Get DollarAmountPaid value
     * @return float|null
     */
    public function getDollarAmountPaid()
    {
        return $this->DollarAmountPaid;
    }
    /**
     * Set DollarAmountPaid value
     * @param float $dollarAmountPaid
     * @return \StructType\OrderDetail
     */
    public function setDollarAmountPaid($dollarAmountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($dollarAmountPaid) && !(is_float($dollarAmountPaid) || is_numeric($dollarAmountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dollarAmountPaid, true), gettype($dollarAmountPaid)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($dollarAmountPaid) && mb_strlen(mb_substr($dollarAmountPaid, false !== mb_strpos($dollarAmountPaid, '.') ? mb_strpos($dollarAmountPaid, '.') + 1 : mb_strlen($dollarAmountPaid))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($dollarAmountPaid, true), mb_strlen(mb_substr($dollarAmountPaid, mb_strpos($dollarAmountPaid, '.') + 1))), __LINE__);
        }
        $this->DollarAmountPaid = $dollarAmountPaid;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\OrderDetail
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get ThirdPartyBookingInd value
     * @return bool|null
     */
    public function getThirdPartyBookingInd()
    {
        return $this->ThirdPartyBookingInd;
    }
    /**
     * Set ThirdPartyBookingInd value
     * @param bool $thirdPartyBookingInd
     * @return \StructType\OrderDetail
     */
    public function setThirdPartyBookingInd($thirdPartyBookingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($thirdPartyBookingInd) && !is_bool($thirdPartyBookingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thirdPartyBookingInd, true), gettype($thirdPartyBookingInd)), __LINE__);
        }
        $this->ThirdPartyBookingInd = $thirdPartyBookingInd;
        return $this;
    }
    /**
     * Get OneWayInd value
     * @return bool|null
     */
    public function getOneWayInd()
    {
        return $this->OneWayInd;
    }
    /**
     * Set OneWayInd value
     * @param bool $oneWayInd
     * @return \StructType\OrderDetail
     */
    public function setOneWayInd($oneWayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($oneWayInd) && !is_bool($oneWayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oneWayInd, true), gettype($oneWayInd)), __LINE__);
        }
        $this->OneWayInd = $oneWayInd;
        return $this;
    }
    /**
     * Get MultiCityInd value
     * @return bool|null
     */
    public function getMultiCityInd()
    {
        return $this->MultiCityInd;
    }
    /**
     * Set MultiCityInd value
     * @param bool $multiCityInd
     * @return \StructType\OrderDetail
     */
    public function setMultiCityInd($multiCityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiCityInd) && !is_bool($multiCityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiCityInd, true), gettype($multiCityInd)), __LINE__);
        }
        $this->MultiCityInd = $multiCityInd;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\OrderDetail
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get ValidatingCarrierCode value
     * @return string|null
     */
    public function getValidatingCarrierCode()
    {
        return $this->ValidatingCarrierCode;
    }
    /**
     * Set ValidatingCarrierCode value
     * @param string $validatingCarrierCode
     * @return \StructType\OrderDetail
     */
    public function setValidatingCarrierCode($validatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrierCode) && !is_string($validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrierCode, true), gettype($validatingCarrierCode)), __LINE__);
        }
        $this->ValidatingCarrierCode = $validatingCarrierCode;
        return $this;
    }
    /**
     * Get ValidatingCarrierNbr value
     * @return string|null
     */
    public function getValidatingCarrierNbr()
    {
        return $this->ValidatingCarrierNbr;
    }
    /**
     * Set ValidatingCarrierNbr value
     * @param string $validatingCarrierNbr
     * @return \StructType\OrderDetail
     */
    public function setValidatingCarrierNbr($validatingCarrierNbr = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrierNbr) && !is_string($validatingCarrierNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrierNbr, true), gettype($validatingCarrierNbr)), __LINE__);
        }
        $this->ValidatingCarrierNbr = $validatingCarrierNbr;
        return $this;
    }
    /**
     * Get OrderExpireDateTime value
     * @return string|null
     */
    public function getOrderExpireDateTime()
    {
        return $this->OrderExpireDateTime;
    }
    /**
     * Set OrderExpireDateTime value
     * @param string $orderExpireDateTime
     * @return \StructType\OrderDetail
     */
    public function setOrderExpireDateTime($orderExpireDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($orderExpireDateTime) && !is_string($orderExpireDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderExpireDateTime, true), gettype($orderExpireDateTime)), __LINE__);
        }
        $this->OrderExpireDateTime = $orderExpireDateTime;
        return $this;
    }
    /**
     * Get ClearingSequence value
     * @return string|null
     */
    public function getClearingSequence()
    {
        return $this->ClearingSequence;
    }
    /**
     * Set ClearingSequence value
     * @param string $clearingSequence
     * @return \StructType\OrderDetail
     */
    public function setClearingSequence($clearingSequence = null)
    {
        // validation for constraint: string
        if (!is_null($clearingSequence) && !is_string($clearingSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearingSequence, true), gettype($clearingSequence)), __LINE__);
        }
        $this->ClearingSequence = $clearingSequence;
        return $this;
    }
    /**
     * Get ClearingCount value
     * @return string|null
     */
    public function getClearingCount()
    {
        return $this->ClearingCount;
    }
    /**
     * Set ClearingCount value
     * @param string $clearingCount
     * @return \StructType\OrderDetail
     */
    public function setClearingCount($clearingCount = null)
    {
        // validation for constraint: string
        if (!is_null($clearingCount) && !is_string($clearingCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearingCount, true), gettype($clearingCount)), __LINE__);
        }
        $this->ClearingCount = $clearingCount;
        return $this;
    }
}
