<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MCP_Offer StructType
 * @subpackage Structs
 */
class MCP_Offer extends AbstractStructBase
{
    /**
     * The PassengerDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\PassengerDetailType[]
     */
    public $PassengerDetail;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateSourceName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRateSourceName;
    /**
     * The ExchangeRateSourceDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRateSourceDateTime;
    /**
     * The ExchangeRateExpireDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRateExpireDateTime;
    /**
     * The MarginPercentRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $MarginPercentRate;
    /**
     * The CommissionPercentRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $CommissionPercentRate;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The CalculatedAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $CalculatedAmount;
    /**
     * Constructor method for MCP_Offer
     * @uses MCP_Offer::setPassengerDetail()
     * @uses MCP_Offer::setCurrencyCode()
     * @uses MCP_Offer::setExchangeRate()
     * @uses MCP_Offer::setExchangeRateSourceName()
     * @uses MCP_Offer::setExchangeRateSourceDateTime()
     * @uses MCP_Offer::setExchangeRateExpireDateTime()
     * @uses MCP_Offer::setMarginPercentRate()
     * @uses MCP_Offer::setCommissionPercentRate()
     * @uses MCP_Offer::setAmount()
     * @uses MCP_Offer::setCalculatedAmount()
     * @param \StructType\PassengerDetailType[] $passengerDetail
     * @param string $currencyCode
     * @param float $exchangeRate
     * @param string $exchangeRateSourceName
     * @param string $exchangeRateSourceDateTime
     * @param string $exchangeRateExpireDateTime
     * @param float $marginPercentRate
     * @param float $commissionPercentRate
     * @param float $amount
     * @param float $calculatedAmount
     */
    public function __construct(array $passengerDetail = array(), $currencyCode = null, $exchangeRate = null, $exchangeRateSourceName = null, $exchangeRateSourceDateTime = null, $exchangeRateExpireDateTime = null, $marginPercentRate = null, $commissionPercentRate = null, $amount = null, $calculatedAmount = null)
    {
        $this
            ->setPassengerDetail($passengerDetail)
            ->setCurrencyCode($currencyCode)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateSourceName($exchangeRateSourceName)
            ->setExchangeRateSourceDateTime($exchangeRateSourceDateTime)
            ->setExchangeRateExpireDateTime($exchangeRateExpireDateTime)
            ->setMarginPercentRate($marginPercentRate)
            ->setCommissionPercentRate($commissionPercentRate)
            ->setAmount($amount)
            ->setCalculatedAmount($calculatedAmount);
    }
    /**
     * Get PassengerDetail value
     * @return \StructType\PassengerDetailType[]|null
     */
    public function getPassengerDetail()
    {
        return $this->PassengerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerDetailForArrayConstraintsFromSetPassengerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mCP_OfferPassengerDetailItem) {
            // validation for constraint: itemType
            if (!$mCP_OfferPassengerDetailItem instanceof \StructType\PassengerDetailType) {
                $invalidValues[] = is_object($mCP_OfferPassengerDetailItem) ? get_class($mCP_OfferPassengerDetailItem) : sprintf('%s(%s)', gettype($mCP_OfferPassengerDetailItem), var_export($mCP_OfferPassengerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetailType[] $passengerDetail
     * @return \StructType\MCP_Offer
     */
    public function setPassengerDetail(array $passengerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerDetailArrayErrorMessage = self::validatePassengerDetailForArrayConstraintsFromSetPassengerDetail($passengerDetail))) {
            throw new \InvalidArgumentException($passengerDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerDetail) && count($passengerDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerDetail)), __LINE__);
        }
        $this->PassengerDetail = $passengerDetail;
        return $this;
    }
    /**
     * Add item to PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerDetailType $item
     * @return \StructType\MCP_Offer
     */
    public function addToPassengerDetail(\StructType\PassengerDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerDetailType) {
            throw new \InvalidArgumentException(sprintf('The PassengerDetail property can only contain items of type \StructType\PassengerDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerDetail) && count($this->PassengerDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerDetail)), __LINE__);
        }
        $this->PassengerDetail[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\MCP_Offer
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\MCP_Offer
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateSourceName value
     * @return string|null
     */
    public function getExchangeRateSourceName()
    {
        return $this->ExchangeRateSourceName;
    }
    /**
     * Set ExchangeRateSourceName value
     * @param string $exchangeRateSourceName
     * @return \StructType\MCP_Offer
     */
    public function setExchangeRateSourceName($exchangeRateSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateSourceName) && !is_string($exchangeRateSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateSourceName, true), gettype($exchangeRateSourceName)), __LINE__);
        }
        $this->ExchangeRateSourceName = $exchangeRateSourceName;
        return $this;
    }
    /**
     * Get ExchangeRateSourceDateTime value
     * @return string|null
     */
    public function getExchangeRateSourceDateTime()
    {
        return $this->ExchangeRateSourceDateTime;
    }
    /**
     * Set ExchangeRateSourceDateTime value
     * @param string $exchangeRateSourceDateTime
     * @return \StructType\MCP_Offer
     */
    public function setExchangeRateSourceDateTime($exchangeRateSourceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateSourceDateTime) && !is_string($exchangeRateSourceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateSourceDateTime, true), gettype($exchangeRateSourceDateTime)), __LINE__);
        }
        $this->ExchangeRateSourceDateTime = $exchangeRateSourceDateTime;
        return $this;
    }
    /**
     * Get ExchangeRateExpireDateTime value
     * @return string|null
     */
    public function getExchangeRateExpireDateTime()
    {
        return $this->ExchangeRateExpireDateTime;
    }
    /**
     * Set ExchangeRateExpireDateTime value
     * @param string $exchangeRateExpireDateTime
     * @return \StructType\MCP_Offer
     */
    public function setExchangeRateExpireDateTime($exchangeRateExpireDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateExpireDateTime) && !is_string($exchangeRateExpireDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateExpireDateTime, true), gettype($exchangeRateExpireDateTime)), __LINE__);
        }
        $this->ExchangeRateExpireDateTime = $exchangeRateExpireDateTime;
        return $this;
    }
    /**
     * Get MarginPercentRate value
     * @return float|null
     */
    public function getMarginPercentRate()
    {
        return $this->MarginPercentRate;
    }
    /**
     * Set MarginPercentRate value
     * @param float $marginPercentRate
     * @return \StructType\MCP_Offer
     */
    public function setMarginPercentRate($marginPercentRate = null)
    {
        // validation for constraint: float
        if (!is_null($marginPercentRate) && !(is_float($marginPercentRate) || is_numeric($marginPercentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($marginPercentRate, true), gettype($marginPercentRate)), __LINE__);
        }
        $this->MarginPercentRate = $marginPercentRate;
        return $this;
    }
    /**
     * Get CommissionPercentRate value
     * @return float|null
     */
    public function getCommissionPercentRate()
    {
        return $this->CommissionPercentRate;
    }
    /**
     * Set CommissionPercentRate value
     * @param float $commissionPercentRate
     * @return \StructType\MCP_Offer
     */
    public function setCommissionPercentRate($commissionPercentRate = null)
    {
        // validation for constraint: float
        if (!is_null($commissionPercentRate) && !(is_float($commissionPercentRate) || is_numeric($commissionPercentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionPercentRate, true), gettype($commissionPercentRate)), __LINE__);
        }
        $this->CommissionPercentRate = $commissionPercentRate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\MCP_Offer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CalculatedAmount value
     * @return float|null
     */
    public function getCalculatedAmount()
    {
        return $this->CalculatedAmount;
    }
    /**
     * Set CalculatedAmount value
     * @param float $calculatedAmount
     * @return \StructType\MCP_Offer
     */
    public function setCalculatedAmount($calculatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($calculatedAmount) && !(is_float($calculatedAmount) || is_numeric($calculatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculatedAmount, true), gettype($calculatedAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($calculatedAmount) && mb_strlen(mb_substr($calculatedAmount, false !== mb_strpos($calculatedAmount, '.') ? mb_strpos($calculatedAmount, '.') + 1 : mb_strlen($calculatedAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($calculatedAmount, true), mb_strlen(mb_substr($calculatedAmount, mb_strpos($calculatedAmount, '.') + 1))), __LINE__);
        }
        $this->CalculatedAmount = $calculatedAmount;
        return $this;
    }
}
