<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfReferenceNbrs StructType
 * @subpackage Structs
 */
class ListOfReferenceNbrs extends AbstractStructBase
{
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\ReferenceNbrType[]
     */
    public $ReferenceNbr;
    /**
     * Constructor method for ListOfReferenceNbrs
     * @uses ListOfReferenceNbrs::setReferenceNbr()
     * @param \StructType\ReferenceNbrType[] $referenceNbr
     */
    public function __construct(array $referenceNbr = array())
    {
        $this
            ->setReferenceNbr($referenceNbr);
    }
    /**
     * Get ReferenceNbr value
     * @return \StructType\ReferenceNbrType[]|null
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNbrForArrayConstraintsFromSetReferenceNbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfReferenceNbrsReferenceNbrItem) {
            // validation for constraint: itemType
            if (!$listOfReferenceNbrsReferenceNbrItem instanceof \StructType\ReferenceNbrType) {
                $invalidValues[] = is_object($listOfReferenceNbrsReferenceNbrItem) ? get_class($listOfReferenceNbrsReferenceNbrItem) : sprintf('%s(%s)', gettype($listOfReferenceNbrsReferenceNbrItem), var_export($listOfReferenceNbrsReferenceNbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNbr property can only contain items of type \StructType\ReferenceNbrType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNbrType[] $referenceNbr
     * @return \StructType\ListOfReferenceNbrs
     */
    public function setReferenceNbr(array $referenceNbr = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNbrArrayErrorMessage = self::validateReferenceNbrForArrayConstraintsFromSetReferenceNbr($referenceNbr))) {
            throw new \InvalidArgumentException($referenceNbrArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($referenceNbr) && count($referenceNbr) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($referenceNbr)), __LINE__);
        }
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
    /**
     * Add item to ReferenceNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceNbrType $item
     * @return \StructType\ListOfReferenceNbrs
     */
    public function addToReferenceNbr(\StructType\ReferenceNbrType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceNbrType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNbr property can only contain items of type \StructType\ReferenceNbrType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ReferenceNbr) && count($this->ReferenceNbr) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ReferenceNbr)), __LINE__);
        }
        $this->ReferenceNbr[] = $item;
        return $this;
    }
}
