<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssuerNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization, etc.).
 * @subpackage Structs
 */
class IssuerNameType extends AbstractStructBase
{
    /**
     * The BankID
     * Meta information extracted from the WSDL
     * - documentation: Code of bank issuing the card.
     * - use: optional
     * @var string
     */
    public $BankID;
    /**
     * Constructor method for IssuerNameType
     * @uses IssuerNameType::setBankID()
     * @param string $bankID
     */
    public function __construct($bankID = null)
    {
        $this
            ->setBankID($bankID);
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \StructType\IssuerNameType
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
}
