<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallmentDetail StructType
 * @subpackage Structs
 */
class InstallmentDetail extends AbstractStructBase
{
    /**
     * The Plan
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Plan;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NumberOfInstallments;
    /**
     * The InstallmentAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $InstallmentAmount;
    /**
     * The PromotionalInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $PromotionalInd;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Installment type
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Installment code
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - documentation: Installment group code
     * - use: optional
     * @var string
     */
    public $GroupCode;
    /**
     * Constructor method for InstallmentDetail
     * @uses InstallmentDetail::setPlan()
     * @uses InstallmentDetail::setNumberOfInstallments()
     * @uses InstallmentDetail::setInstallmentAmount()
     * @uses InstallmentDetail::setPromotionalInd()
     * @uses InstallmentDetail::setType()
     * @uses InstallmentDetail::setCode()
     * @uses InstallmentDetail::setGroupCode()
     * @param string $plan
     * @param string $numberOfInstallments
     * @param float $installmentAmount
     * @param bool $promotionalInd
     * @param string $type
     * @param string $code
     * @param string $groupCode
     */
    public function __construct($plan = null, $numberOfInstallments = null, $installmentAmount = null, $promotionalInd = null, $type = null, $code = null, $groupCode = null)
    {
        $this
            ->setPlan($plan)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setInstallmentAmount($installmentAmount)
            ->setPromotionalInd($promotionalInd)
            ->setType($type)
            ->setCode($code)
            ->setGroupCode($groupCode);
    }
    /**
     * Get Plan value
     * @return string|null
     */
    public function getPlan()
    {
        return $this->Plan;
    }
    /**
     * Set Plan value
     * @param string $plan
     * @return \StructType\InstallmentDetail
     */
    public function setPlan($plan = null)
    {
        // validation for constraint: string
        if (!is_null($plan) && !is_string($plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plan, true), gettype($plan)), __LINE__);
        }
        $this->Plan = $plan;
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * @return string|null
     */
    public function getNumberOfInstallments()
    {
        return $this->NumberOfInstallments;
    }
    /**
     * Set NumberOfInstallments value
     * @param string $numberOfInstallments
     * @return \StructType\InstallmentDetail
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfInstallments) && !is_string($numberOfInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        $this->NumberOfInstallments = $numberOfInstallments;
        return $this;
    }
    /**
     * Get InstallmentAmount value
     * @return float|null
     */
    public function getInstallmentAmount()
    {
        return $this->InstallmentAmount;
    }
    /**
     * Set InstallmentAmount value
     * @param float $installmentAmount
     * @return \StructType\InstallmentDetail
     */
    public function setInstallmentAmount($installmentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($installmentAmount) && !(is_float($installmentAmount) || is_numeric($installmentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentAmount, true), gettype($installmentAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($installmentAmount) && mb_strlen(mb_substr($installmentAmount, false !== mb_strpos($installmentAmount, '.') ? mb_strpos($installmentAmount, '.') + 1 : mb_strlen($installmentAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($installmentAmount, true), mb_strlen(mb_substr($installmentAmount, mb_strpos($installmentAmount, '.') + 1))), __LINE__);
        }
        $this->InstallmentAmount = $installmentAmount;
        return $this;
    }
    /**
     * Get PromotionalInd value
     * @return bool|null
     */
    public function getPromotionalInd()
    {
        return $this->PromotionalInd;
    }
    /**
     * Set PromotionalInd value
     * @param bool $promotionalInd
     * @return \StructType\InstallmentDetail
     */
    public function setPromotionalInd($promotionalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($promotionalInd) && !is_bool($promotionalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($promotionalInd, true), gettype($promotionalInd)), __LINE__);
        }
        $this->PromotionalInd = $promotionalInd;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\InstallmentDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\InstallmentDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\InstallmentDetail
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
}
