<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $errorCode;
    /**
     * The severity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $severity;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The codeContext
     * Meta information extracted from the WSDL
     * - default: urn:oasis:names:tc:ebxml-msg:service:errors
     * @var string
     */
    public $codeContext;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $location;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setSeverity()
     * @uses Error::setDescription()
     * @uses Error::setAny()
     * @uses Error::setId()
     * @uses Error::setCodeContext()
     * @uses Error::setLocation()
     * @param string $errorCode
     * @param string $severity
     * @param \StructType\Description $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $codeContext
     * @param string $location
     */
    public function __construct($errorCode = null, $severity = null, \StructType\Description $description = null, \DOMDocument $any = null, $id = null, $codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors', $location = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setSeverity($severity)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setCodeContext($codeContext)
            ->setLocation($location);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\Error
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errorCode) && mb_strlen($errorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get severity value
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @uses \EnumType\Severity_type::valueIsValid()
     * @uses \EnumType\Severity_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\Error
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Severity_type::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Severity_type', is_array($severity) ? implode(', ', $severity) : var_export($severity, true), implode(', ', \EnumType\Severity_type::getValidValues())), __LINE__);
        }
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\Error
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\Error
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Error
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get codeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->codeContext;
    }
    /**
     * Set codeContext value
     * @param string $codeContext
     * @return \StructType\Error
     */
    public function setCodeContext($codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors')
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        $this->codeContext = $codeContext;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\Error
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($location) && mb_strlen($location) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
}
