<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfoType StructType
 * @subpackage Structs
 */
class ContactInfoType extends AbstractStructBase
{
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \StructType\PhoneType[]
     */
    public $PhoneNumber;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for ContactInfoType
     * @uses ContactInfoType::setEmailAddress()
     * @uses ContactInfoType::setPhoneNumber()
     * @uses ContactInfoType::setName()
     * @uses ContactInfoType::setTitle()
     * @uses ContactInfoType::setFirstName()
     * @uses ContactInfoType::setMiddleName()
     * @uses ContactInfoType::setLastName()
     * @param string[] $emailAddress
     * @param \StructType\PhoneType[] $phoneNumber
     * @param string $name
     * @param string $title
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct(array $emailAddress = array(), array $phoneNumber = array(), $name = null, $title = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setName($name)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get EmailAddress value
     * @return string[]|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailAddressForArrayConstraintsFromSetEmailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypeEmailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($contactInfoTypeEmailAddressItem)) {
                $invalidValues[] = is_object($contactInfoTypeEmailAddressItem) ? get_class($contactInfoTypeEmailAddressItem) : sprintf('%s(%s)', gettype($contactInfoTypeEmailAddressItem), var_export($contactInfoTypeEmailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $emailAddress
     * @return \StructType\ContactInfoType
     */
    public function setEmailAddress(array $emailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($emailAddressArrayErrorMessage = self::validateEmailAddressForArrayConstraintsFromSetEmailAddress($emailAddress))) {
            throw new \InvalidArgumentException($emailAddressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($emailAddress) && count($emailAddress) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Add item to EmailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContactInfoType
     */
    public function addToEmailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->EmailAddress) && count($this->EmailAddress) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->EmailAddress)), __LINE__);
        }
        $this->EmailAddress[] = $item;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\PhoneType[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfoTypePhoneNumberItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypePhoneNumberItem instanceof \StructType\PhoneType) {
                $invalidValues[] = is_object($contactInfoTypePhoneNumberItem) ? get_class($contactInfoTypePhoneNumberItem) : sprintf('%s(%s)', gettype($contactInfoTypePhoneNumberItem), var_export($contactInfoTypePhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType[] $phoneNumber
     * @return \StructType\ContactInfoType
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($phoneNumber) && count($phoneNumber) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 7', count($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneType $item
     * @return \StructType\ContactInfoType
     */
    public function addToPhoneNumber(\StructType\PhoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneType) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type \StructType\PhoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(7)
        if (is_array($this->PhoneNumber) && count($this->PhoneNumber) >= 7) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 7', count($this->PhoneNumber)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ContactInfoType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ContactInfoType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\ContactInfoType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\ContactInfoType
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\ContactInfoType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
