<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CSC_ResultType StructType
 * @subpackage Structs
 */
class CSC_ResultType extends AbstractStructBase
{
    /**
     * The CSC_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: CardSecurityCode verification result code: I: Card verification number failed processor's data validation check. M: Card verification number matched. N: Card verification number not matched. P: Card verification number not processed.
     * S: Card verification number is on the card but was not included in the request. U: Card verification is not supported by the issuing bank. X: Card verification is not supported by the card association.
     * - use: optional
     * @var string
     */
    public $CSC_ResultCode;
    /**
     * The RawCSC_ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RawCSC_ResultCode;
    /**
     * The CSC_Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CSC_Remarks;
    /**
     * Constructor method for CSC_ResultType
     * @uses CSC_ResultType::setCSC_ResultCode()
     * @uses CSC_ResultType::setRawCSC_ResultCode()
     * @uses CSC_ResultType::setCSC_Remarks()
     * @param string $cSC_ResultCode
     * @param string $rawCSC_ResultCode
     * @param string $cSC_Remarks
     */
    public function __construct($cSC_ResultCode = null, $rawCSC_ResultCode = null, $cSC_Remarks = null)
    {
        $this
            ->setCSC_ResultCode($cSC_ResultCode)
            ->setRawCSC_ResultCode($rawCSC_ResultCode)
            ->setCSC_Remarks($cSC_Remarks);
    }
    /**
     * Get CSC_ResultCode value
     * @return string|null
     */
    public function getCSC_ResultCode()
    {
        return $this->CSC_ResultCode;
    }
    /**
     * Set CSC_ResultCode value
     * @param string $cSC_ResultCode
     * @return \StructType\CSC_ResultType
     */
    public function setCSC_ResultCode($cSC_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSC_ResultCode) && !is_string($cSC_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSC_ResultCode, true), gettype($cSC_ResultCode)), __LINE__);
        }
        $this->CSC_ResultCode = $cSC_ResultCode;
        return $this;
    }
    /**
     * Get RawCSC_ResultCode value
     * @return string|null
     */
    public function getRawCSC_ResultCode()
    {
        return $this->RawCSC_ResultCode;
    }
    /**
     * Set RawCSC_ResultCode value
     * @param string $rawCSC_ResultCode
     * @return \StructType\CSC_ResultType
     */
    public function setRawCSC_ResultCode($rawCSC_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($rawCSC_ResultCode) && !is_string($rawCSC_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rawCSC_ResultCode, true), gettype($rawCSC_ResultCode)), __LINE__);
        }
        $this->RawCSC_ResultCode = $rawCSC_ResultCode;
        return $this;
    }
    /**
     * Get CSC_Remarks value
     * @return string|null
     */
    public function getCSC_Remarks()
    {
        return $this->CSC_Remarks;
    }
    /**
     * Set CSC_Remarks value
     * @param string $cSC_Remarks
     * @return \StructType\CSC_ResultType
     */
    public function setCSC_Remarks($cSC_Remarks = null)
    {
        // validation for constraint: string
        if (!is_null($cSC_Remarks) && !is_string($cSC_Remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSC_Remarks, true), gettype($cSC_Remarks)), __LINE__);
        }
        $this->CSC_Remarks = $cSC_Remarks;
        return $this;
    }
}
