<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailType StructType
 * @subpackage Structs
 */
class AccountDetailType extends AbstractStructBase
{
    /**
     * The AccountType
     * @var string
     */
    public $AccountType;
    /**
     * The AccountNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AccountNbr;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AccountCode;
    /**
     * The MaskedAccountNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaskedAccountNbr;
    /**
     * The TokenizedAccountNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TokenizedAccountNbr;
    /**
     * The PIN
     * @var string
     */
    public $PIN;
    /**
     * The AccountHolderName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AccountHolderName;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The AccountCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Account currency
     * @var string
     */
    public $AccountCurrencyCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Transaction currency
     * @var string
     */
    public $CurrencyCode;
    /**
     * The IssuerName
     * Meta information extracted from the WSDL
     * - documentation: Name of account issuer such as bank name
     * - use: optional
     * @var string
     */
    public $IssuerName;
    /**
     * The BusinessIdentifierCode
     * Meta information extracted from the WSDL
     * - documentation: BIC for SEPA
     * - use: optional
     * @var string
     */
    public $BusinessIdentifierCode;
    /**
     * The SortCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SortCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The FOP_RPH
     * @var string
     */
    public $FOP_RPH;
    /**
     * The ReturnTokenInd
     * Meta information extracted from the WSDL
     * - documentation: If true, TokenizedCardNumber will be returned in PaymentRS.
     * - use: optional
     * @var bool
     */
    public $ReturnTokenInd;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Transaction ID
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The AccountAuthenticationToken
     * Meta information extracted from the WSDL
     * - documentation: Account Authentication Token
     * - use: optional
     * @var string
     */
    public $AccountAuthenticationToken;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - type: xs:string
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AccountDetailType
     * @uses AccountDetailType::setAccountType()
     * @uses AccountDetailType::setAccountNbr()
     * @uses AccountDetailType::setAccountCode()
     * @uses AccountDetailType::setMaskedAccountNbr()
     * @uses AccountDetailType::setTokenizedAccountNbr()
     * @uses AccountDetailType::setPIN()
     * @uses AccountDetailType::setAccountHolderName()
     * @uses AccountDetailType::setExpireDate()
     * @uses AccountDetailType::setAccountCurrencyCode()
     * @uses AccountDetailType::setCurrencyCode()
     * @uses AccountDetailType::setIssuerName()
     * @uses AccountDetailType::setBusinessIdentifierCode()
     * @uses AccountDetailType::setSortCode()
     * @uses AccountDetailType::setCountryCode()
     * @uses AccountDetailType::setFOP_RPH()
     * @uses AccountDetailType::setReturnTokenInd()
     * @uses AccountDetailType::setSupplierTransID()
     * @uses AccountDetailType::setAccountAuthenticationToken()
     * @uses AccountDetailType::setUserName()
     * @uses AccountDetailType::setPassword()
     * @param string $accountType
     * @param string $accountNbr
     * @param string $accountCode
     * @param string $maskedAccountNbr
     * @param string $tokenizedAccountNbr
     * @param string $pIN
     * @param string $accountHolderName
     * @param string $expireDate
     * @param string $accountCurrencyCode
     * @param string $currencyCode
     * @param string $issuerName
     * @param string $businessIdentifierCode
     * @param string $sortCode
     * @param string $countryCode
     * @param string $fOP_RPH
     * @param bool $returnTokenInd
     * @param string $supplierTransID
     * @param string $accountAuthenticationToken
     * @param string $userName
     * @param string $password
     */
    public function __construct($accountType = null, $accountNbr = null, $accountCode = null, $maskedAccountNbr = null, $tokenizedAccountNbr = null, $pIN = null, $accountHolderName = null, $expireDate = null, $accountCurrencyCode = null, $currencyCode = null, $issuerName = null, $businessIdentifierCode = null, $sortCode = null, $countryCode = null, $fOP_RPH = null, $returnTokenInd = null, $supplierTransID = null, $accountAuthenticationToken = null, $userName = null, $password = null)
    {
        $this
            ->setAccountType($accountType)
            ->setAccountNbr($accountNbr)
            ->setAccountCode($accountCode)
            ->setMaskedAccountNbr($maskedAccountNbr)
            ->setTokenizedAccountNbr($tokenizedAccountNbr)
            ->setPIN($pIN)
            ->setAccountHolderName($accountHolderName)
            ->setExpireDate($expireDate)
            ->setAccountCurrencyCode($accountCurrencyCode)
            ->setCurrencyCode($currencyCode)
            ->setIssuerName($issuerName)
            ->setBusinessIdentifierCode($businessIdentifierCode)
            ->setSortCode($sortCode)
            ->setCountryCode($countryCode)
            ->setFOP_RPH($fOP_RPH)
            ->setReturnTokenInd($returnTokenInd)
            ->setSupplierTransID($supplierTransID)
            ->setAccountAuthenticationToken($accountAuthenticationToken)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \StructType\AccountDetailType
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get AccountNbr value
     * @return string|null
     */
    public function getAccountNbr()
    {
        return $this->AccountNbr;
    }
    /**
     * Set AccountNbr value
     * @param string $accountNbr
     * @return \StructType\AccountDetailType
     */
    public function setAccountNbr($accountNbr = null)
    {
        // validation for constraint: string
        if (!is_null($accountNbr) && !is_string($accountNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNbr, true), gettype($accountNbr)), __LINE__);
        }
        $this->AccountNbr = $accountNbr;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\AccountDetailType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get MaskedAccountNbr value
     * @return string|null
     */
    public function getMaskedAccountNbr()
    {
        return $this->MaskedAccountNbr;
    }
    /**
     * Set MaskedAccountNbr value
     * @param string $maskedAccountNbr
     * @return \StructType\AccountDetailType
     */
    public function setMaskedAccountNbr($maskedAccountNbr = null)
    {
        // validation for constraint: string
        if (!is_null($maskedAccountNbr) && !is_string($maskedAccountNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedAccountNbr, true), gettype($maskedAccountNbr)), __LINE__);
        }
        $this->MaskedAccountNbr = $maskedAccountNbr;
        return $this;
    }
    /**
     * Get TokenizedAccountNbr value
     * @return string|null
     */
    public function getTokenizedAccountNbr()
    {
        return $this->TokenizedAccountNbr;
    }
    /**
     * Set TokenizedAccountNbr value
     * @param string $tokenizedAccountNbr
     * @return \StructType\AccountDetailType
     */
    public function setTokenizedAccountNbr($tokenizedAccountNbr = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedAccountNbr) && !is_string($tokenizedAccountNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedAccountNbr, true), gettype($tokenizedAccountNbr)), __LINE__);
        }
        $this->TokenizedAccountNbr = $tokenizedAccountNbr;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\AccountDetailType
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get AccountHolderName value
     * @return string|null
     */
    public function getAccountHolderName()
    {
        return $this->AccountHolderName;
    }
    /**
     * Set AccountHolderName value
     * @param string $accountHolderName
     * @return \StructType\AccountDetailType
     */
    public function setAccountHolderName($accountHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolderName) && !is_string($accountHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolderName, true), gettype($accountHolderName)), __LINE__);
        }
        $this->AccountHolderName = $accountHolderName;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\AccountDetailType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get AccountCurrencyCode value
     * @return string|null
     */
    public function getAccountCurrencyCode()
    {
        return $this->AccountCurrencyCode;
    }
    /**
     * Set AccountCurrencyCode value
     * @param string $accountCurrencyCode
     * @return \StructType\AccountDetailType
     */
    public function setAccountCurrencyCode($accountCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCurrencyCode) && !is_string($accountCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCurrencyCode, true), gettype($accountCurrencyCode)), __LINE__);
        }
        $this->AccountCurrencyCode = $accountCurrencyCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AccountDetailType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get IssuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->IssuerName;
    }
    /**
     * Set IssuerName value
     * @param string $issuerName
     * @return \StructType\AccountDetailType
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        $this->IssuerName = $issuerName;
        return $this;
    }
    /**
     * Get BusinessIdentifierCode value
     * @return string|null
     */
    public function getBusinessIdentifierCode()
    {
        return $this->BusinessIdentifierCode;
    }
    /**
     * Set BusinessIdentifierCode value
     * @param string $businessIdentifierCode
     * @return \StructType\AccountDetailType
     */
    public function setBusinessIdentifierCode($businessIdentifierCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessIdentifierCode) && !is_string($businessIdentifierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessIdentifierCode, true), gettype($businessIdentifierCode)), __LINE__);
        }
        $this->BusinessIdentifierCode = $businessIdentifierCode;
        return $this;
    }
    /**
     * Get SortCode value
     * @return string|null
     */
    public function getSortCode()
    {
        return $this->SortCode;
    }
    /**
     * Set SortCode value
     * @param string $sortCode
     * @return \StructType\AccountDetailType
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: string
        if (!is_null($sortCode) && !is_string($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortCode, true), gettype($sortCode)), __LINE__);
        }
        $this->SortCode = $sortCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\AccountDetailType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[a-zA-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get FOP_RPH value
     * @return string|null
     */
    public function getFOP_RPH()
    {
        return $this->FOP_RPH;
    }
    /**
     * Set FOP_RPH value
     * @param string $fOP_RPH
     * @return \StructType\AccountDetailType
     */
    public function setFOP_RPH($fOP_RPH = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_RPH) && !is_string($fOP_RPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_RPH, true), gettype($fOP_RPH)), __LINE__);
        }
        $this->FOP_RPH = $fOP_RPH;
        return $this;
    }
    /**
     * Get ReturnTokenInd value
     * @return bool|null
     */
    public function getReturnTokenInd()
    {
        return $this->ReturnTokenInd;
    }
    /**
     * Set ReturnTokenInd value
     * @param bool $returnTokenInd
     * @return \StructType\AccountDetailType
     */
    public function setReturnTokenInd($returnTokenInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnTokenInd) && !is_bool($returnTokenInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnTokenInd, true), gettype($returnTokenInd)), __LINE__);
        }
        $this->ReturnTokenInd = $returnTokenInd;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \StructType\AccountDetailType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get AccountAuthenticationToken value
     * @return string|null
     */
    public function getAccountAuthenticationToken()
    {
        return $this->AccountAuthenticationToken;
    }
    /**
     * Set AccountAuthenticationToken value
     * @param string $accountAuthenticationToken
     * @return \StructType\AccountDetailType
     */
    public function setAccountAuthenticationToken($accountAuthenticationToken = null)
    {
        // validation for constraint: string
        if (!is_null($accountAuthenticationToken) && !is_string($accountAuthenticationToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAuthenticationToken, true), gettype($accountAuthenticationToken)), __LINE__);
        }
        $this->AccountAuthenticationToken = $accountAuthenticationToken;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AccountDetailType
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AccountDetailType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
