<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailType StructType
 * @subpackage Structs
 */
class RailType extends AbstractStructBase
{
    /**
     * The Outbound
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RailJourneyType
     */
    public $Outbound;
    /**
     * The Return
     * @var \StructType\RailJourneyType
     */
    public $Return;
    /**
     * The ProviderInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProviderInfoType
     */
    public $ProviderInfo;
    /**
     * The AgreementNbr
     * Meta information extracted from the WSDL
     * - documentation: Required by Amex (max 14 chars)
     * @var string
     */
    public $AgreementNbr;
    /**
     * The ReferenceNbr
     * @var string
     */
    public $ReferenceNbr;
    /**
     * Constructor method for RailType
     * @uses RailType::setOutbound()
     * @uses RailType::setReturn()
     * @uses RailType::setProviderInfo()
     * @uses RailType::setAgreementNbr()
     * @uses RailType::setReferenceNbr()
     * @param \StructType\RailJourneyType $outbound
     * @param \StructType\RailJourneyType $return
     * @param \StructType\ProviderInfoType $providerInfo
     * @param string $agreementNbr
     * @param string $referenceNbr
     */
    public function __construct(\StructType\RailJourneyType $outbound = null, \StructType\RailJourneyType $return = null, \StructType\ProviderInfoType $providerInfo = null, $agreementNbr = null, $referenceNbr = null)
    {
        $this
            ->setOutbound($outbound)
            ->setReturn($return)
            ->setProviderInfo($providerInfo)
            ->setAgreementNbr($agreementNbr)
            ->setReferenceNbr($referenceNbr);
    }
    /**
     * Get Outbound value
     * @return \StructType\RailJourneyType|null
     */
    public function getOutbound()
    {
        return $this->Outbound;
    }
    /**
     * Set Outbound value
     * @param \StructType\RailJourneyType $outbound
     * @return \StructType\RailType
     */
    public function setOutbound(\StructType\RailJourneyType $outbound = null)
    {
        $this->Outbound = $outbound;
        return $this;
    }
    /**
     * Get Return value
     * @return \StructType\RailJourneyType|null
     */
    public function getReturn()
    {
        return $this->Return;
    }
    /**
     * Set Return value
     * @param \StructType\RailJourneyType $return
     * @return \StructType\RailType
     */
    public function setReturn(\StructType\RailJourneyType $return = null)
    {
        $this->Return = $return;
        return $this;
    }
    /**
     * Get ProviderInfo value
     * @return \StructType\ProviderInfoType|null
     */
    public function getProviderInfo()
    {
        return $this->ProviderInfo;
    }
    /**
     * Set ProviderInfo value
     * @param \StructType\ProviderInfoType $providerInfo
     * @return \StructType\RailType
     */
    public function setProviderInfo(\StructType\ProviderInfoType $providerInfo = null)
    {
        $this->ProviderInfo = $providerInfo;
        return $this;
    }
    /**
     * Get AgreementNbr value
     * @return string|null
     */
    public function getAgreementNbr()
    {
        return $this->AgreementNbr;
    }
    /**
     * Set AgreementNbr value
     * @param string $agreementNbr
     * @return \StructType\RailType
     */
    public function setAgreementNbr($agreementNbr = null)
    {
        // validation for constraint: string
        if (!is_null($agreementNbr) && !is_string($agreementNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementNbr, true), gettype($agreementNbr)), __LINE__);
        }
        $this->AgreementNbr = $agreementNbr;
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * @return string|null
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * Set ReferenceNbr value
     * @param string $referenceNbr
     * @return \StructType\RailType
     */
    public function setReferenceNbr($referenceNbr = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNbr) && !is_string($referenceNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNbr, true), gettype($referenceNbr)), __LINE__);
        }
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
}
