<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Service response
 * @subpackage Structs
 */
class PaymentRS extends AbstractStructBase
{
    /**
     * The SystemDateTime
     * Meta information extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in ISO8601 format
     * - use: required
     * @var string
     */
    public $SystemDateTime;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The MerchantDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MerchantDetailType
     */
    public $MerchantDetail;
    /**
     * The AuthenticationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthenticationDetailType
     */
    public $AuthenticationDetail;
    /**
     * The OrderDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderDetail
     */
    public $OrderDetail;
    /**
     * The Result
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Results[]
     */
    public $Results;
    /**
     * The BalanceInquiryResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BalanceInquiryResult
     */
    public $BalanceInquiryResult;
    /**
     * The VerificationResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VerificationResult
     */
    public $VerificationResult;
    /**
     * The DCC_Result
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DCC_Result
     */
    public $DCC_Result;
    /**
     * The MCP_Result
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MCP_Result
     */
    public $MCP_Result;
    /**
     * The AccountValidationResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\AccountValidationResult[]
     */
    public $AccountValidationResult;
    /**
     * The AuthorizationResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\AuthorizationResultType[]
     */
    public $AuthorizationResult;
    /**
     * The ConfirmAuthResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\ConfirmAuthResultType[]
     */
    public $ConfirmAuthResult;
    /**
     * The CancelAuthResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\CancelAuthResultType[]
     */
    public $CancelAuthResult;
    /**
     * The RefundResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\RefundResultType[]
     */
    public $RefundResult;
    /**
     * The CancelRefundResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\CancelRefundResultType[]
     */
    public $CancelRefundResult;
    /**
     * The GetCardResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetCardResult
     */
    public $GetCardResult;
    /**
     * The QueryDeferredPaymentResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\QueryDeferredPaymentResult
     */
    public $QueryDeferredPaymentResult;
    /**
     * The GetBINResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetBINResult
     */
    public $GetBINResult;
    /**
     * The GetDeploymentResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetDeploymentResultType
     */
    public $GetDeploymentResult;
    /**
     * The UpdateDeploymentResult
     * Meta information extracted from the WSDL
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UpdateDeploymentResultType
     */
    public $UpdateDeploymentResult;
    /**
     * The GetCardActivityResult
     * Meta information extracted from the WSDL
     * - documentation: Virtual card activity details
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetCardActivityResultType
     */
    public $GetCardActivityResult;
    /**
     * The T3DS_AuthenticationResult
     * Meta information extracted from the WSDL
     * - documentation: 3DS Authentication result details
     * - choice: BalanceInquiryResult | VerificationResult | DCC_Result | MCP_Result | AccountValidationResult | AuthorizationResult | ConfirmAuthResult | CancelAuthResult | RefundResult | CancelRefundResult | GetCardResult | QueryDeferredPaymentResult |
     * GetBINResult | GetDeploymentResult | UpdateDeploymentResult | GetCardActivityResult | T3DS_AuthenticationResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\T3DS_AuthenticationResultType[]
     */
    public $T3DS_AuthenticationResult;
    /**
     * The CaptureResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\CaptureResult[]
     */
    public $CaptureResult;
    /**
     * The AccountDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\AccountDetail[]
     */
    public $AccountDetail;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentDetailType
     */
    public $PaymentDetail;
    /**
     * The DeferredPaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeferredPaymentDetail
     */
    public $DeferredPaymentDetail;
    /**
     * The FraudScreenResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FraudScreenResultType
     */
    public $FraudScreenResult;
    /**
     * The FraudRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FraudRemarks
     */
    public $FraudRemarks;
    /**
     * The TokenizationResults
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TokenizationResultType[]
     */
    public $TokenizationResults;
    /**
     * The NotificationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NotificationList
     */
    public $NotificationList;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RemarksType
     */
    public $Remarks;
    /**
     * The DBIItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DBIItems
     */
    public $DBIItems;
    /**
     * The SabreTransactionID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier
     * - use: optional
     * @var string
     */
    public $SabreTransactionID;
    /**
     * The DeferredPaymentID
     * @var string
     */
    public $DeferredPaymentID;
    /**
     * The RetransmissionIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to TRUE) only when a message is retransmitted.
     * - use: optional
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for PaymentRS
     * @uses PaymentRS::setSystemDateTime()
     * @uses PaymentRS::setVersion()
     * @uses PaymentRS::setPOS()
     * @uses PaymentRS::setMerchantDetail()
     * @uses PaymentRS::setAuthenticationDetail()
     * @uses PaymentRS::setOrderDetail()
     * @uses PaymentRS::setResult()
     * @uses PaymentRS::setResults()
     * @uses PaymentRS::setBalanceInquiryResult()
     * @uses PaymentRS::setVerificationResult()
     * @uses PaymentRS::setDCC_Result()
     * @uses PaymentRS::setMCP_Result()
     * @uses PaymentRS::setAccountValidationResult()
     * @uses PaymentRS::setAuthorizationResult()
     * @uses PaymentRS::setConfirmAuthResult()
     * @uses PaymentRS::setCancelAuthResult()
     * @uses PaymentRS::setRefundResult()
     * @uses PaymentRS::setCancelRefundResult()
     * @uses PaymentRS::setGetCardResult()
     * @uses PaymentRS::setQueryDeferredPaymentResult()
     * @uses PaymentRS::setGetBINResult()
     * @uses PaymentRS::setGetDeploymentResult()
     * @uses PaymentRS::setUpdateDeploymentResult()
     * @uses PaymentRS::setGetCardActivityResult()
     * @uses PaymentRS::setT3DS_AuthenticationResult()
     * @uses PaymentRS::setCaptureResult()
     * @uses PaymentRS::setAccountDetail()
     * @uses PaymentRS::setPaymentDetail()
     * @uses PaymentRS::setDeferredPaymentDetail()
     * @uses PaymentRS::setFraudScreenResult()
     * @uses PaymentRS::setFraudRemarks()
     * @uses PaymentRS::setTokenizationResults()
     * @uses PaymentRS::setNotificationList()
     * @uses PaymentRS::setRemarks()
     * @uses PaymentRS::setDBIItems()
     * @uses PaymentRS::setSabreTransactionID()
     * @uses PaymentRS::setDeferredPaymentID()
     * @uses PaymentRS::setRetransmissionIndicator()
     * @param string $systemDateTime
     * @param string $version
     * @param \StructType\POS_Type $pOS
     * @param \StructType\MerchantDetailType $merchantDetail
     * @param \StructType\AuthenticationDetailType $authenticationDetail
     * @param \StructType\OrderDetail $orderDetail
     * @param \StructType\Result $result
     * @param \StructType\Results[] $results
     * @param \StructType\BalanceInquiryResult $balanceInquiryResult
     * @param \StructType\VerificationResult $verificationResult
     * @param \StructType\DCC_Result $dCC_Result
     * @param \StructType\MCP_Result $mCP_Result
     * @param \StructType\AccountValidationResult[] $accountValidationResult
     * @param \StructType\AuthorizationResultType[] $authorizationResult
     * @param \StructType\ConfirmAuthResultType[] $confirmAuthResult
     * @param \StructType\CancelAuthResultType[] $cancelAuthResult
     * @param \StructType\RefundResultType[] $refundResult
     * @param \StructType\CancelRefundResultType[] $cancelRefundResult
     * @param \StructType\GetCardResult $getCardResult
     * @param \StructType\QueryDeferredPaymentResult $queryDeferredPaymentResult
     * @param \StructType\GetBINResult $getBINResult
     * @param \StructType\GetDeploymentResultType $getDeploymentResult
     * @param \StructType\UpdateDeploymentResultType $updateDeploymentResult
     * @param \StructType\GetCardActivityResultType $getCardActivityResult
     * @param \StructType\T3DS_AuthenticationResultType[] $t3DS_AuthenticationResult
     * @param \StructType\CaptureResult[] $captureResult
     * @param \StructType\AccountDetail[] $accountDetail
     * @param \StructType\PaymentDetailType $paymentDetail
     * @param \StructType\DeferredPaymentDetail $deferredPaymentDetail
     * @param \StructType\FraudScreenResultType $fraudScreenResult
     * @param \StructType\FraudRemarks $fraudRemarks
     * @param \StructType\TokenizationResultType[] $tokenizationResults
     * @param \StructType\NotificationList $notificationList
     * @param \StructType\RemarksType $remarks
     * @param \StructType\DBIItems $dBIItems
     * @param string $sabreTransactionID
     * @param string $deferredPaymentID
     * @param bool $retransmissionIndicator
     */
    public function __construct($systemDateTime = null, $version = null, \StructType\POS_Type $pOS = null, \StructType\MerchantDetailType $merchantDetail = null, \StructType\AuthenticationDetailType $authenticationDetail = null, \StructType\OrderDetail $orderDetail = null, \StructType\Result $result = null, array $results = array(), \StructType\BalanceInquiryResult $balanceInquiryResult = null, \StructType\VerificationResult $verificationResult = null, \StructType\DCC_Result $dCC_Result = null, \StructType\MCP_Result $mCP_Result = null, array $accountValidationResult = array(), array $authorizationResult = array(), array $confirmAuthResult = array(), array $cancelAuthResult = array(), array $refundResult = array(), array $cancelRefundResult = array(), \StructType\GetCardResult $getCardResult = null, \StructType\QueryDeferredPaymentResult $queryDeferredPaymentResult = null, \StructType\GetBINResult $getBINResult = null, \StructType\GetDeploymentResultType $getDeploymentResult = null, \StructType\UpdateDeploymentResultType $updateDeploymentResult = null, \StructType\GetCardActivityResultType $getCardActivityResult = null, array $t3DS_AuthenticationResult = array(), array $captureResult = array(), array $accountDetail = array(), \StructType\PaymentDetailType $paymentDetail = null, \StructType\DeferredPaymentDetail $deferredPaymentDetail = null, \StructType\FraudScreenResultType $fraudScreenResult = null, \StructType\FraudRemarks $fraudRemarks = null, array $tokenizationResults = array(), \StructType\NotificationList $notificationList = null, \StructType\RemarksType $remarks = null, \StructType\DBIItems $dBIItems = null, $sabreTransactionID = null, $deferredPaymentID = null, $retransmissionIndicator = null)
    {
        $this
            ->setSystemDateTime($systemDateTime)
            ->setVersion($version)
            ->setPOS($pOS)
            ->setMerchantDetail($merchantDetail)
            ->setAuthenticationDetail($authenticationDetail)
            ->setOrderDetail($orderDetail)
            ->setResult($result)
            ->setResults($results)
            ->setBalanceInquiryResult($balanceInquiryResult)
            ->setVerificationResult($verificationResult)
            ->setDCC_Result($dCC_Result)
            ->setMCP_Result($mCP_Result)
            ->setAccountValidationResult($accountValidationResult)
            ->setAuthorizationResult($authorizationResult)
            ->setConfirmAuthResult($confirmAuthResult)
            ->setCancelAuthResult($cancelAuthResult)
            ->setRefundResult($refundResult)
            ->setCancelRefundResult($cancelRefundResult)
            ->setGetCardResult($getCardResult)
            ->setQueryDeferredPaymentResult($queryDeferredPaymentResult)
            ->setGetBINResult($getBINResult)
            ->setGetDeploymentResult($getDeploymentResult)
            ->setUpdateDeploymentResult($updateDeploymentResult)
            ->setGetCardActivityResult($getCardActivityResult)
            ->setT3DS_AuthenticationResult($t3DS_AuthenticationResult)
            ->setCaptureResult($captureResult)
            ->setAccountDetail($accountDetail)
            ->setPaymentDetail($paymentDetail)
            ->setDeferredPaymentDetail($deferredPaymentDetail)
            ->setFraudScreenResult($fraudScreenResult)
            ->setFraudRemarks($fraudRemarks)
            ->setTokenizationResults($tokenizationResults)
            ->setNotificationList($notificationList)
            ->setRemarks($remarks)
            ->setDBIItems($dBIItems)
            ->setSabreTransactionID($sabreTransactionID)
            ->setDeferredPaymentID($deferredPaymentID)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get SystemDateTime value
     * @return string
     */
    public function getSystemDateTime()
    {
        return $this->SystemDateTime;
    }
    /**
     * Set SystemDateTime value
     * @param string $systemDateTime
     * @return \StructType\PaymentRS
     */
    public function setSystemDateTime($systemDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($systemDateTime) && !is_string($systemDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemDateTime, true), gettype($systemDateTime)), __LINE__);
        }
        $this->SystemDateTime = $systemDateTime;
        return $this;
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\PaymentRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\PaymentRS
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get MerchantDetail value
     * @return \StructType\MerchantDetailType|null
     */
    public function getMerchantDetail()
    {
        return $this->MerchantDetail;
    }
    /**
     * Set MerchantDetail value
     * @param \StructType\MerchantDetailType $merchantDetail
     * @return \StructType\PaymentRS
     */
    public function setMerchantDetail(\StructType\MerchantDetailType $merchantDetail = null)
    {
        $this->MerchantDetail = $merchantDetail;
        return $this;
    }
    /**
     * Get AuthenticationDetail value
     * @return \StructType\AuthenticationDetailType|null
     */
    public function getAuthenticationDetail()
    {
        return $this->AuthenticationDetail;
    }
    /**
     * Set AuthenticationDetail value
     * @param \StructType\AuthenticationDetailType $authenticationDetail
     * @return \StructType\PaymentRS
     */
    public function setAuthenticationDetail(\StructType\AuthenticationDetailType $authenticationDetail = null)
    {
        $this->AuthenticationDetail = $authenticationDetail;
        return $this;
    }
    /**
     * Get OrderDetail value
     * @return \StructType\OrderDetail|null
     */
    public function getOrderDetail()
    {
        return $this->OrderDetail;
    }
    /**
     * Set OrderDetail value
     * @param \StructType\OrderDetail $orderDetail
     * @return \StructType\PaymentRS
     */
    public function setOrderDetail(\StructType\OrderDetail $orderDetail = null)
    {
        $this->OrderDetail = $orderDetail;
        return $this;
    }
    /**
     * Get Result value
     * @return \StructType\Result|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\PaymentRS
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Results value
     * @return \StructType\Results[]|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * This method is responsible for validating the values passed to the setResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultsForArrayConstraintsFromSetResults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSResultsItem) {
            // validation for constraint: itemType
            if (!$paymentRSResultsItem instanceof \StructType\Results) {
                $invalidValues[] = is_object($paymentRSResultsItem) ? get_class($paymentRSResultsItem) : sprintf('%s(%s)', gettype($paymentRSResultsItem), var_export($paymentRSResultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Results property can only contain items of type \StructType\Results, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Results value
     * @throws \InvalidArgumentException
     * @param \StructType\Results[] $results
     * @return \StructType\PaymentRS
     */
    public function setResults(array $results = array())
    {
        // validation for constraint: array
        if ('' !== ($resultsArrayErrorMessage = self::validateResultsForArrayConstraintsFromSetResults($results))) {
            throw new \InvalidArgumentException($resultsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($results) && count($results) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($results)), __LINE__);
        }
        $this->Results = $results;
        return $this;
    }
    /**
     * Add item to Results value
     * @throws \InvalidArgumentException
     * @param \StructType\Results $item
     * @return \StructType\PaymentRS
     */
    public function addToResults(\StructType\Results $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Results) {
            throw new \InvalidArgumentException(sprintf('The Results property can only contain items of type \StructType\Results, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Results) && count($this->Results) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Results)), __LINE__);
        }
        $this->Results[] = $item;
        return $this;
    }
    /**
     * Get BalanceInquiryResult value
     * @return \StructType\BalanceInquiryResult|null
     */
    public function getBalanceInquiryResult()
    {
        return isset($this->BalanceInquiryResult) ? $this->BalanceInquiryResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBalanceInquiryResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBalanceInquiryResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBalanceInquiryResultForChoiceConstraintsFromSetBalanceInquiryResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BalanceInquiryResult can\'t be set as the property %s is already set. Only one property must be set among these properties: BalanceInquiryResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BalanceInquiryResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BalanceInquiryResult $balanceInquiryResult
     * @return \StructType\PaymentRS
     */
    public function setBalanceInquiryResult(\StructType\BalanceInquiryResult $balanceInquiryResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($balanceInquiryResultChoiceErrorMessage = self::validateBalanceInquiryResultForChoiceConstraintsFromSetBalanceInquiryResult($balanceInquiryResult))) {
            throw new \InvalidArgumentException($balanceInquiryResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($balanceInquiryResult) || (is_array($balanceInquiryResult) && empty($balanceInquiryResult))) {
            unset($this->BalanceInquiryResult);
        } else {
            $this->BalanceInquiryResult = $balanceInquiryResult;
        }
        return $this;
    }
    /**
     * Get VerificationResult value
     * @return \StructType\VerificationResult|null
     */
    public function getVerificationResult()
    {
        return isset($this->VerificationResult) ? $this->VerificationResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerificationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerificationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerificationResultForChoiceConstraintsFromSetVerificationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VerificationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: VerificationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VerificationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VerificationResult $verificationResult
     * @return \StructType\PaymentRS
     */
    public function setVerificationResult(\StructType\VerificationResult $verificationResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($verificationResultChoiceErrorMessage = self::validateVerificationResultForChoiceConstraintsFromSetVerificationResult($verificationResult))) {
            throw new \InvalidArgumentException($verificationResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($verificationResult) || (is_array($verificationResult) && empty($verificationResult))) {
            unset($this->VerificationResult);
        } else {
            $this->VerificationResult = $verificationResult;
        }
        return $this;
    }
    /**
     * Get DCC_Result value
     * @return \StructType\DCC_Result|null
     */
    public function getDCC_Result()
    {
        return isset($this->DCC_Result) ? $this->DCC_Result : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDCC_Result method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDCC_Result method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDCC_ResultForChoiceConstraintsFromSetDCC_Result($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DCC_Result can\'t be set as the property %s is already set. Only one property must be set among these properties: DCC_Result, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DCC_Result value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DCC_Result $dCC_Result
     * @return \StructType\PaymentRS
     */
    public function setDCC_Result(\StructType\DCC_Result $dCC_Result = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($dCC_ResultChoiceErrorMessage = self::validateDCC_ResultForChoiceConstraintsFromSetDCC_Result($dCC_Result))) {
            throw new \InvalidArgumentException($dCC_ResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($dCC_Result) || (is_array($dCC_Result) && empty($dCC_Result))) {
            unset($this->DCC_Result);
        } else {
            $this->DCC_Result = $dCC_Result;
        }
        return $this;
    }
    /**
     * Get MCP_Result value
     * @return \StructType\MCP_Result|null
     */
    public function getMCP_Result()
    {
        return isset($this->MCP_Result) ? $this->MCP_Result : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMCP_Result method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMCP_Result method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMCP_ResultForChoiceConstraintsFromSetMCP_Result($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MCP_Result can\'t be set as the property %s is already set. Only one property must be set among these properties: MCP_Result, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MCP_Result value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MCP_Result $mCP_Result
     * @return \StructType\PaymentRS
     */
    public function setMCP_Result(\StructType\MCP_Result $mCP_Result = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($mCP_ResultChoiceErrorMessage = self::validateMCP_ResultForChoiceConstraintsFromSetMCP_Result($mCP_Result))) {
            throw new \InvalidArgumentException($mCP_ResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($mCP_Result) || (is_array($mCP_Result) && empty($mCP_Result))) {
            unset($this->MCP_Result);
        } else {
            $this->MCP_Result = $mCP_Result;
        }
        return $this;
    }
    /**
     * Get AccountValidationResult value
     * @return \StructType\AccountValidationResult[]|null
     */
    public function getAccountValidationResult()
    {
        return isset($this->AccountValidationResult) ? $this->AccountValidationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountValidationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountValidationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountValidationResultForArrayConstraintsFromSetAccountValidationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSAccountValidationResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSAccountValidationResultItem instanceof \StructType\AccountValidationResult) {
                $invalidValues[] = is_object($paymentRSAccountValidationResultItem) ? get_class($paymentRSAccountValidationResultItem) : sprintf('%s(%s)', gettype($paymentRSAccountValidationResultItem), var_export($paymentRSAccountValidationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountValidationResult property can only contain items of type \StructType\AccountValidationResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountValidationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountValidationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountValidationResultForChoiceConstraintsFromSetAccountValidationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountValidationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountValidationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountValidationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\AccountValidationResult[] $accountValidationResult
     * @return \StructType\PaymentRS
     */
    public function setAccountValidationResult(array $accountValidationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($accountValidationResultArrayErrorMessage = self::validateAccountValidationResultForArrayConstraintsFromSetAccountValidationResult($accountValidationResult))) {
            throw new \InvalidArgumentException($accountValidationResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($accountValidationResultChoiceErrorMessage = self::validateAccountValidationResultForChoiceConstraintsFromSetAccountValidationResult($accountValidationResult))) {
            throw new \InvalidArgumentException($accountValidationResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($accountValidationResult) && count($accountValidationResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($accountValidationResult)), __LINE__);
        }
        if (is_null($accountValidationResult) || (is_array($accountValidationResult) && empty($accountValidationResult))) {
            unset($this->AccountValidationResult);
        } else {
            $this->AccountValidationResult = $accountValidationResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAccountValidationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAccountValidationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAccountValidationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountValidationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountValidationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to AccountValidationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountValidationResult $item
     * @return \StructType\PaymentRS
     */
    public function addToAccountValidationResult(\StructType\AccountValidationResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountValidationResult) {
            throw new \InvalidArgumentException(sprintf('The AccountValidationResult property can only contain items of type \StructType\AccountValidationResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAccountValidationResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->AccountValidationResult) && count($this->AccountValidationResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->AccountValidationResult)), __LINE__);
        }
        $this->AccountValidationResult[] = $item;
        return $this;
    }
    /**
     * Get AuthorizationResult value
     * @return \StructType\AuthorizationResultType[]|null
     */
    public function getAuthorizationResult()
    {
        return isset($this->AuthorizationResult) ? $this->AuthorizationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorizationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizationResultForArrayConstraintsFromSetAuthorizationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSAuthorizationResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSAuthorizationResultItem instanceof \StructType\AuthorizationResultType) {
                $invalidValues[] = is_object($paymentRSAuthorizationResultItem) ? get_class($paymentRSAuthorizationResultItem) : sprintf('%s(%s)', gettype($paymentRSAuthorizationResultItem), var_export($paymentRSAuthorizationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AuthorizationResult property can only contain items of type \StructType\AuthorizationResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAuthorizationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAuthorizationResultForChoiceConstraintsFromSetAuthorizationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AuthorizationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AuthorizationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AuthorizationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationResultType[] $authorizationResult
     * @return \StructType\PaymentRS
     */
    public function setAuthorizationResult(array $authorizationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizationResultArrayErrorMessage = self::validateAuthorizationResultForArrayConstraintsFromSetAuthorizationResult($authorizationResult))) {
            throw new \InvalidArgumentException($authorizationResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($authorizationResultChoiceErrorMessage = self::validateAuthorizationResultForChoiceConstraintsFromSetAuthorizationResult($authorizationResult))) {
            throw new \InvalidArgumentException($authorizationResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($authorizationResult) && count($authorizationResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($authorizationResult)), __LINE__);
        }
        if (is_null($authorizationResult) || (is_array($authorizationResult) && empty($authorizationResult))) {
            unset($this->AuthorizationResult);
        } else {
            $this->AuthorizationResult = $authorizationResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAuthorizationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAuthorizationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAuthorizationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AuthorizationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: AuthorizationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to AuthorizationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizationResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToAuthorizationResult(\StructType\AuthorizationResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizationResultType) {
            throw new \InvalidArgumentException(sprintf('The AuthorizationResult property can only contain items of type \StructType\AuthorizationResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAuthorizationResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->AuthorizationResult) && count($this->AuthorizationResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->AuthorizationResult)), __LINE__);
        }
        $this->AuthorizationResult[] = $item;
        return $this;
    }
    /**
     * Get ConfirmAuthResult value
     * @return \StructType\ConfirmAuthResultType[]|null
     */
    public function getConfirmAuthResult()
    {
        return isset($this->ConfirmAuthResult) ? $this->ConfirmAuthResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfirmAuthResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfirmAuthResultForArrayConstraintsFromSetConfirmAuthResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSConfirmAuthResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSConfirmAuthResultItem instanceof \StructType\ConfirmAuthResultType) {
                $invalidValues[] = is_object($paymentRSConfirmAuthResultItem) ? get_class($paymentRSConfirmAuthResultItem) : sprintf('%s(%s)', gettype($paymentRSConfirmAuthResultItem), var_export($paymentRSConfirmAuthResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConfirmAuthResult property can only contain items of type \StructType\ConfirmAuthResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfirmAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateConfirmAuthResultForChoiceConstraintsFromSetConfirmAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ConfirmAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ConfirmAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ConfirmAuthResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\ConfirmAuthResultType[] $confirmAuthResult
     * @return \StructType\PaymentRS
     */
    public function setConfirmAuthResult(array $confirmAuthResult = array())
    {
        // validation for constraint: array
        if ('' !== ($confirmAuthResultArrayErrorMessage = self::validateConfirmAuthResultForArrayConstraintsFromSetConfirmAuthResult($confirmAuthResult))) {
            throw new \InvalidArgumentException($confirmAuthResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($confirmAuthResultChoiceErrorMessage = self::validateConfirmAuthResultForChoiceConstraintsFromSetConfirmAuthResult($confirmAuthResult))) {
            throw new \InvalidArgumentException($confirmAuthResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($confirmAuthResult) && count($confirmAuthResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($confirmAuthResult)), __LINE__);
        }
        if (is_null($confirmAuthResult) || (is_array($confirmAuthResult) && empty($confirmAuthResult))) {
            unset($this->ConfirmAuthResult);
        } else {
            $this->ConfirmAuthResult = $confirmAuthResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToConfirmAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToConfirmAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToConfirmAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ConfirmAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ConfirmAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ConfirmAuthResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfirmAuthResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToConfirmAuthResult(\StructType\ConfirmAuthResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConfirmAuthResultType) {
            throw new \InvalidArgumentException(sprintf('The ConfirmAuthResult property can only contain items of type \StructType\ConfirmAuthResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToConfirmAuthResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ConfirmAuthResult) && count($this->ConfirmAuthResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ConfirmAuthResult)), __LINE__);
        }
        $this->ConfirmAuthResult[] = $item;
        return $this;
    }
    /**
     * Get CancelAuthResult value
     * @return \StructType\CancelAuthResultType[]|null
     */
    public function getCancelAuthResult()
    {
        return isset($this->CancelAuthResult) ? $this->CancelAuthResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelAuthResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelAuthResultForArrayConstraintsFromSetCancelAuthResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSCancelAuthResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSCancelAuthResultItem instanceof \StructType\CancelAuthResultType) {
                $invalidValues[] = is_object($paymentRSCancelAuthResultItem) ? get_class($paymentRSCancelAuthResultItem) : sprintf('%s(%s)', gettype($paymentRSCancelAuthResultItem), var_export($paymentRSCancelAuthResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelAuthResult property can only contain items of type \StructType\CancelAuthResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelAuthResultForChoiceConstraintsFromSetCancelAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelAuthResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CancelAuthResultType[] $cancelAuthResult
     * @return \StructType\PaymentRS
     */
    public function setCancelAuthResult(array $cancelAuthResult = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelAuthResultArrayErrorMessage = self::validateCancelAuthResultForArrayConstraintsFromSetCancelAuthResult($cancelAuthResult))) {
            throw new \InvalidArgumentException($cancelAuthResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($cancelAuthResultChoiceErrorMessage = self::validateCancelAuthResultForChoiceConstraintsFromSetCancelAuthResult($cancelAuthResult))) {
            throw new \InvalidArgumentException($cancelAuthResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($cancelAuthResult) && count($cancelAuthResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($cancelAuthResult)), __LINE__);
        }
        if (is_null($cancelAuthResult) || (is_array($cancelAuthResult) && empty($cancelAuthResult))) {
            unset($this->CancelAuthResult);
        } else {
            $this->CancelAuthResult = $cancelAuthResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCancelAuthResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCancelAuthResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCancelAuthResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelAuthResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelAuthResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CancelAuthResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelAuthResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToCancelAuthResult(\StructType\CancelAuthResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelAuthResultType) {
            throw new \InvalidArgumentException(sprintf('The CancelAuthResult property can only contain items of type \StructType\CancelAuthResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCancelAuthResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CancelAuthResult) && count($this->CancelAuthResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CancelAuthResult)), __LINE__);
        }
        $this->CancelAuthResult[] = $item;
        return $this;
    }
    /**
     * Get RefundResult value
     * @return \StructType\RefundResultType[]|null
     */
    public function getRefundResult()
    {
        return isset($this->RefundResult) ? $this->RefundResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefundResultForArrayConstraintsFromSetRefundResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSRefundResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSRefundResultItem instanceof \StructType\RefundResultType) {
                $invalidValues[] = is_object($paymentRSRefundResultItem) ? get_class($paymentRSRefundResultItem) : sprintf('%s(%s)', gettype($paymentRSRefundResultItem), var_export($paymentRSRefundResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefundResult property can only contain items of type \StructType\RefundResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRefundResultForChoiceConstraintsFromSetRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RefundResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\RefundResultType[] $refundResult
     * @return \StructType\PaymentRS
     */
    public function setRefundResult(array $refundResult = array())
    {
        // validation for constraint: array
        if ('' !== ($refundResultArrayErrorMessage = self::validateRefundResultForArrayConstraintsFromSetRefundResult($refundResult))) {
            throw new \InvalidArgumentException($refundResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($refundResultChoiceErrorMessage = self::validateRefundResultForChoiceConstraintsFromSetRefundResult($refundResult))) {
            throw new \InvalidArgumentException($refundResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($refundResult) && count($refundResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($refundResult)), __LINE__);
        }
        if (is_null($refundResult) || (is_array($refundResult) && empty($refundResult))) {
            unset($this->RefundResult);
        } else {
            $this->RefundResult = $refundResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to RefundResult value
     * @throws \InvalidArgumentException
     * @param \StructType\RefundResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToRefundResult(\StructType\RefundResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefundResultType) {
            throw new \InvalidArgumentException(sprintf('The RefundResult property can only contain items of type \StructType\RefundResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRefundResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->RefundResult) && count($this->RefundResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->RefundResult)), __LINE__);
        }
        $this->RefundResult[] = $item;
        return $this;
    }
    /**
     * Get CancelRefundResult value
     * @return \StructType\CancelRefundResultType[]|null
     */
    public function getCancelRefundResult()
    {
        return isset($this->CancelRefundResult) ? $this->CancelRefundResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRefundResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRefundResultForArrayConstraintsFromSetCancelRefundResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSCancelRefundResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSCancelRefundResultItem instanceof \StructType\CancelRefundResultType) {
                $invalidValues[] = is_object($paymentRSCancelRefundResultItem) ? get_class($paymentRSCancelRefundResultItem) : sprintf('%s(%s)', gettype($paymentRSCancelRefundResultItem), var_export($paymentRSCancelRefundResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRefundResult property can only contain items of type \StructType\CancelRefundResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancelRefundResultForChoiceConstraintsFromSetCancelRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelRefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelRefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CancelRefundResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRefundResultType[] $cancelRefundResult
     * @return \StructType\PaymentRS
     */
    public function setCancelRefundResult(array $cancelRefundResult = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRefundResultArrayErrorMessage = self::validateCancelRefundResultForArrayConstraintsFromSetCancelRefundResult($cancelRefundResult))) {
            throw new \InvalidArgumentException($cancelRefundResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($cancelRefundResultChoiceErrorMessage = self::validateCancelRefundResultForChoiceConstraintsFromSetCancelRefundResult($cancelRefundResult))) {
            throw new \InvalidArgumentException($cancelRefundResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($cancelRefundResult) && count($cancelRefundResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($cancelRefundResult)), __LINE__);
        }
        if (is_null($cancelRefundResult) || (is_array($cancelRefundResult) && empty($cancelRefundResult))) {
            unset($this->CancelRefundResult);
        } else {
            $this->CancelRefundResult = $cancelRefundResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCancelRefundResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCancelRefundResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCancelRefundResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CancelRefundResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CancelRefundResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CancelRefundResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRefundResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToCancelRefundResult(\StructType\CancelRefundResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRefundResultType) {
            throw new \InvalidArgumentException(sprintf('The CancelRefundResult property can only contain items of type \StructType\CancelRefundResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCancelRefundResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CancelRefundResult) && count($this->CancelRefundResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CancelRefundResult)), __LINE__);
        }
        $this->CancelRefundResult[] = $item;
        return $this;
    }
    /**
     * Get GetCardResult value
     * @return \StructType\GetCardResult|null
     */
    public function getGetCardResult()
    {
        return isset($this->GetCardResult) ? $this->GetCardResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetCardResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetCardResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetCardResultForChoiceConstraintsFromSetGetCardResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetCardResult can\'t be set as the property %s is already set. Only one property must be set among these properties: GetCardResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetCardResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GetCardResult $getCardResult
     * @return \StructType\PaymentRS
     */
    public function setGetCardResult(\StructType\GetCardResult $getCardResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($getCardResultChoiceErrorMessage = self::validateGetCardResultForChoiceConstraintsFromSetGetCardResult($getCardResult))) {
            throw new \InvalidArgumentException($getCardResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($getCardResult) || (is_array($getCardResult) && empty($getCardResult))) {
            unset($this->GetCardResult);
        } else {
            $this->GetCardResult = $getCardResult;
        }
        return $this;
    }
    /**
     * Get QueryDeferredPaymentResult value
     * @return \StructType\QueryDeferredPaymentResult|null
     */
    public function getQueryDeferredPaymentResult()
    {
        return isset($this->QueryDeferredPaymentResult) ? $this->QueryDeferredPaymentResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setQueryDeferredPaymentResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryDeferredPaymentResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateQueryDeferredPaymentResultForChoiceConstraintsFromSetQueryDeferredPaymentResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property QueryDeferredPaymentResult can\'t be set as the property %s is already set. Only one property must be set among these properties: QueryDeferredPaymentResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set QueryDeferredPaymentResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QueryDeferredPaymentResult $queryDeferredPaymentResult
     * @return \StructType\PaymentRS
     */
    public function setQueryDeferredPaymentResult(\StructType\QueryDeferredPaymentResult $queryDeferredPaymentResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($queryDeferredPaymentResultChoiceErrorMessage = self::validateQueryDeferredPaymentResultForChoiceConstraintsFromSetQueryDeferredPaymentResult($queryDeferredPaymentResult))) {
            throw new \InvalidArgumentException($queryDeferredPaymentResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($queryDeferredPaymentResult) || (is_array($queryDeferredPaymentResult) && empty($queryDeferredPaymentResult))) {
            unset($this->QueryDeferredPaymentResult);
        } else {
            $this->QueryDeferredPaymentResult = $queryDeferredPaymentResult;
        }
        return $this;
    }
    /**
     * Get GetBINResult value
     * @return \StructType\GetBINResult|null
     */
    public function getGetBINResult()
    {
        return isset($this->GetBINResult) ? $this->GetBINResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetBINResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetBINResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetBINResultForChoiceConstraintsFromSetGetBINResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetBINResult can\'t be set as the property %s is already set. Only one property must be set among these properties: GetBINResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetBINResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GetBINResult $getBINResult
     * @return \StructType\PaymentRS
     */
    public function setGetBINResult(\StructType\GetBINResult $getBINResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($getBINResultChoiceErrorMessage = self::validateGetBINResultForChoiceConstraintsFromSetGetBINResult($getBINResult))) {
            throw new \InvalidArgumentException($getBINResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($getBINResult) || (is_array($getBINResult) && empty($getBINResult))) {
            unset($this->GetBINResult);
        } else {
            $this->GetBINResult = $getBINResult;
        }
        return $this;
    }
    /**
     * Get GetDeploymentResult value
     * @return \StructType\GetDeploymentResultType|null
     */
    public function getGetDeploymentResult()
    {
        return isset($this->GetDeploymentResult) ? $this->GetDeploymentResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetDeploymentResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetDeploymentResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetDeploymentResultForChoiceConstraintsFromSetGetDeploymentResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetDeploymentResult can\'t be set as the property %s is already set. Only one property must be set among these properties: GetDeploymentResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetDeploymentResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GetDeploymentResultType $getDeploymentResult
     * @return \StructType\PaymentRS
     */
    public function setGetDeploymentResult(\StructType\GetDeploymentResultType $getDeploymentResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($getDeploymentResultChoiceErrorMessage = self::validateGetDeploymentResultForChoiceConstraintsFromSetGetDeploymentResult($getDeploymentResult))) {
            throw new \InvalidArgumentException($getDeploymentResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($getDeploymentResult) || (is_array($getDeploymentResult) && empty($getDeploymentResult))) {
            unset($this->GetDeploymentResult);
        } else {
            $this->GetDeploymentResult = $getDeploymentResult;
        }
        return $this;
    }
    /**
     * Get UpdateDeploymentResult value
     * @return \StructType\UpdateDeploymentResultType|null
     */
    public function getUpdateDeploymentResult()
    {
        return isset($this->UpdateDeploymentResult) ? $this->UpdateDeploymentResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUpdateDeploymentResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdateDeploymentResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUpdateDeploymentResultForChoiceConstraintsFromSetUpdateDeploymentResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'GetCardActivityResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UpdateDeploymentResult can\'t be set as the property %s is already set. Only one property must be set among these properties: UpdateDeploymentResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UpdateDeploymentResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UpdateDeploymentResultType $updateDeploymentResult
     * @return \StructType\PaymentRS
     */
    public function setUpdateDeploymentResult(\StructType\UpdateDeploymentResultType $updateDeploymentResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($updateDeploymentResultChoiceErrorMessage = self::validateUpdateDeploymentResultForChoiceConstraintsFromSetUpdateDeploymentResult($updateDeploymentResult))) {
            throw new \InvalidArgumentException($updateDeploymentResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($updateDeploymentResult) || (is_array($updateDeploymentResult) && empty($updateDeploymentResult))) {
            unset($this->UpdateDeploymentResult);
        } else {
            $this->UpdateDeploymentResult = $updateDeploymentResult;
        }
        return $this;
    }
    /**
     * Get GetCardActivityResult value
     * @return \StructType\GetCardActivityResultType|null
     */
    public function getGetCardActivityResult()
    {
        return isset($this->GetCardActivityResult) ? $this->GetCardActivityResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGetCardActivityResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGetCardActivityResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGetCardActivityResultForChoiceConstraintsFromSetGetCardActivityResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'T3DS_AuthenticationResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GetCardActivityResult can\'t be set as the property %s is already set. Only one property must be set among these properties: GetCardActivityResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GetCardActivityResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GetCardActivityResultType $getCardActivityResult
     * @return \StructType\PaymentRS
     */
    public function setGetCardActivityResult(\StructType\GetCardActivityResultType $getCardActivityResult = null)
    {
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($getCardActivityResultChoiceErrorMessage = self::validateGetCardActivityResultForChoiceConstraintsFromSetGetCardActivityResult($getCardActivityResult))) {
            throw new \InvalidArgumentException($getCardActivityResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($getCardActivityResult) || (is_array($getCardActivityResult) && empty($getCardActivityResult))) {
            unset($this->GetCardActivityResult);
        } else {
            $this->GetCardActivityResult = $getCardActivityResult;
        }
        return $this;
    }
    /**
     * Get T3DS_AuthenticationResult value
     * @return \StructType\T3DS_AuthenticationResultType[]|null
     */
    public function getT3DS_AuthenticationResult()
    {
        return isset($this->T3DS_AuthenticationResult) ? $this->T3DS_AuthenticationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setT3DS_AuthenticationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateT3DS_AuthenticationResultForArrayConstraintsFromSetT3DS_AuthenticationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRST3DS_AuthenticationResultItem) {
            // validation for constraint: itemType
            if (!$paymentRST3DS_AuthenticationResultItem instanceof \StructType\T3DS_AuthenticationResultType) {
                $invalidValues[] = is_object($paymentRST3DS_AuthenticationResultItem) ? get_class($paymentRST3DS_AuthenticationResultItem) : sprintf('%s(%s)', gettype($paymentRST3DS_AuthenticationResultItem), var_export($paymentRST3DS_AuthenticationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The T3DS_AuthenticationResult property can only contain items of type \StructType\T3DS_AuthenticationResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setT3DS_AuthenticationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateT3DS_AuthenticationResultForChoiceConstraintsFromSetT3DS_AuthenticationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property T3DS_AuthenticationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: T3DS_AuthenticationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set T3DS_AuthenticationResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\T3DS_AuthenticationResultType[] $t3DS_AuthenticationResult
     * @return \StructType\PaymentRS
     */
    public function setT3DS_AuthenticationResult(array $t3DS_AuthenticationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($t3DS_AuthenticationResultArrayErrorMessage = self::validateT3DS_AuthenticationResultForArrayConstraintsFromSetT3DS_AuthenticationResult($t3DS_AuthenticationResult))) {
            throw new \InvalidArgumentException($t3DS_AuthenticationResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($t3DS_AuthenticationResultChoiceErrorMessage = self::validateT3DS_AuthenticationResultForChoiceConstraintsFromSetT3DS_AuthenticationResult($t3DS_AuthenticationResult))) {
            throw new \InvalidArgumentException($t3DS_AuthenticationResultChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($t3DS_AuthenticationResult) && count($t3DS_AuthenticationResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($t3DS_AuthenticationResult)), __LINE__);
        }
        if (is_null($t3DS_AuthenticationResult) || (is_array($t3DS_AuthenticationResult) && empty($t3DS_AuthenticationResult))) {
            unset($this->T3DS_AuthenticationResult);
        } else {
            $this->T3DS_AuthenticationResult = $t3DS_AuthenticationResult;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToT3DS_AuthenticationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToT3DS_AuthenticationResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToT3DS_AuthenticationResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BalanceInquiryResult',
            'VerificationResult',
            'DCC_Result',
            'MCP_Result',
            'AccountValidationResult',
            'AuthorizationResult',
            'ConfirmAuthResult',
            'CancelAuthResult',
            'RefundResult',
            'CancelRefundResult',
            'GetCardResult',
            'QueryDeferredPaymentResult',
            'GetBINResult',
            'GetDeploymentResult',
            'UpdateDeploymentResult',
            'GetCardActivityResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property T3DS_AuthenticationResult can\'t be set as the property %s is already set. Only one property must be set among these properties: T3DS_AuthenticationResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to T3DS_AuthenticationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\T3DS_AuthenticationResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToT3DS_AuthenticationResult(\StructType\T3DS_AuthenticationResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\T3DS_AuthenticationResultType) {
            throw new \InvalidArgumentException(sprintf('The T3DS_AuthenticationResult property can only contain items of type \StructType\T3DS_AuthenticationResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(BalanceInquiryResult, VerificationResult, DCC_Result, MCP_Result, AccountValidationResult, AuthorizationResult, ConfirmAuthResult, CancelAuthResult, RefundResult, CancelRefundResult, GetCardResult, QueryDeferredPaymentResult, GetBINResult, GetDeploymentResult, UpdateDeploymentResult, GetCardActivityResult, T3DS_AuthenticationResult)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToT3DS_AuthenticationResult($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->T3DS_AuthenticationResult) && count($this->T3DS_AuthenticationResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->T3DS_AuthenticationResult)), __LINE__);
        }
        $this->T3DS_AuthenticationResult[] = $item;
        return $this;
    }
    /**
     * Get CaptureResult value
     * @return \StructType\CaptureResult[]|null
     */
    public function getCaptureResult()
    {
        return $this->CaptureResult;
    }
    /**
     * This method is responsible for validating the values passed to the setCaptureResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaptureResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCaptureResultForArrayConstraintsFromSetCaptureResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSCaptureResultItem) {
            // validation for constraint: itemType
            if (!$paymentRSCaptureResultItem instanceof \StructType\CaptureResult) {
                $invalidValues[] = is_object($paymentRSCaptureResultItem) ? get_class($paymentRSCaptureResultItem) : sprintf('%s(%s)', gettype($paymentRSCaptureResultItem), var_export($paymentRSCaptureResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CaptureResult property can only contain items of type \StructType\CaptureResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CaptureResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CaptureResult[] $captureResult
     * @return \StructType\PaymentRS
     */
    public function setCaptureResult(array $captureResult = array())
    {
        // validation for constraint: array
        if ('' !== ($captureResultArrayErrorMessage = self::validateCaptureResultForArrayConstraintsFromSetCaptureResult($captureResult))) {
            throw new \InvalidArgumentException($captureResultArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($captureResult) && count($captureResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($captureResult)), __LINE__);
        }
        $this->CaptureResult = $captureResult;
        return $this;
    }
    /**
     * Add item to CaptureResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CaptureResult $item
     * @return \StructType\PaymentRS
     */
    public function addToCaptureResult(\StructType\CaptureResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CaptureResult) {
            throw new \InvalidArgumentException(sprintf('The CaptureResult property can only contain items of type \StructType\CaptureResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CaptureResult) && count($this->CaptureResult) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CaptureResult)), __LINE__);
        }
        $this->CaptureResult[] = $item;
        return $this;
    }
    /**
     * Get AccountDetail value
     * @return \StructType\AccountDetail[]|null
     */
    public function getAccountDetail()
    {
        return $this->AccountDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountDetailForArrayConstraintsFromSetAccountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSAccountDetailItem) {
            // validation for constraint: itemType
            if (!$paymentRSAccountDetailItem instanceof \StructType\AccountDetail) {
                $invalidValues[] = is_object($paymentRSAccountDetailItem) ? get_class($paymentRSAccountDetailItem) : sprintf('%s(%s)', gettype($paymentRSAccountDetailItem), var_export($paymentRSAccountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountDetail property can only contain items of type \StructType\AccountDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountDetail[] $accountDetail
     * @return \StructType\PaymentRS
     */
    public function setAccountDetail(array $accountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($accountDetailArrayErrorMessage = self::validateAccountDetailForArrayConstraintsFromSetAccountDetail($accountDetail))) {
            throw new \InvalidArgumentException($accountDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($accountDetail) && count($accountDetail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($accountDetail)), __LINE__);
        }
        $this->AccountDetail = $accountDetail;
        return $this;
    }
    /**
     * Add item to AccountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountDetail $item
     * @return \StructType\PaymentRS
     */
    public function addToAccountDetail(\StructType\AccountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountDetail) {
            throw new \InvalidArgumentException(sprintf('The AccountDetail property can only contain items of type \StructType\AccountDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->AccountDetail) && count($this->AccountDetail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->AccountDetail)), __LINE__);
        }
        $this->AccountDetail[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return \StructType\PaymentDetailType|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @param \StructType\PaymentDetailType $paymentDetail
     * @return \StructType\PaymentRS
     */
    public function setPaymentDetail(\StructType\PaymentDetailType $paymentDetail = null)
    {
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Get DeferredPaymentDetail value
     * @return \StructType\DeferredPaymentDetail|null
     */
    public function getDeferredPaymentDetail()
    {
        return $this->DeferredPaymentDetail;
    }
    /**
     * Set DeferredPaymentDetail value
     * @param \StructType\DeferredPaymentDetail $deferredPaymentDetail
     * @return \StructType\PaymentRS
     */
    public function setDeferredPaymentDetail(\StructType\DeferredPaymentDetail $deferredPaymentDetail = null)
    {
        $this->DeferredPaymentDetail = $deferredPaymentDetail;
        return $this;
    }
    /**
     * Get FraudScreenResult value
     * @return \StructType\FraudScreenResultType|null
     */
    public function getFraudScreenResult()
    {
        return $this->FraudScreenResult;
    }
    /**
     * Set FraudScreenResult value
     * @param \StructType\FraudScreenResultType $fraudScreenResult
     * @return \StructType\PaymentRS
     */
    public function setFraudScreenResult(\StructType\FraudScreenResultType $fraudScreenResult = null)
    {
        $this->FraudScreenResult = $fraudScreenResult;
        return $this;
    }
    /**
     * Get FraudRemarks value
     * @return \StructType\FraudRemarks|null
     */
    public function getFraudRemarks()
    {
        return $this->FraudRemarks;
    }
    /**
     * Set FraudRemarks value
     * @param \StructType\FraudRemarks $fraudRemarks
     * @return \StructType\PaymentRS
     */
    public function setFraudRemarks(\StructType\FraudRemarks $fraudRemarks = null)
    {
        $this->FraudRemarks = $fraudRemarks;
        return $this;
    }
    /**
     * Get TokenizationResults value
     * @return \StructType\TokenizationResultType[]|null
     */
    public function getTokenizationResults()
    {
        return $this->TokenizationResults;
    }
    /**
     * This method is responsible for validating the values passed to the setTokenizationResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTokenizationResults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTokenizationResultsForArrayConstraintsFromSetTokenizationResults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRSTokenizationResultsItem) {
            // validation for constraint: itemType
            if (!$paymentRSTokenizationResultsItem instanceof \StructType\TokenizationResultType) {
                $invalidValues[] = is_object($paymentRSTokenizationResultsItem) ? get_class($paymentRSTokenizationResultsItem) : sprintf('%s(%s)', gettype($paymentRSTokenizationResultsItem), var_export($paymentRSTokenizationResultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TokenizationResults property can only contain items of type \StructType\TokenizationResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TokenizationResults value
     * @throws \InvalidArgumentException
     * @param \StructType\TokenizationResultType[] $tokenizationResults
     * @return \StructType\PaymentRS
     */
    public function setTokenizationResults(array $tokenizationResults = array())
    {
        // validation for constraint: array
        if ('' !== ($tokenizationResultsArrayErrorMessage = self::validateTokenizationResultsForArrayConstraintsFromSetTokenizationResults($tokenizationResults))) {
            throw new \InvalidArgumentException($tokenizationResultsArrayErrorMessage, __LINE__);
        }
        $this->TokenizationResults = $tokenizationResults;
        return $this;
    }
    /**
     * Add item to TokenizationResults value
     * @throws \InvalidArgumentException
     * @param \StructType\TokenizationResultType $item
     * @return \StructType\PaymentRS
     */
    public function addToTokenizationResults(\StructType\TokenizationResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TokenizationResultType) {
            throw new \InvalidArgumentException(sprintf('The TokenizationResults property can only contain items of type \StructType\TokenizationResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TokenizationResults[] = $item;
        return $this;
    }
    /**
     * Get NotificationList value
     * @return \StructType\NotificationList|null
     */
    public function getNotificationList()
    {
        return $this->NotificationList;
    }
    /**
     * Set NotificationList value
     * @param \StructType\NotificationList $notificationList
     * @return \StructType\PaymentRS
     */
    public function setNotificationList(\StructType\NotificationList $notificationList = null)
    {
        $this->NotificationList = $notificationList;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\RemarksType $remarks
     * @return \StructType\PaymentRS
     */
    public function setRemarks(\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get DBIItems value
     * @return \StructType\DBIItems|null
     */
    public function getDBIItems()
    {
        return $this->DBIItems;
    }
    /**
     * Set DBIItems value
     * @param \StructType\DBIItems $dBIItems
     * @return \StructType\PaymentRS
     */
    public function setDBIItems(\StructType\DBIItems $dBIItems = null)
    {
        $this->DBIItems = $dBIItems;
        return $this;
    }
    /**
     * Get SabreTransactionID value
     * @return string|null
     */
    public function getSabreTransactionID()
    {
        return $this->SabreTransactionID;
    }
    /**
     * Set SabreTransactionID value
     * @param string $sabreTransactionID
     * @return \StructType\PaymentRS
     */
    public function setSabreTransactionID($sabreTransactionID = null)
    {
        // validation for constraint: string
        if (!is_null($sabreTransactionID) && !is_string($sabreTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sabreTransactionID, true), gettype($sabreTransactionID)), __LINE__);
        }
        $this->SabreTransactionID = $sabreTransactionID;
        return $this;
    }
    /**
     * Get DeferredPaymentID value
     * @return string|null
     */
    public function getDeferredPaymentID()
    {
        return $this->DeferredPaymentID;
    }
    /**
     * Set DeferredPaymentID value
     * @param string $deferredPaymentID
     * @return \StructType\PaymentRS
     */
    public function setDeferredPaymentID($deferredPaymentID = null)
    {
        // validation for constraint: string
        if (!is_null($deferredPaymentID) && !is_string($deferredPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredPaymentID, true), gettype($deferredPaymentID)), __LINE__);
        }
        $this->DeferredPaymentID = $deferredPaymentID;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\PaymentRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
}
